/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.Events;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.content.TypeIDs;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.traits.SaveTrait;
import io.anuke.mindustry.entities.traits.SyncTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.TimedEntity;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.TypeID;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Fire
extends TimedEntity
implements SaveTrait,
SyncTrait {
    private static final IntMap<Fire> map = new IntMap();
    private static final float baseLifetime = 1000.0f;
    private static final float spreadChance = 0.05f;
    private static final float fireballChance = 0.07f;
    private int loadedPosition = -1;
    private Tile tile;
    private Block block;
    private float baseFlammability = -1.0f;
    private float puddleFlammability;
    private float lifetime;

    public static void onRemoveFire(int fid) {
        Vars.fireGroup.removeByID(fid);
    }

    public static void create(Tile tile) {
        if (Vars.net.client() || tile == null) {
            return;
        }
        Fire fire = map.get(tile.pos());
        if (fire == null) {
            fire = new Fire();
            fire.tile = tile;
            fire.lifetime = 1000.0f;
            fire.set(tile.worldx(), tile.worldy());
            fire.add();
            map.put(tile.pos(), fire);
        } else {
            fire.lifetime = 1000.0f;
            fire.time = 0.0f;
        }
    }

    public static boolean has(int x, int y) {
        if (!Structs.inBounds(x, y, Vars.world.width(), Vars.world.height()) || !map.containsKey(Pos.get(x, y))) {
            return false;
        }
        Fire fire = map.get(Pos.get(x, y));
        return fire.isAdded() && fire.fin() < 1.0f && fire.tile != null && fire.tile.x == x && fire.tile.y == y;
    }

    public static void extinguish(Tile tile, float intensity) {
        if (tile != null && map.containsKey(tile.pos())) {
            Fire fire = map.get(tile.pos());
            fire.time += intensity * Time.delta();
            if (fire.time >= fire.lifetime()) {
                Events.fire(EventType.Trigger.fireExtinguish);
            }
        }
    }

    @Override
    public TypeID getTypeID() {
        return TypeIDs.fire;
    }

    @Override
    public byte version() {
        return 0;
    }

    @Override
    public float lifetime() {
        return this.lifetime;
    }

    @Override
    public void update() {
        Object p;
        if (Mathf.chance(0.1 * (double)Time.delta())) {
            Effects.effect(Fx.fire, this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
        }
        if (Mathf.chance(0.05 * (double)Time.delta())) {
            Effects.effect(Fx.fireSmoke, this.x + Mathf.range(4.0f), this.y + Mathf.range(4.0f));
        }
        if (Mathf.chance(0.001 * (double)Time.delta())) {
            Sounds.fire.at(this);
        }
        this.time = Mathf.clamp(this.time + Time.delta(), 0.0f, this.lifetime());
        map.put(this.tile.pos(), this);
        if (Vars.net.client()) {
            return;
        }
        if (this.time >= this.lifetime() || this.tile == null) {
            this.remove();
            return;
        }
        TileEntity entity = this.tile.link().entity;
        boolean damage = entity != null;
        float flammability = this.baseFlammability + this.puddleFlammability;
        if (!damage && flammability <= 0.0f) {
            this.time += Time.delta() * 8.0f;
        }
        if (this.baseFlammability < 0.0f || this.block != this.tile.block()) {
            this.baseFlammability = this.tile.block().getFlammability(this.tile);
            this.block = this.tile.block();
        }
        if (damage) {
            this.lifetime += Mathf.clamp(flammability / 8.0f, 0.0f, 0.6f) * Time.delta();
        }
        if (flammability > 1.0f && Mathf.chance(0.05f * Time.delta() * Mathf.clamp(flammability / 5.0f, 0.3f, 2.0f))) {
            p = Geometry.d4[Mathf.random(3)];
            Tile other = Vars.world.tile(this.tile.x + ((Point2)p).x, this.tile.y + ((Point2)p).y);
            Fire.create(other);
            if (Mathf.chance(0.07f * Time.delta() * Mathf.clamp(flammability / 10.0f))) {
                Call.createBullet(Bullets.fireball, this.x, this.y, Mathf.random(360.0f));
            }
        }
        if (Mathf.chance(0.1 * (double)Time.delta())) {
            p = Puddle.getPuddle(this.tile);
            this.puddleFlammability = p != null ? ((Puddle)p).getFlammability() / 3.0f : 0.0f;
            if (damage) {
                entity.damage(0.4f);
            }
            Damage.damageUnits(null, this.tile.worldx(), this.tile.worldy(), 8.0f, 3.0f, unit -> !unit.isFlying() && !unit.isImmune(StatusEffects.burning), unit -> unit.applyEffect(StatusEffects.burning, 300.0f));
        }
    }

    @Override
    public void writeSave(DataOutput stream) throws IOException {
        stream.writeInt(this.tile.pos());
        stream.writeFloat(this.lifetime);
        stream.writeFloat(this.time);
    }

    @Override
    public void readSave(DataInput stream, byte version) throws IOException {
        this.loadedPosition = stream.readInt();
        this.lifetime = stream.readFloat();
        this.time = stream.readFloat();
        this.add();
    }

    @Override
    public void write(DataOutput data) throws IOException {
        data.writeInt(this.tile.pos());
        data.writeFloat(this.lifetime);
    }

    @Override
    public void read(DataInput data) throws IOException {
        int pos = data.readInt();
        this.lifetime = data.readFloat();
        this.x = Pos.x(pos) * 8;
        this.y = Pos.y(pos) * 8;
        this.tile = Vars.world.tile(pos);
    }

    @Override
    public void reset() {
        this.loadedPosition = -1;
        this.tile = null;
        this.baseFlammability = -1.0f;
        this.puddleFlammability = 0.0f;
        this.incrementID();
    }

    @Override
    public void added() {
        if (this.loadedPosition != -1) {
            map.put(this.loadedPosition, this);
            this.tile = Vars.world.tile(this.loadedPosition);
            this.set(this.tile.worldx(), this.tile.worldy());
        }
    }

    @Override
    public void removed() {
        if (this.tile != null) {
            Call.onRemoveFire(this.id);
            map.remove(this.tile.pos());
        }
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.fireGroup;
    }
}

