/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.EffectEntity;
import io.anuke.mindustry.world.Tile;

public class GroundEffectEntity
extends EffectEntity {
    private boolean once;

    @Override
    public void update() {
        GroundEffect effect = (GroundEffect)this.effect;
        if (effect.isStatic) {
            this.time += Time.delta();
            this.time = Mathf.clamp(this.time, 0.0f, effect.staticLife);
            if (!this.once && this.time >= this.lifetime()) {
                this.once = true;
                this.time = 0.0f;
                Tile tile = Vars.world.tileWorld(this.x, this.y);
                if (tile != null && tile.floor().isLiquid) {
                    this.remove();
                }
            } else if (this.once && this.time >= effect.staticLife) {
                this.remove();
            }
        } else {
            super.update();
        }
    }

    @Override
    public void draw() {
        GroundEffect effect = (GroundEffect)this.effect;
        if (this.once && effect.isStatic) {
            Effects.renderEffect(this.id, effect, this.color, this.lifetime(), this.rotation, this.x, this.y, this.data);
        } else {
            Effects.renderEffect(this.id, effect, this.color, this.time, this.rotation, this.x, this.y, this.data);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.once = false;
    }

    public static class GroundEffect
    extends Effects.Effect {
        public final float staticLife;
        public final boolean isStatic;

        public GroundEffect(float life, float staticLife, Effects.EffectRenderer draw) {
            super(life, draw);
            this.staticLife = staticLife;
            this.isStatic = true;
        }

        public GroundEffect(boolean isStatic, float life, Effects.EffectRenderer draw) {
            super(life, draw);
            this.staticLife = 0.0f;
            this.isStatic = isStatic;
        }

        public GroundEffect(float life, Effects.EffectRenderer draw) {
            super(life, draw);
            this.staticLife = 0.0f;
            this.isStatic = false;
        }
    }
}

