/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Position;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.type.TimedEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Tile;

public class ItemTransfer
extends TimedEntity
implements DrawTrait {
    private Vector2 from = new Vector2();
    private Vector2 current = new Vector2();
    private Vector2 tovec = new Vector2();
    private Item item;
    private float seed;
    private Position to;
    private Runnable done;

    public static void transferItemEffect(Item item, float x, float y, Unit to) {
        if (to == null) {
            return;
        }
        ItemTransfer.create(item, x, y, to, () -> {});
    }

    public static void transferItemToUnit(Item item, float x, float y, Unit to) {
        if (to == null) {
            return;
        }
        ItemTransfer.create(item, x, y, to, () -> to.addItem(item));
    }

    public static void transferItemTo(Item item, int amount, float x, float y, Tile tile) {
        if (tile == null || tile.entity == null || tile.entity.items == null) {
            return;
        }
        if (!Units.canInteract(Vars.player, tile)) {
            return;
        }
        for (int i = 0; i < Mathf.clamp(amount / 3, 1, 8); ++i) {
            Time.run(i * 3, () -> ItemTransfer.create(item, x, y, tile, () -> {}));
        }
        tile.entity.items.add(item, amount);
    }

    public static void create(Item item, float fromx, float fromy, Position to, Runnable done) {
        ItemTransfer tr = Pools.obtain(ItemTransfer.class, ItemTransfer::new);
        tr.item = item;
        tr.from.set(fromx, fromy);
        tr.to = to;
        tr.done = done;
        tr.seed = Mathf.range(1.0f);
        tr.add();
    }

    @Override
    public float lifetime() {
        return 60.0f;
    }

    @Override
    public void reset() {
        super.reset();
        this.item = null;
        this.to = null;
        this.done = null;
        this.from.setZero();
        this.current.setZero();
        this.tovec.setZero();
    }

    @Override
    public void removed() {
        if (this.done != null) {
            this.done.run();
        }
        Pools.free(this);
    }

    @Override
    public void update() {
        if (this.to == null) {
            this.remove();
            return;
        }
        super.update();
        this.current.set(this.from).interpolate(this.tovec.set(this.to.getX(), this.to.getY()), this.fin(), (Interpolation)Interpolation.pow3);
        this.current.add(this.tovec.set(this.to.getX(), this.to.getY()).sub(this.from).nor().rotate90(1).scl(this.seed * this.fslope() * 10.0f));
        this.set(this.current.x, this.current.y);
    }

    @Override
    public void draw() {
        Lines.stroke(this.fslope() * 2.0f, Pal.accent);
        Lines.circle(this.x, this.y, this.fslope() * 2.0f);
        Draw.color(this.item.color);
        Fill.circle(this.x, this.y, this.fslope() * 1.5f);
        Draw.reset();
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.effectGroup;
    }
}

