/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.RandomXS128;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Position;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Bullets;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.TimeTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.TimedEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Pal;

public class Lightning
extends TimedEntity
implements DrawTrait,
TimeTrait {
    public static final float lifetime = 10.0f;
    private static final RandomXS128 random = new RandomXS128();
    private static final Rectangle rect = new Rectangle();
    private static final Array<Unit> entities = new Array();
    private static final IntSet hit = new IntSet();
    private static final int maxChain = 8;
    private static final float hitRange = 30.0f;
    private static int lastSeed = 0;
    private Array<Position> lines = new Array();
    private Color color = Pal.lancerLaser;

    public static void create(Team team, Color color, float damage, float x, float y, float targetAngle, int length) {
        Call.createLighting(lastSeed++, team, color, damage, x, y, targetAngle, length);
    }

    public static void createLighting(int seed, Team team, Color color, float damage, float x, float y, float rotation, int length) {
        Lightning l = Pools.obtain(Lightning.class, Lightning::new);
        Float dmg = Float.valueOf(damage);
        l.x = x;
        l.y = y;
        l.color = color;
        l.add();
        random.setSeed(seed);
        hit.clear();
        for (int i = 0; i < length / 2; ++i) {
            Unit furthest;
            Bullet.create(Bullets.damageLightning, l, team, x, y, 0.0f, 1.0f, 1.0f, dmg);
            l.lines.add(new Vector2(x + Mathf.range(3.0f), y + Mathf.range(3.0f)));
            rect.setSize(30.0f).setCenter(x, y);
            entities.clear();
            if (Lightning.hit.size < 8) {
                Units.nearbyEnemies(team, rect, u -> {
                    if (!hit.contains(u.getID())) {
                        entities.add((Unit)u);
                    }
                });
            }
            if ((furthest = Geometry.findFurthest(x, y, entities)) != null) {
                hit.add(furthest.getID());
                x = furthest.x;
                y = furthest.y;
                continue;
            }
            x += Angles.trnsx(rotation += random.range(20.0f), 15.0f);
            y += Angles.trnsy(rotation, 15.0f);
        }
    }

    @Override
    public float lifetime() {
        return 10.0f;
    }

    @Override
    public void reset() {
        super.reset();
        this.color = Pal.lancerLaser;
        this.lines.clear();
    }

    @Override
    public void removed() {
        super.removed();
        Pools.free(this);
    }

    @Override
    public void draw() {
        Lines.stroke(3.0f * this.fout());
        Draw.color(this.color, Color.white, this.fin());
        Lines.beginLine();
        Lines.linePoint(this.x, this.y);
        for (Position p : this.lines) {
            Lines.linePoint(p.getX(), p.getY());
        }
        Lines.endLine();
        int i = 0;
        for (Position p : this.lines) {
            Fill.square(p.getX(), p.getY(), (5.0f - (float)i++ / (float)this.lines.size * 2.0f) * this.fout(), 45.0f);
        }
        Draw.reset();
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.bulletGroup;
    }
}

