/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.effect.Decal;

public class RubbleDecal
extends Decal {
    private TextureRegion region;

    public static void create(float x, float y, int size) {
        if (Vars.headless) {
            return;
        }
        RubbleDecal decal = new RubbleDecal();
        decal.region = Core.atlas.find("rubble-" + size + "-" + Mathf.randomSeed(decal.id, 0, 1));
        if (!Core.atlas.isFound(decal.region)) {
            return;
        }
        decal.set(x, y);
        decal.add();
    }

    @Override
    public float lifetime() {
        return 8200.0f;
    }

    @Override
    public void drawDecal() {
        if (!Core.atlas.isFound(this.region)) {
            this.remove();
            return;
        }
        Draw.rect(this.region, this.x, this.y, (float)(Mathf.randomSeed(this.id, 0, 4) * 90));
    }
}

