/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.effect;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.effect.Decal;
import io.anuke.mindustry.world.Tile;

public class ScorchDecal
extends Decal {
    private static final int scorches = 5;
    private static final TextureRegion[] regions = new TextureRegion[5];

    public static void create(float x, float y) {
        Tile tile;
        if (Vars.headless) {
            return;
        }
        if (regions[0] == null || regions[0].getTexture().isDisposed()) {
            for (int i = 0; i < regions.length; ++i) {
                ScorchDecal.regions[i] = Core.atlas.find("scorch" + (i + 1));
            }
        }
        if ((tile = Vars.world.tileWorld(x, y)) == null || tile.floor().liquidDrop != null) {
            return;
        }
        ScorchDecal decal = new ScorchDecal();
        decal.set(x, y);
        decal.add();
    }

    @Override
    public void drawDecal() {
        for (int i = 0; i < 3; ++i) {
            TextureRegion region = regions[Mathf.randomSeed(this.id - i, 0, 4)];
            float rotation = Mathf.randomSeed(this.id + i, 0, 360);
            float space = 1.5f + (float)Mathf.randomSeed(this.id + i + 1, 0, 20) / 10.0f;
            Draw.rect(region, this.x + Angles.trnsx(rotation, space), this.y + Angles.trnsy(rotation, space) + (float)region.getHeight() / 2.0f * Draw.scl, (float)region.getWidth() * Draw.scl, (float)region.getHeight() * Draw.scl, (float)region.getWidth() / 2.0f * Draw.scl, 0.0f, rotation - 90.0f);
        }
    }
}

