/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.traits;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.graphics.Drawf;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Tile;

public interface MinerTrait
extends Entity {
    default public float getMiningRange() {
        return 70.0f;
    }

    default public boolean isMining() {
        return this.getMineTile() != null;
    }

    public Tile getMineTile();

    public void setMineTile(Tile var1);

    public float getMinePower();

    public boolean canMine(Item var1);

    default public void updateMining() {
        Unit unit = (Unit)((Object)this);
        Tile tile = this.getMineTile();
        TileEntity core = unit.getClosestCore();
        if (tile == null || core == null || tile.block() != Blocks.air || this.dst(tile.worldx(), tile.worldy()) > this.getMiningRange() || tile.drop() == null || !unit.acceptsItem(tile.drop()) || !this.canMine(tile.drop())) {
            this.setMineTile(null);
        } else {
            Item item = tile.drop();
            unit.rotation = Mathf.slerpDelta(unit.rotation, unit.angleTo(tile.worldx(), tile.worldy()), 0.4f);
            if (Mathf.chance((double)Time.delta() * (0.06 - (double)item.hardness * 0.01) * (double)this.getMinePower())) {
                if (unit.dst(core) < 220.0f && core.tile.block().acceptStack(item, 1, core.tile, unit) == 1) {
                    Call.transferItemTo(item, 1, tile.worldx() + Mathf.range(4.0f), tile.worldy() + Mathf.range(4.0f), core.tile);
                } else if (unit.acceptsItem(item)) {
                    Call.transferItemToUnit(item, tile.worldx() + Mathf.range(4.0f), tile.worldy() + Mathf.range(4.0f), unit);
                }
            }
            if (Mathf.chance(0.06 * (double)Time.delta())) {
                Effects.effect(Fx.pulverizeSmall, tile.worldx() + Mathf.range(4.0f), tile.worldy() + Mathf.range(4.0f), 0.0f, item.color);
            }
        }
    }

    default public void drawMining() {
        Unit unit = (Unit)((Object)this);
        Tile tile = this.getMineTile();
        if (tile == null) {
            return;
        }
        float focusLen = 4.0f + Mathf.absin(Time.time(), 1.1f, 0.5f);
        float swingScl = 12.0f;
        float swingMag = 1.0f;
        float flashScl = 0.3f;
        float px = unit.x + Angles.trnsx(unit.rotation, focusLen);
        float py = unit.y + Angles.trnsy(unit.rotation, focusLen);
        float ex = tile.worldx() + Mathf.sin(Time.time() + 48.0f, swingScl, swingMag);
        float ey = tile.worldy() + Mathf.sin(Time.time() + 48.0f, swingScl + 2.0f, swingMag);
        Draw.color(Color.lightGray, Color.white, 1.0f - flashScl + Mathf.absin(Time.time(), 0.5f, flashScl));
        Drawf.laser(Core.atlas.find("minelaser"), Core.atlas.find("minelaser-end"), px, py, ex, ey, 0.75f);
        if (unit instanceof Player && ((Player)unit).isLocal) {
            Lines.stroke(1.0f, Pal.accent);
            Lines.poly(tile.worldx(), tile.worldy(), 4, 4.0f * Mathf.sqrt2, Time.time());
        }
        Draw.color();
    }
}

