/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.traits.AbsorbTrait;
import io.anuke.mindustry.entities.traits.DamageTrait;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.traits.ScaleTrait;
import io.anuke.mindustry.entities.traits.SolidTrait;
import io.anuke.mindustry.entities.traits.TeamTrait;
import io.anuke.mindustry.entities.traits.TimeTrait;
import io.anuke.mindustry.entities.traits.VelocityTrait;
import io.anuke.mindustry.entities.type.SolidEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Tile;

public class Bullet
extends SolidEntity
implements DamageTrait,
ScaleTrait,
Pool.Poolable,
DrawTrait,
VelocityTrait,
TimeTrait,
TeamTrait,
AbsorbTrait {
    public Interval timer = new Interval(3);
    private float lifeScl;
    private Team team;
    private Object data;
    private boolean supressCollision;
    private boolean supressOnce;
    private boolean initialized;
    private boolean deflected;
    protected BulletType type;
    protected Entity owner;
    protected float time;

    public static Bullet create(BulletType type, TeamTrait owner, float x, float y, float angle) {
        return Bullet.create(type, owner, owner.getTeam(), x, y, angle);
    }

    public static Bullet create(BulletType type, Entity owner, Team team, float x, float y, float angle) {
        return Bullet.create(type, owner, team, x, y, angle, 1.0f);
    }

    public static Bullet create(BulletType type, Entity owner, Team team, float x, float y, float angle, float velocityScl) {
        return Bullet.create(type, owner, team, x, y, angle, velocityScl, 1.0f, null);
    }

    public static Bullet create(BulletType type, Entity owner, Team team, float x, float y, float angle, float velocityScl, float lifetimeScl) {
        return Bullet.create(type, owner, team, x, y, angle, velocityScl, lifetimeScl, null);
    }

    public static Bullet create(BulletType type, Entity owner, Team team, float x, float y, float angle, float velocityScl, float lifetimeScl, Object data) {
        Bullet bullet = Pools.obtain(Bullet.class, Bullet::new);
        bullet.type = type;
        bullet.owner = owner;
        bullet.data = data;
        bullet.velocity.set(0.0f, type.speed).setAngle(angle).scl(velocityScl);
        if (type.keepVelocity) {
            bullet.velocity.add(owner instanceof VelocityTrait ? ((VelocityTrait)((Object)owner)).velocity() : Vector2.ZERO);
        }
        bullet.team = team;
        bullet.type = type;
        bullet.lifeScl = lifetimeScl;
        bullet.set(x - bullet.velocity.x * Time.delta(), y - bullet.velocity.y * Time.delta());
        bullet.add();
        return bullet;
    }

    public static Bullet create(BulletType type, Bullet parent, float x, float y, float angle) {
        return Bullet.create(type, parent.owner, parent.team, x, y, angle);
    }

    public static Bullet create(BulletType type, Bullet parent, float x, float y, float angle, float velocityScl) {
        return Bullet.create(type, parent.owner, parent.team, x, y, angle, velocityScl);
    }

    public static void createBullet(BulletType type, float x, float y, float angle) {
        Bullet.create(type, null, Team.derelict, x, y, angle);
    }

    public static void createBullet(BulletType type, Team team, float x, float y, float angle) {
        Bullet.create(type, null, team, x, y, angle);
    }

    public Entity getOwner() {
        return this.owner;
    }

    public boolean collidesTiles() {
        return this.type.collidesTiles;
    }

    public void deflect() {
        this.supressCollision = true;
        this.supressOnce = true;
        this.deflected = true;
    }

    public boolean isDeflected() {
        return this.deflected;
    }

    public BulletType getBulletType() {
        return this.type;
    }

    public void resetOwner(Entity entity, Team team) {
        this.owner = entity;
        this.team = team;
    }

    public void scaleTime(float add) {
        this.time += add;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public float damageMultiplier() {
        if (this.owner instanceof Unit) {
            return ((Unit)this.owner).getDamageMultipler();
        }
        return 1.0f;
    }

    @Override
    public void absorb() {
        this.supressCollision = true;
        this.remove();
    }

    @Override
    public float drawSize() {
        return this.type.drawSize;
    }

    @Override
    public float damage() {
        if (this.owner instanceof Lightning && this.data instanceof Float) {
            return ((Float)this.data).floatValue();
        }
        return this.type.damage * this.damageMultiplier();
    }

    @Override
    public Team getTeam() {
        return this.team;
    }

    @Override
    public float getShieldDamage() {
        return Math.max(this.damage(), this.type.splashDamage);
    }

    @Override
    public boolean collides(SolidTrait other) {
        return this.type.collides && other != this.owner && !(other instanceof DamageTrait) && !this.supressCollision && (!(other instanceof Unit) || !((Unit)other).isFlying() || this.type.collidesAir);
    }

    @Override
    public void collision(SolidTrait other, float x, float y) {
        if (!this.type.pierce) {
            this.remove();
        }
        this.type.hit(this, x, y);
        if (other instanceof Unit) {
            Unit unit = (Unit)other;
            unit.velocity().add(Tmp.v3.set(other.getX(), other.getY()).sub(x, y).setLength(this.type.knockback / unit.mass()));
            unit.applyEffect(this.type.status, this.type.statusDuration);
        }
    }

    @Override
    public void update() {
        this.type.update(this);
        this.x += this.velocity.x * Time.delta();
        this.y += this.velocity.y * Time.delta();
        this.velocity.scl(Mathf.clamp(1.0f - this.type.drag * Time.delta()));
        this.time += Time.delta() * 1.0f / this.lifeScl;
        this.time = Mathf.clamp(this.time, 0.0f, this.type.lifetime);
        if (this.time >= this.type.lifetime) {
            if (!this.supressCollision) {
                this.type.despawned(this);
            }
            this.remove();
        }
        if (this.type.hitTiles && this.collidesTiles() && !this.supressCollision && this.initialized) {
            Vars.world.raycastEach(Vars.world.toTile(this.lastPosition().x), Vars.world.toTile(this.lastPosition().y), Vars.world.toTile(this.x), Vars.world.toTile(this.y), (x, y) -> {
                Tile tile = Vars.world.ltile(x, y);
                if (tile == null) {
                    return false;
                }
                if (tile.entity != null && tile.entity.collide(this) && this.type.collides(this, tile) && !tile.entity.isDead() && (this.type.collidesTeam || tile.getTeam() != this.team)) {
                    if (tile.getTeam() != this.team) {
                        tile.entity.collision(this);
                    }
                    if (!this.supressCollision) {
                        this.type.hitTile(this, tile);
                        this.remove();
                    }
                    return true;
                }
                return false;
            });
        }
        if (this.supressOnce) {
            this.supressCollision = false;
            this.supressOnce = false;
        }
        this.initialized = true;
    }

    @Override
    public void reset() {
        this.type = null;
        this.owner = null;
        this.velocity.setZero();
        this.time = 0.0f;
        this.timer.clear();
        this.lifeScl = 1.0f;
        this.team = null;
        this.data = null;
        this.supressCollision = false;
        this.supressOnce = false;
        this.deflected = false;
        this.initialized = false;
    }

    @Override
    public void hitbox(Rectangle rectangle) {
        rectangle.setSize(this.type.hitSize).setCenter(this.x, this.y);
    }

    @Override
    public void hitboxTile(Rectangle rectangle) {
        rectangle.setSize(this.type.hitSize).setCenter(this.x, this.y);
    }

    @Override
    public float lifetime() {
        return this.type.lifetime;
    }

    @Override
    public void time(float time) {
        this.time = time;
    }

    @Override
    public float time() {
        return this.time;
    }

    @Override
    public void removed() {
        Pools.free(this);
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.bulletGroup;
    }

    @Override
    public void added() {
        this.type.init(this);
    }

    @Override
    public void draw() {
        this.type.draw(this);
    }

    @Override
    public float fin() {
        return this.time / this.type.lifetime;
    }

    @Override
    public Vector2 velocity() {
        return this.velocity;
    }

    public void velocity(float speed, float angle) {
        this.velocity.set(0.0f, speed).setAngle(angle);
    }

    public void limit(float f) {
        this.velocity.limit(f);
    }

    public void rot(float angle) {
        this.velocity.setAngle(angle);
    }

    public float rot() {
        float angle = Mathf.atan2(this.velocity.x, this.velocity.y) * 57.295776f;
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        return angle;
    }
}

