/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.util.pooling.Pool;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.Entity;
import io.anuke.mindustry.entities.type.TimedEntity;

public class EffectEntity
extends TimedEntity
implements Pool.Poolable,
DrawTrait {
    public Effects.Effect effect;
    public Color color = new Color(Color.white);
    public Object data;
    public float rotation = 0.0f;
    public Entity parent;
    public float poffsetx;
    public float poffsety;

    public void setParent(Entity parent) {
        this.parent = parent;
        this.poffsetx = this.x - parent.getX();
        this.poffsety = this.y - parent.getY();
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.effectGroup;
    }

    @Override
    public float lifetime() {
        return this.effect.lifetime;
    }

    @Override
    public float drawSize() {
        return this.effect.size;
    }

    @Override
    public void update() {
        if (this.effect == null) {
            this.remove();
            return;
        }
        super.update();
        if (this.parent != null) {
            this.x = this.parent.getX() + this.poffsetx;
            this.y = this.parent.getY() + this.poffsety;
        }
    }

    @Override
    public void reset() {
        this.effect = null;
        this.color.set(Color.white);
        this.poffsety = 0.0f;
        this.poffsetx = 0.0f;
        this.time = 0.0f;
        this.rotation = 0.0f;
        this.parent = null;
        this.data = null;
    }

    @Override
    public void draw() {
        Effects.renderEffect(this.id, this.effect, this.color, this.time, this.rotation, this.x, this.y, this.data);
    }

    @Override
    public void removed() {
        Pools.free(this);
    }
}

