/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Predict;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockFlag;

public abstract class FlyingUnit
extends BaseUnit {
    protected float[] weaponAngles = new float[]{0.0f, 0.0f};
    protected final UnitState attack = new UnitState(){

        @Override
        public void entered() {
            FlyingUnit.this.target = null;
        }

        @Override
        public void update() {
            if (Units.invalidateTarget(FlyingUnit.this.target, FlyingUnit.this.team, FlyingUnit.this.x, FlyingUnit.this.y)) {
                FlyingUnit.this.target = null;
            }
            if (FlyingUnit.this.retarget()) {
                FlyingUnit.this.targetClosest();
                if (FlyingUnit.this.target == null) {
                    FlyingUnit.this.targetClosestEnemyFlag(BlockFlag.producer);
                }
                if (FlyingUnit.this.target == null) {
                    FlyingUnit.this.targetClosestEnemyFlag(BlockFlag.turret);
                }
            }
            if (FlyingUnit.this.getClosestSpawner() == null && FlyingUnit.this.getSpawner() != null && FlyingUnit.this.target == null) {
                FlyingUnit.this.target = FlyingUnit.this.getSpawner();
                FlyingUnit.this.circle(80.0f + Mathf.randomSeed(FlyingUnit.this.id) * 120.0f);
            } else if (FlyingUnit.this.target != null) {
                FlyingUnit.this.attack(FlyingUnit.this.type.attackLength);
                if ((Angles.near(FlyingUnit.this.angleTo(FlyingUnit.this.target), FlyingUnit.this.rotation, FlyingUnit.this.type.shootCone) || FlyingUnit.this.getWeapon().ignoreRotation) && FlyingUnit.this.dst(FlyingUnit.this.target) < FlyingUnit.this.getWeapon().bullet.range()) {
                    BulletType ammo = FlyingUnit.this.getWeapon().bullet;
                    if (FlyingUnit.this.type.rotateWeapon) {
                        for (boolean left : Mathf.booleans) {
                            int wi = Mathf.num(left);
                            float wx = FlyingUnit.this.x + Angles.trnsx(FlyingUnit.this.rotation - 90.0f, FlyingUnit.this.getWeapon().width * (float)Mathf.sign(left));
                            float wy = FlyingUnit.this.y + Angles.trnsy(FlyingUnit.this.rotation - 90.0f, FlyingUnit.this.getWeapon().width * (float)Mathf.sign(left));
                            FlyingUnit.this.weaponAngles[wi] = Mathf.slerpDelta(FlyingUnit.this.weaponAngles[wi], Angles.angle(wx, wy, FlyingUnit.this.target.getX(), FlyingUnit.this.target.getY()), 0.1f);
                            Tmp.v2.trns(FlyingUnit.this.weaponAngles[wi], FlyingUnit.this.getWeapon().length);
                            FlyingUnit.this.getWeapon().update(FlyingUnit.this, wx + Tmp.v2.x, wy + Tmp.v2.y, FlyingUnit.this.weaponAngles[wi], left);
                        }
                    } else {
                        Vector2 to = Predict.intercept(FlyingUnit.this, FlyingUnit.this.target, ammo.speed);
                        FlyingUnit.this.getWeapon().update(FlyingUnit.this, to.x, to.y);
                    }
                }
            } else {
                FlyingUnit.this.target = FlyingUnit.this.getClosestSpawner();
                FlyingUnit.this.moveTo(Vars.state.rules.dropZoneRadius + 120.0f);
            }
        }
    };
    protected final UnitState rally = new UnitState(){

        @Override
        public void update() {
            if (FlyingUnit.this.retarget()) {
                FlyingUnit.this.targetClosestAllyFlag(BlockFlag.rally);
                FlyingUnit.this.targetClosest();
                if (FlyingUnit.this.target != null && !Units.invalidateTarget(FlyingUnit.this.target, FlyingUnit.this.team, FlyingUnit.this.x, FlyingUnit.this.y)) {
                    FlyingUnit.this.setState(FlyingUnit.this.attack);
                    return;
                }
                if (FlyingUnit.this.target == null) {
                    FlyingUnit.this.target = FlyingUnit.this.getSpawner();
                }
            }
            if (FlyingUnit.this.target != null) {
                FlyingUnit.this.circle(65.0f + Mathf.randomSeed(FlyingUnit.this.id) * 100.0f);
            }
        }
    };
    protected final UnitState retreat = new UnitState(){

        @Override
        public void entered() {
            FlyingUnit.this.target = null;
        }

        @Override
        public void update() {
            if (FlyingUnit.this.retarget()) {
                FlyingUnit.this.target = FlyingUnit.this.getSpawner();
                Tile repair = Geometry.findClosest(FlyingUnit.this.x, FlyingUnit.this.y, Vars.indexer.getAllied(FlyingUnit.this.team, BlockFlag.repair));
                if (repair != null && FlyingUnit.this.damaged()) {
                    FlyingUnit.this.target = repair.entity;
                }
                if (FlyingUnit.this.target == null) {
                    FlyingUnit.this.target = FlyingUnit.this.getClosestCore();
                }
            }
            FlyingUnit.this.circle(FlyingUnit.this.targetHasFlag(BlockFlag.repair) ? 20.0f : 60.0f + Mathf.randomSeed(FlyingUnit.this.id) * 50.0f, 0.65f * FlyingUnit.this.type.speed);
        }
    };

    @Override
    public void onCommand(UnitCommand command) {
        this.state.set(command == UnitCommand.retreat ? this.retreat : (command == UnitCommand.attack ? this.attack : (command == UnitCommand.rally ? this.rally : null)));
    }

    @Override
    public void move(float x, float y) {
        this.moveBy(x, y);
    }

    @Override
    public void update() {
        super.update();
        if (!Vars.net.client()) {
            this.updateRotation();
        }
        this.wobble();
    }

    @Override
    public void drawUnder() {
        this.drawEngine();
    }

    @Override
    public void draw() {
        Draw.mixcol(Color.white, this.hitTime / 9.0f);
        Draw.rect(this.type.region, this.x, this.y, this.rotation - 90.0f);
        this.drawWeapons();
        Draw.mixcol();
    }

    public void drawWeapons() {
    }

    public void drawEngine() {
        Draw.color(Pal.engine);
        Fill.circle(this.x + Angles.trnsx(this.rotation + 180.0f, this.type.engineOffset), this.y + Angles.trnsy(this.rotation + 180.0f, this.type.engineOffset), this.type.engineSize + Mathf.absin(Time.time(), 2.0f, this.type.engineSize / 4.0f));
        Draw.color(Color.white);
        Fill.circle(this.x + Angles.trnsx(this.rotation + 180.0f, this.type.engineOffset - 1.0f), this.y + Angles.trnsy(this.rotation + 180.0f, this.type.engineOffset - 1.0f), (this.type.engineSize + Mathf.absin(Time.time(), 2.0f, this.type.engineSize / 4.0f)) / 2.0f);
        Draw.color();
    }

    @Override
    public void behavior() {
        if (Units.invalidateTarget(this.target, this)) {
            for (boolean left : Mathf.booleans) {
                int wi = Mathf.num(left);
                this.weaponAngles[wi] = Mathf.slerpDelta(this.weaponAngles[wi], this.rotation, 0.1f);
            }
        }
    }

    @Override
    public UnitState getStartState() {
        return this.attack;
    }

    protected void wobble() {
        if (Vars.net.client()) {
            return;
        }
        this.x += Mathf.sin(Time.time() + (float)(this.id * 999), 25.0f, 0.05f) * Time.delta();
        this.y += Mathf.cos(Time.time() + (float)(this.id * 999), 25.0f, 0.05f) * Time.delta();
        if (this.velocity.len() <= 0.05f) {
            // empty if block
        }
    }

    protected void updateRotation() {
        this.rotation = this.velocity.angle();
    }

    protected void circle(float circleLength) {
        this.circle(circleLength, this.type.speed);
    }

    protected void circle(float circleLength, float speed) {
        if (this.target == null) {
            return;
        }
        Tmp.v1.set(this.target.getX() - this.x, this.target.getY() - this.y);
        if (Tmp.v1.len() < circleLength) {
            Tmp.v1.rotate((circleLength - Tmp.v1.len()) / circleLength * 180.0f);
        }
        Tmp.v1.setLength(speed * Time.delta());
        this.velocity.add(Tmp.v1);
    }

    protected void moveTo(float circleLength) {
        if (this.target == null) {
            return;
        }
        Tmp.v1.set(this.target.getX() - this.x, this.target.getY() - this.y);
        float length = circleLength <= 0.001f ? 1.0f : Mathf.clamp((this.dst(this.target) - circleLength) / 100.0f, -1.0f, 1.0f);
        Tmp.v1.setLength(this.type.speed * Time.delta() * length);
        if (length < -0.5f) {
            Tmp.v1.rotate(180.0f);
        } else if (length < 0.0f) {
            Tmp.v1.setZero();
        }
        this.velocity.add(Tmp.v1);
    }

    protected void attack(float circleLength) {
        Tmp.v1.set(this.target.getX() - this.x, this.target.getY() - this.y);
        float ang = this.angleTo(this.target);
        float diff = Angles.angleDist(ang, this.rotation);
        if (diff > 100.0f && Tmp.v1.len() < circleLength) {
            Tmp.v1.setAngle(this.velocity.angle());
        } else {
            Tmp.v1.setAngle(Mathf.slerpDelta(this.velocity.angle(), Tmp.v1.angle(), 0.44f));
        }
        Tmp.v1.setLength(this.type.speed * Time.delta());
        this.velocity.add(Tmp.v1);
    }
}

