/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Queue;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.BitmapFont;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.GlyphLayout;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Interval;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Pack;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.content.Mechs;
import io.anuke.mindustry.content.TypeIDs;
import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.Predict;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.traits.BuilderMinerTrait;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.ShooterTrait;
import io.anuke.mindustry.entities.traits.SpawnerTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.TypeID;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.input.MobileInput;
import io.anuke.mindustry.io.TypeIO;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import io.anuke.mindustry.world.blocks.Floor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Player
extends Unit
implements BuilderMinerTrait,
ShooterTrait {
    public static final int timerSync = 2;
    public static final int timerAbility = 3;
    public static final int timerTransfer = 4;
    private static final int timerShootLeft = 0;
    private static final int timerShootRight = 1;
    private static final float liftoffBoost = 0.2f;
    private static final Rectangle rect = new Rectangle();
    public float baseRotation;
    public float pointerX;
    public float pointerY;
    public String name = "noname";
    public String uuid;
    public String usid;
    public boolean isAdmin;
    public boolean isTransferring;
    public boolean isShooting;
    public boolean isBoosting;
    public boolean isMobile;
    public boolean isTyping;
    public float boostHeat;
    public float shootHeat;
    public float destructTime;
    public boolean achievedFlight;
    public Color color = new Color();
    public Mech mech = Mechs.starter;
    public SpawnerTrait spawner;
    public SpawnerTrait lastSpawner;
    public int respawns;
    public NetConnection con;
    public boolean isLocal = false;
    public Interval timer = new Interval(6);
    public TargetTrait target;
    public TargetTrait moveTarget;
    public String lastText;
    public float textFadeTime;
    private float walktime;
    private float itemtime;
    private Queue<BuilderTrait.BuildRequest> placeQueue = new Queue();
    private Tile mining;
    private Vector2 movement = new Vector2();
    private boolean moved;

    public static void onPlayerDeath(Player player) {
        if (player == null) {
            return;
        }
        player.dead = true;
        player.placeQueue.clear();
        player.onDeath();
    }

    @Override
    public float getDamageMultipler() {
        return this.status.getDamageMultiplier() * Vars.state.rules.playerDamageMultiplier;
    }

    @Override
    public void hitbox(Rectangle rectangle) {
        rectangle.setSize(this.mech.hitsize).setCenter(this.x, this.y);
    }

    @Override
    public void hitboxTile(Rectangle rectangle) {
        rectangle.setSize(this.mech.hitsize * 2.0f / 3.0f).setCenter(this.x, this.y);
    }

    @Override
    public void onRespawn(Tile tile) {
        this.velocity.setZero();
        this.boostHeat = 1.0f;
        this.achievedFlight = true;
        this.rotation = 90.0f;
        this.baseRotation = 90.0f;
        this.dead = false;
        this.spawner = null;
        --this.respawns;
        Sounds.respawn.at(tile);
        this.setNet(tile.drawx(), tile.drawy());
        this.clearItem();
        this.heal();
    }

    @Override
    public TypeID getTypeID() {
        return TypeIDs.player;
    }

    @Override
    public void move(float x, float y) {
        if (!this.mech.flying) {
            Vars.collisions.move(this, x, y);
        } else {
            this.moveBy(x, y);
        }
    }

    @Override
    public float drag() {
        return this.mech.drag;
    }

    @Override
    public Interval getTimer() {
        return this.timer;
    }

    @Override
    public int getShootTimer(boolean left) {
        return left ? 0 : 1;
    }

    @Override
    public Weapon getWeapon() {
        return this.mech.weapon;
    }

    @Override
    public float getMinePower() {
        return this.mech.mineSpeed;
    }

    @Override
    public TextureRegion getIconRegion() {
        return this.mech.iconRegion;
    }

    @Override
    public int getItemCapacity() {
        return this.mech.itemCapacity;
    }

    @Override
    public void interpolate() {
        super.interpolate();
        if (this.interpolator.values.length > 1) {
            this.baseRotation = this.interpolator.values[1];
        }
        if (this.interpolator.target.dst(this.interpolator.last) > 1.0f) {
            this.walktime += Time.delta();
        }
    }

    @Override
    public float getBuildPower(Tile tile) {
        return this.mech.buildPower;
    }

    @Override
    public float maxHealth() {
        return this.mech.health * Vars.state.rules.playerHealthMultiplier;
    }

    @Override
    public Tile getMineTile() {
        return this.mining;
    }

    @Override
    public void setMineTile(Tile tile) {
        this.mining = tile;
    }

    @Override
    public boolean canMine(Item item) {
        return item.hardness <= this.mech.drillPower;
    }

    @Override
    public float calculateDamage(float amount) {
        return amount * Mathf.clamp(1.0f - (this.status.getArmorMultiplier() + this.mech.getExtraArmor(this)) / 100.0f);
    }

    @Override
    public void added() {
        this.baseRotation = 90.0f;
    }

    @Override
    public float mass() {
        return this.mech.mass;
    }

    @Override
    public boolean isFlying() {
        return this.mech.flying || this.boostHeat > 0.2f;
    }

    @Override
    public void damage(float amount) {
        this.hitTime = 9.0f;
        if (!Vars.net.client()) {
            this.health -= this.calculateDamage(amount);
        }
        if (this.health <= 0.0f && !this.dead) {
            Call.onPlayerDeath(this);
        }
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public float maxVelocity() {
        return this.mech.maxSpeed;
    }

    @Override
    public Queue<BuilderTrait.BuildRequest> buildQueue() {
        return this.placeQueue;
    }

    @Override
    public String toString() {
        return "Player{" + this.name + ", mech=" + this.mech.name + ", id=" + this.id + ", local=" + this.isLocal + ", " + this.x + ", " + this.y + "}";
    }

    @Override
    public EntityGroup targetGroup() {
        return Vars.playerGroup;
    }

    public void setTeam(Team team) {
        this.team = team;
    }

    @Override
    public float drawSize() {
        return this.isLocal ? Float.MAX_VALUE : 260.0f;
    }

    @Override
    public void drawShadow(float offsetX, float offsetY) {
        float scl = this.mech.flying ? 1.0f : this.boostHeat / 2.0f;
        Draw.rect(this.mech.iconRegion, this.x + offsetX * scl, this.y + offsetY * scl, this.rotation - 90.0f);
    }

    @Override
    public void draw() {
        if (this.dead) {
            return;
        }
        if (!this.movement.isZero() && this.moved && !Vars.state.isPaused()) {
            this.walktime += this.movement.len() * this.getFloorOn().speedMultiplier * 2.0f;
            this.baseRotation = Mathf.slerpDelta(this.baseRotation, this.movement.angle(), 0.13f);
        }
        float ft = Mathf.sin(this.walktime, 6.0f, 2.0f) * (1.0f - this.boostHeat);
        Floor floor = this.getFloorOn();
        Draw.color();
        Draw.mixcol(Color.white, this.hitTime / 9.0f);
        if (!this.mech.flying) {
            if (floor.isLiquid) {
                Draw.color(Color.white, floor.color, 0.5f);
            }
            float boostTrnsY = -this.boostHeat * 3.0f;
            float boostTrnsX = this.boostHeat * 3.0f;
            float boostAng = this.boostHeat * 40.0f;
            for (int i : Mathf.signs) {
                Draw.rect(this.mech.legRegion, this.x + Angles.trnsx(this.baseRotation, ft * (float)i + boostTrnsY, -boostTrnsX * (float)i), this.y + Angles.trnsy(this.baseRotation, ft * (float)i + boostTrnsY, -boostTrnsX * (float)i), (float)(this.mech.legRegion.getWidth() * i) * Draw.scl, ((float)this.mech.legRegion.getHeight() - Mathf.clamp(ft * (float)i, 0.0f, 2.0f)) * Draw.scl, this.baseRotation - 90.0f + boostAng * (float)i);
            }
            Draw.rect(this.mech.baseRegion, this.x, this.y, this.baseRotation - 90.0f);
        }
        if (floor.isLiquid) {
            Draw.color(Color.white, floor.color, this.drownTime);
        } else {
            Draw.color(Color.white);
        }
        Draw.rect(this.mech.region, this.x, this.y, this.rotation - 90.0f);
        this.mech.draw(this);
        for (int i : Mathf.signs) {
            float tra = this.rotation - 90.0f;
            float trY = -this.mech.weapon.getRecoil(this, i > 0) + this.mech.weaponOffsetY;
            float w = i > 0 ? (float)(-this.mech.weapon.region.getWidth()) : (float)this.mech.weapon.region.getWidth();
            Draw.rect(this.mech.weapon.region, this.x + Angles.trnsx(tra, (this.mech.weaponOffsetX + this.mech.spreadX(this)) * (float)i, trY), this.y + Angles.trnsy(tra, (this.mech.weaponOffsetX + this.mech.spreadX(this)) * (float)i, trY), w * Draw.scl, (float)this.mech.weapon.region.getHeight() * Draw.scl, this.rotation - 90.0f);
        }
        Draw.reset();
    }

    @Override
    public void drawStats() {
        Draw.color(Color.black, this.team.color, this.healthf() + Mathf.absin(Time.time(), this.healthf() * 5.0f, 1.0f - this.healthf()));
        Draw.rect(this.getPowerCellRegion(), this.x + Angles.trnsx(this.rotation, this.mech.cellTrnsY, 0.0f), this.y + Angles.trnsy(this.rotation, this.mech.cellTrnsY, 0.0f), this.rotation - 90.0f);
        Draw.reset();
        this.drawBackItems(this.itemtime, this.isLocal);
    }

    @Override
    public void drawOver() {
        if (this.dead) {
            return;
        }
        this.drawMechanics();
    }

    @Override
    public void drawUnder() {
        if (this.dead) {
            return;
        }
        float size = this.mech.engineSize * (this.mech.flying ? 1.0f : this.boostHeat);
        Draw.color(this.mech.engineColor);
        Fill.circle(this.x + Angles.trnsx(this.rotation + 180.0f, this.mech.engineOffset), this.y + Angles.trnsy(this.rotation + 180.0f, this.mech.engineOffset), size + Mathf.absin(Time.time(), 2.0f, size / 4.0f));
        Draw.color(Color.white);
        Fill.circle(this.x + Angles.trnsx(this.rotation + 180.0f, this.mech.engineOffset - 1.0f), this.y + Angles.trnsy(this.rotation + 180.0f, this.mech.engineOffset - 1.0f), (size + Mathf.absin(Time.time(), 2.0f, size / 4.0f)) / 2.0f);
        Draw.color();
    }

    public void drawName() {
        BitmapFont font = Fonts.def;
        GlyphLayout layout = Pools.obtain(GlyphLayout.class, GlyphLayout::new);
        float nameHeight = 11.0f;
        float textHeight = 15.0f;
        boolean ints = font.usesIntegerPositions();
        font.setUseIntegerPositions(false);
        font.getData().setScale(0.25f / Scl.scl(1.0f));
        layout.setText(font, this.name);
        if (!this.isLocal) {
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f);
            Fill.rect(this.x, this.y + 11.0f - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
            Draw.color();
            font.setColor(this.color);
            font.draw(this.name, this.x, this.y + 11.0f, 0.0f, 1, false);
            if (this.isAdmin) {
                float s = 3.0f;
                Draw.color(this.color.r * 0.5f, this.color.g * 0.5f, this.color.b * 0.5f, 1.0f);
                Draw.rect(Core.atlas.find("icon-admin-badge"), this.x + layout.width / 2.0f + 2.0f + 1.0f, this.y + 11.0f - 1.5f, s, s);
                Draw.color(this.color);
                Draw.rect(Core.atlas.find("icon-admin-badge"), this.x + layout.width / 2.0f + 2.0f + 1.0f, this.y + 11.0f - 1.0f, s, s);
            }
        }
        if (Core.settings.getBool("playerchat") && (this.textFadeTime > 0.0f && this.lastText != null || this.isTyping)) {
            String text = this.textFadeTime <= 0.0f || this.lastText == null ? "[LIGHT_GRAY]" + Strings.animated(Time.time(), 4, 15.0f, ".") : this.lastText;
            float width = 100.0f;
            float visualFadeTime = 1.0f - Mathf.curve(1.0f - this.textFadeTime, 0.9f);
            font.setColor(1.0f, 1.0f, 1.0f, this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime);
            layout.setText(font, text, Color.white, width, 4, true);
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f * (this.textFadeTime <= 0.0f || this.lastText == null ? 1.0f : visualFadeTime));
            Fill.rect(this.x, this.y + 15.0f + layout.height - layout.height / 2.0f, layout.width + 2.0f, layout.height + 3.0f);
            font.draw(text, this.x - width / 2.0f, this.y + 15.0f + layout.height, width, 1, true);
        }
        Draw.reset();
        Pools.free(layout);
        font.getData().setScale(1.0f);
        font.setColor(Color.white);
        font.setUseIntegerPositions(ints);
    }

    public void drawBuildRequests() {
        BuilderTrait.BuildRequest last = null;
        for (BuilderTrait.BuildRequest request : this.buildQueue()) {
            if (request.progress > 0.01f || this.buildRequest() == request && request.initialized && (this.dst(request.x * 8, request.y * 8) <= 220.0f || Vars.state.isEditor())) continue;
            if (request.breaking) {
                Block block = Vars.world.ltile(request.x, request.y).block();
                Lines.stroke(2.0f, Pal.removeBack);
                float rad = Mathf.absin(Time.time(), 7.0f, 1.0f) + (float)(block.size * 8) / 2.0f - 1.0f;
                Lines.square((float)(request.x * 8) + block.offset(), (float)(request.y * 8) + block.offset() - 1.0f, rad);
                Draw.color(Pal.remove);
                Lines.square((float)(request.x * 8) + block.offset(), (float)(request.y * 8) + block.offset(), rad);
                continue;
            }
            Draw.color();
            InputHandler.PlaceDraw draw = InputHandler.PlaceDraw.instance;
            draw.scalex = 1;
            draw.scaley = 1;
            draw.rotation = request.rotation;
            if (last == null) {
                request.block.getPlaceDraw(draw, request.rotation, request.x, request.y, request.rotation);
            } else {
                request.block.getPlaceDraw(draw, request.rotation, last.x - request.x, last.y - request.y, last.rotation);
            }
            TextureRegion region = draw.region;
            Draw.rect(region, (float)(request.x * 8) + request.block.offset(), (float)(request.y * 8) + request.block.offset(), (float)region.getWidth() * 1.0f * Draw.scl * (float)draw.scalex, (float)region.getHeight() * 1.0f * Draw.scl * (float)draw.scaley, request.block.rotate ? (float)(draw.rotation * 90) : 0.0f);
            Draw.color(Pal.accent);
            for (int i = 0; i < 4; ++i) {
                Point2 p = Geometry.d8edge[i];
                float offset = (float)(-Math.max(request.block.size - 1, 0)) / 2.0f * 8.0f;
                Draw.rect("block-select", (float)(request.x * 8) + request.block.offset() + offset * (float)p.x, (float)(request.y * 8) + request.block.offset() + offset * (float)p.y, (float)(i * 90));
            }
            Draw.color();
            last = request;
        }
        Draw.reset();
    }

    @Override
    public void update() {
        Tile tile;
        this.hitTime -= Time.delta();
        this.textFadeTime -= Time.delta() / 300.0f;
        this.itemtime = Mathf.lerpDelta(this.itemtime, Mathf.num(this.item.amount > 0), 0.1f);
        if (Float.isNaN(this.x) || Float.isNaN(this.y)) {
            this.velocity.set(0.0f, 0.0f);
            this.x = 0.0f;
            this.y = 0.0f;
            this.setDead(true);
        }
        if (Vars.netServer.isWaitingForPlayers()) {
            this.setDead(true);
        }
        if (!this.isDead() && this.isOutOfBounds()) {
            this.destructTime += Time.delta();
            if (this.destructTime >= 420.0f) {
                this.kill();
            }
        } else {
            this.destructTime = 0.0f;
        }
        if (!this.isDead() && this.isFlying()) {
            Vars.loops.play(Sounds.thruster, this, Mathf.clamp(this.velocity.len() * 2.0f) * 0.3f);
        }
        BuilderTrait.BuildRequest request = this.buildRequest();
        if (this.isBuilding() && request.tile() != null && (request.tile().withinDst(this.x, this.y, 220.0f) || Vars.state.isEditor())) {
            Vars.loops.play(Sounds.build, request.tile(), 0.75f);
        }
        if (this.isDead()) {
            this.isBoosting = false;
            this.boostHeat = 0.0f;
            if (this.respawns > 0 || !Vars.state.rules.limitedRespawns) {
                this.updateRespawning();
            }
            return;
        }
        this.spawner = null;
        if (this.isLocal || Vars.net.server()) {
            this.avoidOthers();
        }
        this.boostHeat = Mathf.lerpDelta(this.boostHeat, (tile = Vars.world.tileWorld(this.x, this.y)) != null && tile.solid() || this.isBoosting && (!this.movement.isZero() && this.moved || !this.isLocal) ? 1.0f : 0.0f, 0.08f);
        this.shootHeat = Mathf.lerpDelta(this.shootHeat, this.isShooting() ? 1.0f : 0.0f, 0.06f);
        this.mech.updateAlt(this);
        if (this.boostHeat > 0.3f) {
            this.achievedFlight = true;
        }
        if (this.boostHeat <= 0.25f && this.achievedFlight && !this.mech.flying) {
            if (tile != null) {
                if (this.mech.shake > 1.0f) {
                    Effects.shake(this.mech.shake, this.mech.shake, this);
                }
                Effects.effect(Fx.unitLand, tile.floor().color, this.x, this.y, tile.floor().isLiquid ? 1.0f : 0.5f);
            }
            this.mech.onLand(this);
            this.achievedFlight = false;
        }
        if (!this.isLocal) {
            this.interpolate();
            this.updateMechanics();
            this.status.update(this);
            this.updateVelocityStatus();
            if (Vars.net.server()) {
                this.updateShooting();
            }
            return;
        }
        if (Vars.world.isZone()) {
            Vars.data.unlockContent(this.mech);
        }
        if (Vars.control.input instanceof MobileInput) {
            this.updateTouch();
        } else {
            this.updateKeyboard();
        }
        this.isTyping = Vars.ui.chatfrag.chatOpen();
        this.updateMechanics();
        if (!this.mech.flying) {
            this.clampPosition();
        }
    }

    protected void updateKeyboard() {
        float speed;
        Tile tile = Vars.world.tileWorld(this.x, this.y);
        boolean bl = this.isBoosting = Core.input.keyDown(Binding.dash) && !this.mech.flying;
        if (tile != null && tile.solid()) {
            this.isBoosting = true;
        }
        float f = speed = this.isBoosting && !this.mech.flying ? this.mech.boostSpeed : this.mech.speed;
        if (this.mech.flying) {
            float penalty = 0.2f;
            speed *= Mathf.lerp(1.0f, penalty, Angles.angleDist(this.rotation, this.velocity.angle()) / 180.0f);
        }
        this.movement.setZero();
        float xa = Core.input.axis(Binding.move_x);
        float ya = Core.input.axis(Binding.move_y);
        if (!Core.input.keyDown(Binding.gridMode) && !(Core.scene.getKeyboardFocus() instanceof TextField)) {
            this.movement.y += ya * speed;
            this.movement.x += xa * speed;
        }
        Vector2 vec = Core.input.mouseWorld(Vars.control.input.getMouseX(), Vars.control.input.getMouseY());
        this.pointerX = vec.x;
        this.pointerY = vec.y;
        this.updateShooting();
        this.movement.limit(speed).scl(Time.delta());
        if (!Vars.ui.chatfrag.chatOpen()) {
            this.velocity.add(this.movement.x, this.movement.y);
        } else {
            this.isShooting = false;
        }
        float prex = this.x;
        float prey = this.y;
        this.updateVelocityStatus();
        boolean bl2 = this.moved = this.dst(prex, prey) > 0.001f;
        if (!Vars.ui.chatfrag.chatOpen()) {
            float baseLerp = this.mech.getRotationAlpha(this);
            if (!this.isShooting() || !this.mech.turnCursor) {
                if (!this.movement.isZero()) {
                    this.rotation = Mathf.slerpDelta(this.rotation, this.mech.flying ? this.velocity.angle() : this.movement.angle(), 0.13f * baseLerp);
                }
            } else {
                float angle = Vars.control.input.mouseAngle(this.x, this.y);
                this.rotation = Mathf.slerpDelta(this.rotation, angle, 0.1f * baseLerp);
            }
        }
    }

    protected void updateShooting() {
        if (!Vars.state.isEditor() && this.isShooting() && this.mech.canShoot(this)) {
            if (!this.mech.turnCursor) {
                this.mech.weapon.update(this, this.x + Angles.trnsx(this.rotation, 1.0f), this.y + Angles.trnsy(this.rotation, 1.0f));
            } else {
                this.mech.weapon.update(this, this.pointerX, this.pointerY);
            }
        }
    }

    protected void updateTouch() {
        float speed;
        if (!(!Units.invalidateTarget(this.target, this) || this.target instanceof TileEntity && ((TileEntity)this.target).damaged() && this.target.isValid() && this.target.getTeam() == this.team && this.mech.canHeal && this.dst(this.target) < this.getWeapon().bullet.range() && !(((TileEntity)this.target).block instanceof BuildBlock))) {
            this.target = null;
        }
        if (Vars.state.isEditor()) {
            this.target = null;
        }
        float targetX = Core.camera.position.x;
        float targetY = Core.camera.position.y;
        float attractDst = 15.0f;
        float f = speed = this.isBoosting && !this.mech.flying ? this.mech.boostSpeed : this.mech.speed;
        if (this.moveTarget != null && !this.moveTarget.isDead()) {
            targetX = this.moveTarget.getX();
            targetY = this.moveTarget.getY();
            boolean tapping = this.moveTarget instanceof TileEntity && this.moveTarget.getTeam() == this.team;
            attractDst = 0.0f;
            if (tapping) {
                this.velocity.setAngle(this.angleTo(this.moveTarget));
            }
            if (this.dst(this.moveTarget) <= 2.0f * Time.delta()) {
                if (tapping && !this.isDead()) {
                    Tile tile = ((TileEntity)this.moveTarget).tile;
                    tile.block().tapped(tile, this);
                }
                this.moveTarget = null;
            }
        } else {
            this.moveTarget = null;
        }
        this.movement.set((targetX - this.x) / Time.delta(), (targetY - this.y) / Time.delta()).limit(speed);
        this.movement.setAngle(Mathf.slerp(this.movement.angle(), this.velocity.angle(), 0.05f));
        if (this.dst(targetX, targetY) < attractDst) {
            this.movement.setZero();
        }
        float expansion = 3.0f;
        this.hitbox(rect);
        Player.rect.x -= expansion;
        Player.rect.y -= expansion;
        Player.rect.width += expansion * 2.0f;
        Player.rect.height += expansion * 2.0f;
        this.isBoosting = Vars.collisions.overlapsTile(rect) || this.dst(targetX, targetY) > 85.0f;
        this.velocity.add(this.movement.scl(Time.delta()));
        if (this.velocity.len() <= 0.2f && this.mech.flying) {
            this.rotation += Mathf.sin(Time.time() + (float)(this.id * 99), 10.0f, 1.0f);
        } else if (this.target == null) {
            this.rotation = Mathf.slerpDelta(this.rotation, this.velocity.angle(), this.velocity.len() / 10.0f);
        }
        float lx = this.x;
        float ly = this.y;
        this.updateVelocityStatus();
        boolean bl = this.moved = this.dst(lx, ly) > 0.001f;
        if (this.mech.flying) {
            this.x += Mathf.sin(Time.time() + (float)(this.id * 999), 25.0f, 0.08f);
            this.y += Mathf.cos(Time.time() + (float)(this.id * 999), 25.0f, 0.08f);
        }
        if (!this.isBuilding() && this.getMineTile() == null) {
            if (this.target == null) {
                this.isShooting = false;
                if (Core.settings.getBool("autotarget")) {
                    this.target = Units.closestTarget(this.team, this.x, this.y, this.getWeapon().bullet.range(), u -> u.getTeam() != Team.derelict, u -> u.getTeam() != Team.derelict);
                    if (this.mech.canHeal && this.target == null) {
                        this.target = Geometry.findClosest(this.x, this.y, Vars.indexer.getDamaged(Team.sharded));
                        if (this.target != null && this.dst(this.target) > this.getWeapon().bullet.range()) {
                            this.target = null;
                        } else if (this.target != null) {
                            this.target = ((Tile)this.target).entity;
                        }
                    }
                    if (this.target != null) {
                        this.setMineTile(null);
                    }
                }
            } else if (this.target.isValid() || this.target instanceof TileEntity && ((TileEntity)this.target).damaged() && this.target.getTeam() == this.team && this.mech.canHeal && this.dst(this.target) < this.getWeapon().bullet.range()) {
                if (this.mech.turnCursor) {
                    this.rotation = Mathf.slerpDelta(this.rotation, this.angleTo(this.target), 0.2f);
                }
                Vector2 intercept = Predict.intercept(this, this.target, this.getWeapon().bullet.speed);
                this.pointerX = intercept.x;
                this.pointerY = intercept.y;
                this.updateShooting();
                this.isShooting = true;
            }
        }
    }

    public void sendMessage(String text) {
        if (this.isLocal) {
            if (Vars.ui != null) {
                Log.info("add " + text);
                Vars.ui.chatfrag.addMessage(text, null);
            }
        } else {
            Call.sendMessage(this.con, text, null, null);
        }
    }

    public void sendMessage(String text, Player from) {
        this.sendMessage(text, from, NetClient.colorizeName(from.id, from.name));
    }

    public void sendMessage(String text, Player from, String fromName) {
        if (this.isLocal) {
            if (Vars.ui != null) {
                Vars.ui.chatfrag.addMessage(text, fromName);
            }
        } else {
            Call.sendMessage(this.con, text, fromName, from);
        }
    }

    public Administration.PlayerInfo getInfo() {
        if (this.uuid == null) {
            throw new IllegalArgumentException("Local players cannot be traced and do not have info.");
        }
        return Vars.netServer.admins.getInfo(this.uuid);
    }

    public void reset() {
        this.resetNoAdd();
        this.add();
    }

    public void resetNoAdd() {
        this.status.clear();
        this.team = Team.sharded;
        this.item.amount = 0;
        this.placeQueue.clear();
        this.dead = true;
        this.lastText = null;
        this.textFadeTime = 0.0f;
        this.target = null;
        this.moveTarget = null;
        this.lastSpawner = null;
        this.spawner = null;
        this.health = this.maxHealth();
        this.mining = null;
        this.hitTime = 0.0f;
        this.drownTime = 0.0f;
        this.boostHeat = 0.0f;
        this.mech = Mechs.starter;
        this.placeQueue.clear();
        this.respawns = Vars.state.rules.respawns;
    }

    public boolean isShooting() {
        return this.isShooting && (this.boostHeat < 0.1f || this.mech.flying) && this.mining == null;
    }

    public void updateRespawning() {
        if (Vars.state.isEditor()) {
            this.set((float)(Vars.world.width() * 8) / 2.0f, (float)(Vars.world.height() * 8) / 2.0f);
            this.setDead(false);
        } else if (this.spawner != null && this.spawner.isValid()) {
            this.spawner.updateSpawning(this);
        } else if (!Vars.netServer.isWaitingForPlayers()) {
            if (!Vars.net.client()) {
                if (this.lastSpawner != null && this.lastSpawner.isValid()) {
                    this.spawner = this.lastSpawner;
                } else if (this.getClosestCore() != null) {
                    this.spawner = (SpawnerTrait)((Object)this.getClosestCore());
                }
            }
        } else if (this.getClosestCore() != null) {
            this.set(this.getClosestCore().getX(), this.getClosestCore().getY());
        }
    }

    public void beginRespawning(SpawnerTrait spawner) {
        this.spawner = spawner;
        this.lastSpawner = spawner;
        this.dead = true;
        this.setNet(spawner.getX(), spawner.getY());
        spawner.updateSpawning(this);
    }

    @Override
    public byte version() {
        return 0;
    }

    @Override
    public void writeSave(DataOutput stream) throws IOException {
        stream.writeBoolean(this.isLocal);
        if (this.isLocal) {
            stream.writeByte(this.mech.id);
            stream.writeInt(this.lastSpawner == null ? noSpawner : this.lastSpawner.getTile().pos());
            super.writeSave(stream, false);
        }
    }

    @Override
    public void readSave(DataInput stream, byte version) throws IOException {
        boolean local = stream.readBoolean();
        if (local) {
            byte mechid = stream.readByte();
            int spawner = stream.readInt();
            Tile stile = Vars.world.tile(spawner);
            Player player = Vars.headless ? this : Vars.player;
            player.readSaveSuper(stream, version);
            player.mech = (Mech)Vars.content.getByID(ContentType.mech, mechid);
            player.dead = false;
            if (stile != null && stile.entity instanceof SpawnerTrait) {
                player.lastSpawner = (SpawnerTrait)((Object)stile.entity);
            }
        }
    }

    private void readSaveSuper(DataInput stream, byte version) throws IOException {
        super.readSave(stream, version);
        this.add();
    }

    @Override
    public void write(DataOutput buffer) throws IOException {
        super.writeSave(buffer, !this.isLocal);
        TypeIO.writeStringData(buffer, this.name);
        buffer.writeByte(Pack.byteValue(this.isAdmin) | Pack.byteValue(this.dead) << 1 | Pack.byteValue(this.isBoosting) << 2 | Pack.byteValue(this.isTyping) << 3);
        buffer.writeInt(Color.rgba8888(this.color));
        buffer.writeByte(this.mech.id);
        buffer.writeInt(this.mining == null ? noSpawner : this.mining.pos());
        buffer.writeInt(this.spawner == null || !this.spawner.hasUnit(this) ? noSpawner : this.spawner.getTile().pos());
        buffer.writeShort((short)(this.baseRotation * 2.0f));
        this.writeBuilding(buffer);
    }

    @Override
    public void read(DataInput buffer) throws IOException {
        float lastx = this.x;
        float lasty = this.y;
        float lastrot = this.rotation;
        float lastvx = this.velocity.x;
        float lastvy = this.velocity.y;
        super.readSave(buffer, this.version());
        this.name = TypeIO.readStringData(buffer);
        byte bools = buffer.readByte();
        this.isAdmin = (bools & 1) != 0;
        this.dead = (bools & 2) != 0;
        boolean boosting = (bools & 4) != 0;
        this.isTyping = (bools & 8) != 0;
        this.color.set(buffer.readInt());
        this.mech = (Mech)Vars.content.getByID(ContentType.mech, buffer.readByte());
        int mine = buffer.readInt();
        int spawner = buffer.readInt();
        float baseRotation = (float)buffer.readShort() / 2.0f;
        this.readBuilding(buffer, !this.isLocal);
        this.interpolator.read(lastx, lasty, this.x, this.y, this.rotation, baseRotation);
        this.rotation = lastrot;
        this.x = lastx;
        this.y = lasty;
        if (this.isLocal) {
            this.velocity.x = lastvx;
            this.velocity.y = lastvy;
        } else {
            this.mining = Vars.world.tile(mine);
            this.isBoosting = boosting;
        }
        Tile tile = Vars.world.tile(spawner);
        this.spawner = tile != null && tile.entity instanceof SpawnerTrait ? (SpawnerTrait)((Object)tile.entity) : null;
    }
}

