/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Damage;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.effect.ScorchDecal;
import io.anuke.mindustry.entities.traits.DamageTrait;
import io.anuke.mindustry.entities.traits.DrawTrait;
import io.anuke.mindustry.entities.traits.SaveTrait;
import io.anuke.mindustry.entities.traits.SolidTrait;
import io.anuke.mindustry.entities.traits.SyncTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.traits.TeamTrait;
import io.anuke.mindustry.entities.type.DestructibleEntity;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.units.Statuses;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.net.Interpolator;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.StatusEffect;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.Fonts;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class Unit
extends DestructibleEntity
implements SaveTrait,
TargetTrait,
SyncTrait,
DrawTrait,
TeamTrait {
    public static final float hitDuration = 9.0f;
    public static final float velocityPercision = 8.0f;
    public static final float maxAbsVelocity = 15.875f;
    public static final int noSpawner = Pos.get(-1, 1);
    private static final Vector2 moveVector = new Vector2();
    public float rotation;
    protected final Interpolator interpolator = new Interpolator();
    protected final Statuses status = new Statuses();
    protected final ItemStack item = new ItemStack(Vars.content.item(0), 0);
    protected Team team = Team.sharded;
    protected float drownTime;
    protected float hitTime;

    @Override
    public boolean collidesGrid(int x, int y) {
        return !this.isFlying();
    }

    @Override
    public Team getTeam() {
        return this.team;
    }

    @Override
    public void interpolate() {
        this.interpolator.update();
        this.x = this.interpolator.pos.x;
        this.y = this.interpolator.pos.y;
        if (this.interpolator.values.length > 0) {
            this.rotation = this.interpolator.values[0];
        }
    }

    @Override
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Override
    public void damage(float amount) {
        if (!Vars.net.client()) {
            super.damage(this.calculateDamage(amount));
        }
        this.hitTime = 9.0f;
    }

    @Override
    public boolean collides(SolidTrait other) {
        if (this.isDead()) {
            return false;
        }
        if (other instanceof DamageTrait) {
            return other instanceof TeamTrait && Vars.state.teams.areEnemies(((TeamTrait)((Object)other)).getTeam(), this.team);
        }
        return other instanceof Unit && ((Unit)other).isFlying() == this.isFlying();
    }

    @Override
    public void onDeath() {
        float explosiveness = 2.0f + this.item.item.explosiveness * (float)this.item.amount;
        float flammability = this.item.item.flammability * (float)this.item.amount;
        Damage.dynamicExplosion(this.x, this.y, flammability, explosiveness, 0.0f, this.getSize() / 2.0f, Pal.darkFlame);
        ScorchDecal.create(this.x, this.y);
        Effects.effect(Fx.explosion, this);
        Effects.shake(2.0f, 2.0f, this);
        Sounds.bang.at(this);
        this.item.amount = 0;
        this.drownTime = 0.0f;
        this.status.clear();
        Events.fire(new EventType.UnitDestroyEvent(this));
        if (explosiveness > 7.0f && this == Vars.player) {
            Events.fire(EventType.Trigger.suicideBomb);
        }
    }

    @Override
    public Vector2 velocity() {
        return this.velocity;
    }

    @Override
    public void move(float x, float y) {
        if (!this.isFlying()) {
            super.move(x, y);
        } else {
            this.moveBy(x, y);
        }
    }

    @Override
    public boolean isValid() {
        return !this.isDead() && this.isAdded();
    }

    @Override
    public void writeSave(DataOutput stream) throws IOException {
        this.writeSave(stream, false);
    }

    @Override
    public void readSave(DataInput stream, byte version) throws IOException {
        byte team = stream.readByte();
        boolean dead = stream.readBoolean();
        float x = stream.readFloat();
        float y = stream.readFloat();
        byte xv = stream.readByte();
        byte yv = stream.readByte();
        float rotation = (float)stream.readShort() / 2.0f;
        short health = stream.readShort();
        byte itemID = stream.readByte();
        short itemAmount = stream.readShort();
        this.status.readSave(stream, version);
        this.item.amount = itemAmount;
        this.item.item = Vars.content.item(itemID);
        this.dead = dead;
        this.team = Team.all[team];
        this.health = health;
        this.x = x;
        this.y = y;
        this.velocity.set((float)xv / 8.0f, (float)yv / 8.0f);
        this.rotation = rotation;
    }

    public void writeSave(DataOutput stream, boolean net) throws IOException {
        stream.writeByte(this.team.ordinal());
        stream.writeBoolean(this.isDead());
        stream.writeFloat(net ? this.interpolator.target.x : this.x);
        stream.writeFloat(net ? this.interpolator.target.y : this.y);
        stream.writeByte((byte)(Mathf.clamp(this.velocity.x, -15.875f, 15.875f) * 8.0f));
        stream.writeByte((byte)(Mathf.clamp(this.velocity.y, -15.875f, 15.875f) * 8.0f));
        stream.writeShort((short)(this.rotation * 2.0f));
        stream.writeShort((short)this.health);
        stream.writeByte(this.item.item.id);
        stream.writeShort((short)this.item.amount);
        this.status.writeSave(stream);
    }

    protected void clampPosition() {
        this.x = Mathf.clamp(this.x, 0.0f, (float)(Vars.world.width() * 8 - 8));
        this.y = Mathf.clamp(this.y, 0.0f, (float)(Vars.world.height() * 8 - 8));
    }

    public void kill() {
        this.health = -1.0f;
        this.damage(1.0f);
    }

    public boolean isImmune(StatusEffect effect) {
        return false;
    }

    public boolean isOutOfBounds() {
        return this.x < -100.0f || this.y < -100.0f || this.x > (float)(Vars.world.width() * 8) + 100.0f || this.y > (float)(Vars.world.height() * 8) + 100.0f;
    }

    public float calculateDamage(float amount) {
        return amount * Mathf.clamp(1.0f - this.status.getArmorMultiplier() / 100.0f);
    }

    public float getDamageMultipler() {
        return this.status.getDamageMultiplier();
    }

    public boolean hasEffect(StatusEffect effect) {
        return this.status.hasEffect(effect);
    }

    public void avoidOthers() {
        float radScl = 1.5f;
        float fsize = this.getSize() / radScl;
        moveVector.setZero();
        float cx = this.x - fsize / 2.0f;
        float cy = this.y - fsize / 2.0f;
        for (Team team : Team.all) {
            this.avoid(Vars.unitGroups[team.ordinal()].intersect(cx, cy, fsize, fsize));
        }
        this.avoid(Vars.playerGroup.intersect(cx, cy, fsize, fsize));
        this.velocity.add(Unit.moveVector.x / this.mass() * Time.delta(), Unit.moveVector.y / this.mass() * Time.delta());
    }

    private void avoid(Array<? extends Unit> arr) {
        float radScl = 1.5f;
        for (Unit unit : arr) {
            if (unit.isFlying() != this.isFlying()) continue;
            float dst = this.dst(unit);
            float scl = Mathf.clamp(1.0f - dst / (this.getSize() / (radScl * 2.0f) + unit.getSize() / (radScl * 2.0f)));
            moveVector.add(Tmp.v1.set((this.x - unit.x) * scl, (this.y - unit.y) * scl).limit(0.4f));
        }
    }

    public TileEntity getClosestCore() {
        Teams.TeamData data = Vars.state.teams.get(this.team);
        Tile tile = Geometry.findClosest(this.x, this.y, data.cores);
        if (tile == null) {
            return null;
        }
        return tile.entity;
    }

    public Floor getFloorOn() {
        Tile tile = Vars.world.tileWorld(this.x, this.y);
        return tile == null ? (Floor)Blocks.air : tile.floor();
    }

    public void onRespawn(Tile tile) {
    }

    public void updateVelocityStatus() {
        Floor floor = this.getFloorOn();
        Tile tile = Vars.world.tileWorld(this.x, this.y);
        this.status.update(this);
        this.velocity.limit(this.maxVelocity()).scl(1.0f + (this.status.getSpeedMultiplier() - 1.0f) * Time.delta());
        if (this.x < -600.0f || this.y < -600.0f || this.x >= (float)(Vars.world.width() * 8) + 600.0f || this.y >= (float)(Vars.world.height() * 8) + 600.0f) {
            this.kill();
        }
        if (this.getTeam() != Vars.waveTeam) {
            float relativeSize = Vars.state.rules.dropZoneRadius + this.getSize() / 2.0f + 1.0f;
            for (Tile spawn : Vars.spawner.getGroundSpawns()) {
                if (!this.withinDst(spawn.worldx(), spawn.worldy(), relativeSize)) continue;
                this.velocity.add(Tmp.v1.set(this).sub(spawn.worldx(), spawn.worldy()).setLength(1.1f - this.dst(spawn) / relativeSize).scl(0.45f * Time.delta()));
            }
        }
        float warpDst = 180.0f;
        if (this.x < 0.0f) {
            this.velocity.x += -this.x / 180.0f;
        }
        if (this.y < 0.0f) {
            this.velocity.y += -this.y / 180.0f;
        }
        if (this.x > (float)Vars.world.unitWidth()) {
            this.velocity.x -= (this.x - (float)Vars.world.unitWidth()) / 180.0f;
        }
        if (this.y > (float)Vars.world.unitHeight()) {
            this.velocity.y -= (this.y - (float)Vars.world.unitHeight()) / 180.0f;
        }
        if (this.isFlying()) {
            this.drownTime = 0.0f;
            this.move(this.velocity.x * Time.delta(), this.velocity.y * Time.delta());
        } else {
            boolean onLiquid = floor.isLiquid;
            if (tile != null) {
                tile.block().unitOn(tile, this);
                if (tile.block() != Blocks.air) {
                    onLiquid = false;
                }
            }
            if (onLiquid && this.velocity.len() > 0.4f && Mathf.chance(this.velocity.len() * floor.speedMultiplier * 0.06f * Time.delta())) {
                Effects.effect(floor.walkEffect, floor.color, this.x, this.y);
            }
            if (onLiquid) {
                this.status.handleApply(this, floor.status, floor.statusDuration);
                if (floor.damageTaken > 0.0f) {
                    this.damagePeriodic(floor.damageTaken);
                }
            }
            if (onLiquid && floor.drownTime > 0.0f) {
                this.drownTime += Time.delta() * 1.0f / floor.drownTime;
                if (Mathf.chance(Time.delta() * 0.05f)) {
                    Effects.effect(floor.drownUpdateEffect, floor.color, this.x, this.y);
                }
            } else {
                this.drownTime = Mathf.lerpDelta(this.drownTime, 0.0f, 0.03f);
            }
            this.drownTime = Mathf.clamp(this.drownTime);
            if (this.drownTime >= 0.999f && !Vars.net.client()) {
                this.damage(this.health + 1.0f);
                if (this == Vars.player) {
                    Events.fire(EventType.Trigger.drown);
                }
            }
            float px = this.x;
            float py = this.y;
            this.move(this.velocity.x * floor.speedMultiplier * Time.delta(), this.velocity.y * floor.speedMultiplier * Time.delta());
            if (Math.abs(px - this.x) <= 1.0E-4f) {
                this.velocity.x = 0.0f;
            }
            if (Math.abs(py - this.y) <= 1.0E-4f) {
                this.velocity.y = 0.0f;
            }
        }
        this.velocity.scl(Mathf.clamp(1.0f - this.drag() * (this.isFlying() ? 1.0f : floor.dragMultiplier) * Time.delta()));
    }

    public boolean acceptsItem(Item item) {
        return this.item.amount <= 0 || this.item.item == item && this.item.amount <= this.getItemCapacity();
    }

    public void addItem(Item item) {
        this.addItem(item, 1);
    }

    public void addItem(Item item, int amount) {
        this.item.amount = this.item.item == item ? this.item.amount + amount : amount;
        this.item.item = item;
    }

    public void clearItem() {
        this.item.amount = 0;
    }

    public ItemStack item() {
        return this.item;
    }

    public int maxAccepted(Item item) {
        return this.item.item != item && this.item.amount > 0 ? 0 : this.getItemCapacity() - this.item.amount;
    }

    public void applyEffect(StatusEffect effect, float duration) {
        if (this.dead || Vars.net.client()) {
            return;
        }
        this.status.handleApply(this, effect, duration);
    }

    public void damagePeriodic(float amount) {
        this.damage(amount * Time.delta(), this.hitTime <= -11.0f);
    }

    public void damage(float amount, boolean withEffect) {
        float pre = this.hitTime;
        this.damage(amount);
        if (!withEffect) {
            this.hitTime = pre;
        }
    }

    public void drawUnder() {
    }

    public void drawOver() {
    }

    public void drawStats() {
        Draw.color(Color.black, this.team.color, this.healthf() + Mathf.absin(Time.time(), Math.max(this.healthf() * 5.0f, 1.0f), 1.0f - this.healthf()));
        Draw.rect(this.getPowerCellRegion(), this.x, this.y, this.rotation - 90.0f);
        Draw.color();
        this.drawBackItems(this.item.amount > 0 ? 1.0f : 0.0f, false);
    }

    public void drawBackItems(float itemtime, boolean number) {
        if (itemtime > 0.01f && this.item.item != null) {
            float backTrns = 5.0f;
            float size = (5.0f + Mathf.absin(Time.time(), 5.0f, 1.0f)) * itemtime;
            Draw.mixcol(Pal.accent, Mathf.absin(Time.time(), 5.0f, 0.5f));
            Draw.rect(this.item.item.icon(Item.Icon.large), this.x + Angles.trnsx(this.rotation + 180.0f, backTrns), this.y + Angles.trnsy(this.rotation + 180.0f, backTrns), size, size, this.rotation);
            Draw.mixcol();
            Lines.stroke(1.0f, Pal.accent);
            Lines.circle(this.x + Angles.trnsx(this.rotation + 180.0f, backTrns), this.y + Angles.trnsy(this.rotation + 180.0f, backTrns), (3.0f + Mathf.absin(Time.time(), 5.0f, 1.0f)) * itemtime);
            if (number) {
                Fonts.outline.draw(this.item.amount + "", this.x + Angles.trnsx(this.rotation + 180.0f, backTrns), this.y + Angles.trnsy(this.rotation + 180.0f, backTrns) - 3.0f, Pal.accent, 0.25f * itemtime / Scl.scl(1.0f), false, 1);
            }
        }
        Draw.reset();
    }

    public TextureRegion getPowerCellRegion() {
        return Core.atlas.find("power-cell");
    }

    public void drawAll() {
        if (!this.isDead()) {
            this.draw();
            this.drawStats();
        }
    }

    public void drawShadow(float offsetX, float offsetY) {
        Draw.rect(this.getIconRegion(), this.x + offsetX, this.y + offsetY, this.rotation - 90.0f);
    }

    public float getSize() {
        this.hitbox(Tmp.r1);
        return Math.max(Tmp.r1.width, Tmp.r1.height) * 2.0f;
    }

    public abstract TextureRegion getIconRegion();

    public abstract Weapon getWeapon();

    public abstract int getItemCapacity();

    @Override
    public abstract float mass();

    public abstract boolean isFlying();
}

