/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type.base;

import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.type.FlyingUnit;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.meta.BlockFlag;

public abstract class BaseDrone
extends FlyingUnit {
    public final UnitState retreat = new UnitState(){

        @Override
        public void entered() {
            BaseDrone.this.target = null;
        }

        @Override
        public void update() {
            if (BaseDrone.this.health >= BaseDrone.this.maxHealth()) {
                BaseDrone.this.state.set(BaseDrone.this.getStartState());
            } else if (!BaseDrone.this.targetHasFlag(BlockFlag.repair)) {
                if (BaseDrone.this.retarget()) {
                    Tile repairPoint = Geometry.findClosest(BaseDrone.this.x, BaseDrone.this.y, Vars.indexer.getAllied(BaseDrone.this.team, BlockFlag.repair));
                    if (repairPoint != null) {
                        BaseDrone.this.target = repairPoint;
                    } else {
                        BaseDrone.this.setState(BaseDrone.this.getStartState());
                    }
                }
            } else {
                BaseDrone.this.circle(40.0f);
            }
        }
    };

    @Override
    public void onCommand(UnitCommand command) {
    }

    @Override
    protected void updateRotation() {
        this.rotation = this.target != null && this.shouldRotate() && this.target.dst(this) < this.type.range ? Mathf.slerpDelta(this.rotation, this.angleTo(this.target), 0.3f) : Mathf.slerpDelta(this.rotation, this.velocity.angle(), 0.3f);
    }

    @Override
    public void behavior() {
        if (this.health <= this.maxHealth() * this.type.retreatPercent && !this.state.is(this.retreat) && Geometry.findClosest(this.x, this.y, Vars.indexer.getAllied(this.team, BlockFlag.repair)) != null) {
            this.setState(this.retreat);
        }
    }

    public boolean shouldRotate() {
        return this.state.is(this.getStartState());
    }

    @Override
    public abstract UnitState getStartState();
}

