/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type.base;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.IntIntMap;
import io.anuke.arc.collection.Queue;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Pack;
import io.anuke.arc.util.StaticReset;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.EntityGroup;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.base.BaseDrone;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Teams;
import io.anuke.mindustry.gen.BrokenBlock;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BuilderDrone
extends BaseDrone
implements BuilderTrait {
    private static final StaticReset reset = new StaticReset();
    private static final IntIntMap totals = new IntIntMap();
    protected Queue<BuilderTrait.BuildRequest> placeQueue = new Queue();
    protected boolean isBreaking;
    protected Player playerTarget;
    public final UnitState build = new UnitState(){

        @Override
        public void entered() {
            if (!(BuilderDrone.this.target instanceof BuildBlock.BuildEntity)) {
                BuilderDrone.this.target = null;
            }
        }

        @Override
        public void update() {
            BuildBlock.BuildEntity entity = (BuildBlock.BuildEntity)BuilderDrone.this.target;
            TileEntity core = BuilderDrone.this.getClosestCore();
            if (BuilderDrone.this.isBuilding() && entity == null && BuilderDrone.this.isRebuild()) {
                BuilderDrone.this.target = (TargetTrait)Vars.world.tile(BuilderDrone.this.buildRequest().x, BuilderDrone.this.buildRequest().y);
                BuilderDrone.this.circle(154.0f);
                BuilderDrone.this.target = null;
                BuilderTrait.BuildRequest request = BuilderDrone.this.buildRequest();
                if (Vars.world.tile((int)request.x, (int)request.y).entity instanceof BuildBlock.BuildEntity) {
                    BuilderDrone.this.target = Vars.world.tile((int)request.x, (int)request.y).entity;
                }
            } else if (entity != null && core != null && (entity.progress < 1.0f || entity.progress > 0.0f) && entity.tile.block() instanceof BuildBlock) {
                if (!BuilderDrone.this.isBuilding() && BuilderDrone.this.dst(BuilderDrone.this.target) < 198.0f) {
                    if (BuilderDrone.this.isBreaking) {
                        BuilderDrone.this.buildQueue().addLast(new BuilderTrait.BuildRequest(entity.tile.x, entity.tile.y));
                    } else {
                        BuilderDrone.this.buildQueue().addLast(new BuilderTrait.BuildRequest(entity.tile.x, entity.tile.y, entity.tile.rotation(), entity.cblock));
                    }
                }
                BuilderDrone.this.circle(154.0f);
                BuilderDrone.this.velocity.scl(0.74f);
            } else {
                BuilderDrone.this.target = null;
                if (BuilderDrone.this.playerTarget == null || BuilderDrone.this.playerTarget.getTeam() != BuilderDrone.this.team || !BuilderDrone.this.playerTarget.isValid()) {
                    BuilderDrone.this.playerTarget = null;
                    if (BuilderDrone.this.retarget()) {
                        float minDst = Float.POSITIVE_INFINITY;
                        int minDrones = Integer.MAX_VALUE;
                        for (Player player : Vars.playerGroup.all()) {
                            if (player.getTeam() != BuilderDrone.this.team) continue;
                            int drones = BuilderDrone.this.getDrones(player);
                            float dst = BuilderDrone.this.dst2(player);
                            if (BuilderDrone.this.playerTarget != null && drones >= minDrones && (drones != minDrones || !(dst < minDst))) continue;
                            minDrones = drones;
                            minDst = dst;
                            BuilderDrone.this.playerTarget = player;
                        }
                    }
                    if (BuilderDrone.this.getSpawner() != null) {
                        BuilderDrone.this.target = BuilderDrone.this.getSpawner();
                        BuilderDrone.this.circle(40.0f);
                        BuilderDrone.this.target = null;
                    }
                } else {
                    BuilderDrone.this.incDrones(BuilderDrone.this.playerTarget);
                    TargetTrait prev = BuilderDrone.this.target;
                    BuilderDrone.this.target = BuilderDrone.this.playerTarget;
                    float dst = 90.0f + (float)(BuilderDrone.this.id % 4 * 30);
                    float tdst = BuilderDrone.this.dst(BuilderDrone.this.target);
                    float scale = Mathf.lerp(1.0f, 0.77f, 1.0f - Mathf.clamp((tdst - dst) / dst));
                    BuilderDrone.this.circle(dst);
                    BuilderDrone.this.velocity.scl(scale);
                    BuilderDrone.this.target = prev;
                }
            }
        }
    };

    public BuilderDrone() {
        if (reset.check()) {
            Events.on(EventType.BuildSelectEvent.class, event -> {
                EntityGroup<BaseUnit> group = Vars.unitGroups[event.team.ordinal()];
                if (!(event.tile.entity instanceof BuildBlock.BuildEntity)) {
                    return;
                }
                for (BaseUnit unit : group.all()) {
                    BuilderDrone drone;
                    if (!(unit instanceof BuilderDrone) || !(drone = (BuilderDrone)unit).isBuilding()) continue;
                    BuilderTrait.BuildRequest req = drone.buildRequest();
                    if (req.breaking == event.breaking || req.x != event.tile.x || req.y != event.tile.y) continue;
                    drone.clearBuilding();
                    drone.target = null;
                }
            });
        }
    }

    int getDrones(Player player) {
        return Pack.leftShort(totals.get(player.id, 0));
    }

    void incDrones(Player player) {
        short curFrame;
        int num = totals.get(player.id, 0);
        short amount = Pack.leftShort(num);
        short frame = Pack.rightShort(num);
        if (frame != (curFrame = (short)(Core.graphics.getFrameId() % 32767L))) {
            totals.put(player.id, Pack.shortInt((short)1, curFrame));
        } else {
            totals.put(player.id, Pack.shortInt((short)(amount + 1), curFrame));
        }
    }

    boolean isRebuild() {
        return false;
    }

    @Override
    public float getBuildPower(Tile tile) {
        return this.type.buildPower;
    }

    @Override
    public Queue<BuilderTrait.BuildRequest> buildQueue() {
        return this.placeQueue;
    }

    @Override
    public void update() {
        super.update();
        if (!this.isBuilding() && this.timer.get(timerTarget2, 15.0f)) {
            for (Player player : Vars.playerGroup.all()) {
                BuildBlock.BuildEntity b;
                float dist;
                if (player.getTeam() != this.team || player.buildRequest() == null) continue;
                BuilderTrait.BuildRequest req = player.buildRequest();
                Tile tile = Vars.world.tile(req.x, req.y);
                if (tile == null || !(tile.entity instanceof BuildBlock.BuildEntity) || !((dist = Math.min((b = (BuildBlock.BuildEntity)tile.entity()).dst(this.x, this.y) - 220.0f, 0.0f)) / this.type.maxVelocity < b.buildCost * 0.9f)) continue;
                this.target = b;
                this.isBreaking = req.breaking;
                this.setState(this.build);
                break;
            }
            if (this.isRebuild() && !this.isBuilding()) {
                Teams.TeamData data = Vars.state.teams.get(this.team);
                if (!data.brokenBlocks.isEmpty()) {
                    long block = data.brokenBlocks.removeLast();
                    this.placeQueue.addFirst(new BuilderTrait.BuildRequest(BrokenBlock.x(block), BrokenBlock.y(block), BrokenBlock.rotation(block), Vars.content.block(BrokenBlock.block(block))));
                    this.setState(this.build);
                }
            }
        }
        this.updateBuilding();
    }

    @Override
    public boolean shouldRotate() {
        return this.isBuilding();
    }

    @Override
    public UnitState getStartState() {
        return this.build;
    }

    @Override
    public void drawOver() {
        this.drawBuilding();
    }

    @Override
    public float drawSize() {
        return this.isBuilding() ? 440.0f : 30.0f;
    }

    @Override
    public boolean canCreateBlocks() {
        return true;
    }

    @Override
    public void write(DataOutput data) throws IOException {
        super.write(data);
        this.writeBuilding(data);
    }

    @Override
    public void read(DataInput data) throws IOException {
        super.read(data);
        this.readBuilding(data);
    }
}

