/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type.base;

import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.base.BaseDrone;
import io.anuke.mindustry.entities.units.UnitState;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RepairDrone
extends BaseDrone {
    public final UnitState repair = new UnitState(){

        @Override
        public void entered() {
            RepairDrone.this.target = null;
        }

        @Override
        public void update() {
            if (RepairDrone.this.retarget()) {
                RepairDrone.this.target = Units.findDamagedTile(RepairDrone.this.team, RepairDrone.this.x, RepairDrone.this.y);
            }
            if (RepairDrone.this.target instanceof TileEntity && ((TileEntity)((RepairDrone)RepairDrone.this).target).block instanceof BuildBlock) {
                RepairDrone.this.target = null;
            }
            if (RepairDrone.this.target != null) {
                if (RepairDrone.this.target.dst(RepairDrone.this) > ((RepairDrone)RepairDrone.this).type.range) {
                    RepairDrone.this.circle(((RepairDrone)RepairDrone.this).type.range * 0.9f);
                } else {
                    RepairDrone.this.getWeapon().update(RepairDrone.this, RepairDrone.this.target.getX(), RepairDrone.this.target.getY());
                }
            } else if (RepairDrone.this.getSpawner() != null) {
                RepairDrone.this.target = RepairDrone.this.getSpawner();
                RepairDrone.this.circle(((RepairDrone)RepairDrone.this).type.range * 1.5f, ((RepairDrone)RepairDrone.this).type.speed / 2.0f);
                RepairDrone.this.target = null;
            }
        }
    };

    @Override
    public boolean shouldRotate() {
        return this.target != null;
    }

    @Override
    public UnitState getStartState() {
        return this.repair;
    }

    @Override
    public void write(DataOutput data) throws IOException {
        super.write(data);
        data.writeInt(this.state.is(this.repair) && this.target instanceof TileEntity ? ((TileEntity)this.target).tile.pos() : Pos.invalid);
    }

    @Override
    public void read(DataInput data) throws IOException {
        super.read(data);
        Tile repairing = Vars.world.tile(data.readInt());
        if (repairing != null) {
            this.target = repairing.entity;
        }
    }
}

