/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.type.base;

import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.FlyingUnit;

public class Revenant
extends FlyingUnit {
    @Override
    public void drawWeapons() {
        for (int i : Mathf.signs) {
            float tra = this.rotation - 90.0f;
            float trY = -this.getWeapon().getRecoil(this, i > 0) + this.type.weaponOffsetY;
            float w = i > 0 ? -12.0f : 12.0f;
            float wx = this.x + Angles.trnsx(tra, this.getWeapon().width * (float)i, trY);
            float wy = this.y + Angles.trnsy(tra, this.getWeapon().width * (float)i, trY);
            int wi = (i + 1) / 2;
            Draw.rect(this.getWeapon().region, wx, wy, w, 12.0f, this.weaponAngles[wi] - 90.0f);
        }
    }

    @Override
    protected void attack(float circleLength) {
        this.moveTo(circleLength);
    }

    @Override
    protected void updateRotation() {
        this.rotation = !Units.invalidateTarget(this.target, this) ? Mathf.slerpDelta(this.rotation, this.angleTo(this.target), this.type.rotatespeed) : Mathf.slerpDelta(this.rotation, this.velocity.angle(), this.type.baseRotateSpeed);
    }
}

