/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.entities.units;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.Bits;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.StatusEffects;
import io.anuke.mindustry.entities.traits.Saveable;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.StatusEffect;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class Statuses
implements Saveable {
    private static final StatusEntry globalResult = new StatusEntry();
    private static final Array<StatusEntry> removals = new Array();
    private Array<StatusEntry> statuses = new Array();
    private Bits applied;
    private float speedMultiplier;
    private float damageMultiplier;
    private float armorMultiplier;

    public Statuses() {
        this.applied = new Bits(Vars.content.getBy((ContentType)ContentType.status).size);
    }

    public void handleApply(Unit unit, StatusEffect effect, float duration) {
        if (effect == StatusEffects.none || effect == null || unit.isImmune(effect)) {
            return;
        }
        if (this.statuses.size > 0) {
            for (StatusEntry entry : this.statuses) {
                if (entry.effect == effect) {
                    entry.time = Math.max(entry.time, duration);
                    return;
                }
                if (!entry.effect.reactsWith(effect)) continue;
                Statuses.globalResult.effect = entry.effect;
                entry.effect.getTransition(unit, effect, entry.time, duration, globalResult);
                entry.time = Statuses.globalResult.time;
                if (Statuses.globalResult.effect != entry.effect) {
                    entry.effect = Statuses.globalResult.effect;
                }
                return;
            }
        }
        StatusEntry entry = Pools.obtain(StatusEntry.class, StatusEntry::new);
        entry.set(effect, duration);
        this.statuses.add(entry);
    }

    public Color getStatusColor() {
        if (this.statuses.size == 0) {
            return Tmp.c1.set(Color.white);
        }
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        for (StatusEntry entry : this.statuses) {
            r += entry.effect.color.r;
            g += entry.effect.color.g;
            b += entry.effect.color.b;
        }
        return Tmp.c1.set(r / (float)this.statuses.size, g / (float)this.statuses.size, b / (float)this.statuses.size, 1.0f);
    }

    public void clear() {
        this.statuses.clear();
    }

    public void update(Unit unit) {
        this.applied.clear();
        this.armorMultiplier = 1.0f;
        this.damageMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        if (this.statuses.size == 0) {
            return;
        }
        removals.clear();
        for (StatusEntry entry : this.statuses) {
            entry.time = Math.max(entry.time - Time.delta(), 0.0f);
            this.applied.set(entry.effect.id);
            if (entry.time <= 0.0f) {
                Pools.free(entry);
                removals.add(entry);
                continue;
            }
            this.speedMultiplier *= entry.effect.speedMultiplier;
            this.armorMultiplier *= entry.effect.armorMultiplier;
            this.damageMultiplier *= entry.effect.damageMultiplier;
            entry.effect.update(unit, entry.time);
        }
        if (Statuses.removals.size > 0) {
            this.statuses.removeAll(removals, true);
        }
    }

    public float getSpeedMultiplier() {
        return this.speedMultiplier;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public float getArmorMultiplier() {
        return this.armorMultiplier;
    }

    public boolean hasEffect(StatusEffect effect) {
        return this.applied.get(effect.id);
    }

    @Override
    public void writeSave(DataOutput stream) throws IOException {
        stream.writeByte(this.statuses.size);
        for (StatusEntry entry : this.statuses) {
            stream.writeByte(entry.effect.id);
            stream.writeFloat(entry.time);
        }
    }

    @Override
    public void readSave(DataInput stream, byte version) throws IOException {
        for (StatusEntry effect : this.statuses) {
            Pools.free(effect);
        }
        this.statuses.clear();
        int amount = stream.readByte();
        for (int i = 0; i < amount; ++i) {
            byte id = stream.readByte();
            float time = stream.readFloat();
            StatusEntry entry = Pools.obtain(StatusEntry.class, StatusEntry::new);
            entry.set((StatusEffect)Vars.content.getByID(ContentType.status, id), time);
            this.statuses.add(entry);
        }
    }

    public static class StatusEntry {
        public StatusEffect effect;
        public float time;

        public StatusEntry set(StatusEffect effect, float time) {
            this.effect = effect;
            this.time = time;
            return this;
        }
    }
}

