/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectIntMap;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.files.ZipFileHandle;
import io.anuke.arc.util.io.Streams;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Items;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class GlobalData {
    private ObjectMap<ContentType, ObjectSet<String>> unlocked = new ObjectMap();
    private ObjectIntMap<Item> items = new ObjectIntMap();
    private boolean modified;

    public GlobalData() {
        Core.settings.setSerializer(ContentType.class, (stream, t) -> stream.writeInt(t.ordinal()), stream -> ContentType.values()[stream.readInt()]);
        Core.settings.setSerializer(Item.class, (stream, t) -> stream.writeUTF(t.name), stream -> (Item)Vars.content.getByName(ContentType.item, stream.readUTF()));
        Core.settings.setSerializer(ItemStack.class, (stream, t) -> {
            stream.writeUTF(t.item.name);
            stream.writeInt(t.amount);
        }, stream -> {
            String name = stream.readUTF();
            int amount = stream.readInt();
            return new ItemStack((Item)Vars.content.getByName(ContentType.item, name), amount);
        });
    }

    public void exportData(FileHandle file) throws IOException {
        Array<FileHandle> files = new Array<FileHandle>();
        files.add(Core.settings.getSettingsFile());
        files.addAll(Vars.customMapDirectory.list());
        files.addAll(Vars.saveDirectory.list());
        String base = Core.settings.getDataDirectory().path();
        try (OutputStream fos = file.write(false, 2048);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            for (FileHandle add : files) {
                zos.putNextEntry(new ZipEntry(add.path().substring(base.length())));
                Streams.copyStream(add.read(), zos);
                zos.closeEntry();
            }
        }
    }

    public void importData(FileHandle file) {
        FileHandle dest = Core.files.local("zipdata.zip");
        file.copyTo(dest);
        ZipFileHandle zipped = new ZipFileHandle(dest);
        FileHandle base = Core.settings.getDataDirectory();
        if (!((FileHandle)zipped).child("settings.bin").exists()) {
            throw new IllegalArgumentException("Not valid save data.");
        }
        for (FileHandle f2 : base.list()) {
            if (f2.isDirectory()) {
                f2.deleteDirectory();
                continue;
            }
            if (f2.name().equals("zipdata.zip")) continue;
            f2.delete();
        }
        zipped.walk(f -> f.copyTo(base.child(f.path())));
        dest.delete();
    }

    public void modified() {
        this.modified = true;
    }

    public int getItem(Item item) {
        return this.items.get(item, 0);
    }

    public void addItem(Item item, int amount) {
        if (amount > 0) {
            this.unlockContent(item);
        }
        this.modified = true;
        this.items.getAndIncrement(item, 0, amount);
        Vars.state.stats.itemsDelivered.getAndIncrement(item, 0, amount);
    }

    public boolean hasItems(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            if (this.items.get(stack.item, 0) >= stack.amount) continue;
            return false;
        }
        return true;
    }

    public void removeItems(ItemStack[] stacks) {
        for (ItemStack stack : stacks) {
            this.items.getAndIncrement(stack.item, 0, -stack.amount);
        }
        this.modified = true;
    }

    public boolean has(Item item, int amount) {
        return this.items.get(item, 0) >= amount;
    }

    public ObjectIntMap<Item> items() {
        return this.items;
    }

    public boolean isUnlocked(UnlockableContent content) {
        return content.alwaysUnlocked() || this.unlocked.getOr(content.getContentType(), ObjectSet::new).contains(content.name);
    }

    public void unlockContent(UnlockableContent content) {
        if (content.alwaysUnlocked()) {
            return;
        }
        if (this.unlocked.getOr(content.getContentType(), ObjectSet::new).add(content.name)) {
            this.modified = true;
            content.onUnlock();
            Events.fire(new EventType.UnlockEvent(content));
        }
    }

    public void reset() {
        this.save();
    }

    public void checkSave() {
        if (this.modified) {
            this.save();
            this.modified = false;
        }
    }

    public void load() {
        this.unlocked = Core.settings.getObject("unlocks", ObjectMap.class, ObjectMap::new);
        for (Item item : Vars.content.items()) {
            this.items.put(item, Core.settings.getInt("item-" + item.name, 0));
        }
        if (!Core.settings.has("item-" + Items.copper.name)) {
            this.addItem(Items.copper, 50);
        }
    }

    public void save() {
        Core.settings.putObject("unlocks", this.unlocked);
        for (Item item : Vars.content.items()) {
            Core.settings.put("item-" + item.name, this.items.get(item, 0));
        }
        Core.settings.save();
    }
}

