/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntArray;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.async.AsyncExecutor;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Gamemode;
import io.anuke.mindustry.io.SaveIO;
import io.anuke.mindustry.io.SaveMeta;
import io.anuke.mindustry.io.SavePreviewLoader;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.type.Zone;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Saves {
    private int nextSlot;
    private Array<SaveSlot> saves = new Array();
    private IntMap<SaveSlot> saveMap = new IntMap();
    private SaveSlot current;
    private AsyncExecutor previewExecutor = new AsyncExecutor(1);
    private boolean saving;
    private float time;
    private long totalPlaytime;
    private long lastTimestamp;

    public Saves() {
        Core.assets.setLoader(Texture.class, ".spreview", new SavePreviewLoader());
        Events.on(EventType.StateChangeEvent.class, event -> {
            if (event.to == GameState.State.menu) {
                this.totalPlaytime = 0L;
                this.lastTimestamp = 0L;
                this.current = null;
            }
        });
    }

    public void load() {
        this.saves.clear();
        IntArray slots = Core.settings.getObject("save-slots", IntArray.class, IntArray::new);
        for (int i = 0; i < slots.size; ++i) {
            int index = slots.get(i);
            if (!SaveIO.isSaveValid(index)) continue;
            SaveSlot slot = new SaveSlot(index);
            this.saves.add(slot);
            this.saveMap.put(slot.index, slot);
            slot.meta = SaveIO.getMeta(index);
            this.nextSlot = Math.max(index + 1, this.nextSlot);
        }
    }

    public SaveSlot getCurrent() {
        return this.current;
    }

    public void update() {
        SaveSlot current = this.current;
        if (!(current == null || Vars.state.is(GameState.State.menu) || Vars.state.isPaused() && Core.scene.hasDialog())) {
            if (this.lastTimestamp != 0L) {
                this.totalPlaytime += Time.timeSinceMillis(this.lastTimestamp);
            }
            this.lastTimestamp = Time.millis();
        }
        if (!Vars.state.is(GameState.State.menu) && !Vars.state.gameOver && current != null && current.isAutosave() && !Vars.state.rules.tutorial) {
            this.time += Time.delta();
            if (this.time > (float)(Core.settings.getInt("saveinterval") * 60)) {
                this.saving = true;
                Time.runTask(2.0f, () -> {
                    try {
                        current.save();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.saving = false;
                });
                this.time = 0.0f;
            }
        } else {
            this.time = 0.0f;
        }
    }

    public long getTotalPlaytime() {
        return this.totalPlaytime;
    }

    public void resetSave() {
        this.current = null;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void zoneSave() {
        SaveSlot slot = new SaveSlot(-1);
        slot.setName("zone");
        this.saves.remove(s -> s.index == -1);
        this.saves.add(slot);
        this.saveMap.put(slot.index, slot);
        slot.save();
        this.saveSlots();
    }

    public SaveSlot addSave(String name) {
        SaveSlot slot = new SaveSlot(this.nextSlot);
        ++this.nextSlot;
        slot.setName(name);
        this.saves.add(slot);
        this.saveMap.put(slot.index, slot);
        slot.save();
        this.saveSlots();
        return slot;
    }

    public SaveSlot importSave(FileHandle file) throws IOException {
        SaveSlot slot = new SaveSlot(this.nextSlot);
        slot.importFile(file);
        ++this.nextSlot;
        slot.setName(file.nameWithoutExtension());
        this.saves.add(slot);
        this.saveMap.put(slot.index, slot);
        slot.meta = SaveIO.getMeta(slot.index);
        this.current = slot;
        this.saveSlots();
        return slot;
    }

    public SaveSlot getZoneSlot() {
        SaveSlot slot = this.getByID(-1);
        return slot == null || slot.getZone() == null ? null : slot;
    }

    public SaveSlot getByID(int id) {
        return this.saveMap.get(id);
    }

    public Array<SaveSlot> getSaveSlots() {
        return this.saves;
    }

    private void saveSlots() {
        IntArray result = new IntArray(this.saves.size);
        for (int i = 0; i < this.saves.size; ++i) {
            result.add(this.saves.get((int)i).index);
        }
        Core.settings.putObject("save-slots", result);
        Core.settings.save();
    }

    public class SaveSlot {
        public final int index;
        boolean requestedPreview;
        SaveMeta meta;

        public SaveSlot(int index) {
            this.index = index;
        }

        public void load() throws SaveIO.SaveException {
            try {
                SaveIO.loadFromSlot(this.index);
                this.meta = SaveIO.getMeta(this.index);
                Saves.this.current = this;
                Saves.this.totalPlaytime = this.meta.timePlayed;
                this.savePreview();
            }
            catch (Exception e) {
                throw new SaveIO.SaveException(e);
            }
        }

        public void save() {
            long time = Saves.this.totalPlaytime;
            long prev = Saves.this.totalPlaytime;
            Saves.this.totalPlaytime = time;
            SaveIO.saveToSlot(this.index);
            this.meta = SaveIO.getMeta(this.index);
            if (!Vars.state.is(GameState.State.menu)) {
                Saves.this.current = this;
            }
            Saves.this.totalPlaytime = prev;
            this.savePreview();
        }

        private void savePreview() {
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                Core.assets.unload(this.loadPreviewFile().path());
            }
            Saves.this.previewExecutor.submit(() -> {
                try {
                    this.previewFile().writePNG(Vars.renderer.minimap.getPixmap());
                    this.requestedPreview = false;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
        }

        public Texture previewTexture() {
            if (!this.previewFile().exists()) {
                return null;
            }
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                return (Texture)Core.assets.get(this.loadPreviewFile().path());
            }
            if (!this.requestedPreview) {
                Core.assets.load(new AssetDescriptor<Texture>(this.loadPreviewFile(), Texture.class));
                this.requestedPreview = true;
            }
            return null;
        }

        private FileHandle previewFile() {
            return Vars.mapPreviewDirectory.child("save_slot_" + this.index + ".png");
        }

        private FileHandle loadPreviewFile() {
            return this.previewFile().sibling(this.previewFile().name() + ".spreview");
        }

        public boolean isHidden() {
            return this.getZone() != null;
        }

        public String getPlayTime() {
            return Strings.formatMillis(Saves.this.current == this ? Saves.this.totalPlaytime : this.meta.timePlayed);
        }

        public long getTimestamp() {
            return this.meta.timestamp;
        }

        public String getDate() {
            return SimpleDateFormat.getDateTimeInstance().format(new Date(this.meta.timestamp));
        }

        public Map getMap() {
            return this.meta.map;
        }

        public String getName() {
            return Core.settings.getString("save-" + this.index + "-name", "untitled");
        }

        public void setName(String name) {
            Core.settings.put("save-" + this.index + "-name", name);
            Core.settings.save();
        }

        public Zone getZone() {
            return this.meta == null || this.meta.rules == null ? null : this.meta.rules.zone;
        }

        public Gamemode mode() {
            return Gamemode.bestFit(this.meta.rules);
        }

        public int getBuild() {
            return this.meta.build;
        }

        public int getWave() {
            return this.meta.wave;
        }

        public boolean isAutosave() {
            return Core.settings.getBool("save-" + this.index + "-autosave", true);
        }

        public void setAutosave(boolean save) {
            Core.settings.put("save-" + this.index + "-autosave", save);
            Core.settings.save();
        }

        public void importFile(FileHandle file) throws IOException {
            try {
                file.copyTo(SaveIO.fileFor(this.index));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void exportFile(FileHandle file) throws IOException {
            try {
                SaveIO.fileFor(this.index).copyTo(file);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void delete() {
            SaveIO.fileFor(this.index).delete();
            Saves.this.saves.removeValue(this, true);
            Saves.this.saveMap.remove(this.index);
            if (this == Saves.this.current) {
                Saves.this.current = null;
            }
            if (Core.assets.isLoaded(this.loadPreviewFile().path())) {
                Core.assets.unload(this.loadPreviewFile().path());
            }
            Saves.this.saveSlots();
        }
    }
}

