/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.audio.Sound;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;

public class SoundLoop {
    private static final float fadeSpeed = 0.05f;
    private final Sound sound;
    private int id = -1;
    private float volume;
    private float baseVolume;

    public SoundLoop(Sound sound, float baseVolume) {
        this.sound = sound;
        this.baseVolume = baseVolume;
    }

    public void update(float x, float y, boolean play) {
        if (this.baseVolume < 0.0f) {
            return;
        }
        if (this.id < 0) {
            if (play) {
                this.id = this.sound.loop(this.sound.calcVolume(x, y) * this.volume * this.baseVolume, 1.0f, this.sound.calcPan(x, y));
            }
        } else {
            if (play) {
                this.volume = Mathf.clamp(this.volume + 0.05f * Time.delta());
            } else {
                this.volume = Mathf.clamp(this.volume - 0.05f * Time.delta());
                if (this.volume <= 0.001f) {
                    this.sound.stop(this.id);
                    this.id = -1;
                    return;
                }
            }
            this.sound.setPan(this.id, this.sound.calcPan(x, y), this.sound.calcVolume(x, y) * this.volume * this.baseVolume);
        }
    }

    public void stop() {
        if (this.id != -1) {
            this.sound.stop(this.id);
            this.id = -1;
            this.baseVolume = -1.0f;
            this.volume = -1.0f;
        }
    }
}

