/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectIntMap;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemType;
import io.anuke.mindustry.type.Zone;

public class Stats {
    public transient ObjectIntMap<Item> itemsDelivered = new ObjectIntMap();
    public int enemyUnitsDestroyed;
    public int wavesLasted;
    public long timeLasted;
    public int buildingsBuilt;
    public int buildingsDeconstructed;
    public int buildingsDestroyed;

    public RankResult calculateRank(Zone zone, boolean launched) {
        float score = 0.0f;
        if (launched && zone.getRules().attackMode) {
            score += 3.0f;
        } else if (this.wavesLasted >= zone.conditionWave) {
            score += (float)((this.wavesLasted - zone.conditionWave) / zone.launchPeriod + 1) * 1.2f;
        }
        int capacity = zone.loadout.core().itemCapacity;
        float frac = 0.0f;
        Array<Item> obtainable = Array.with(zone.resources).select(i -> i.type == ItemType.material);
        for (Item item : obtainable) {
            frac += Mathf.clamp((float)this.itemsDelivered.get(item, 0) / (float)capacity) / (float)obtainable.size;
        }
        score += frac * 1.6f;
        if (!launched) {
            score *= 0.5f;
        }
        int rankIndex = Mathf.clamp((int)score, 0, Rank.values().length - 1);
        Rank rank = Rank.values()[rankIndex];
        String sign = Math.abs((float)rankIndex + 0.5f - score) < 0.2f || rank.name().contains("S") ? "" : ((float)rankIndex + 0.5f < score ? "-" : "+");
        return new RankResult(rank, sign);
    }

    public static enum Rank {
        F,
        D,
        C,
        B,
        A,
        S,
        SS;

    }

    public static class RankResult {
        public final Rank rank;
        public final String modifier;

        public RankResult(Rank rank, String modifier) {
            this.rank = rank;
            this.modifier = modifier;
        }
    }
}

