/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.game;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.EnumSet;
import io.anuke.arc.collection.LongQueue;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.world.Tile;

public class Teams {
    private TeamData[] map = new TeamData[Team.all.length];

    public void add(Team team, Team ... enemies) {
        this.map[team.ordinal()] = new TeamData(team, EnumSet.of((Enum[])enemies));
    }

    public TeamData get(Team team) {
        if (this.map[team.ordinal()] == null) {
            this.add(team, (Team[])Array.with(Team.all).select(t -> t != team).toArray(Team.class));
        }
        return this.map[team.ordinal()];
    }

    public boolean isActive(Team team) {
        return team == Vars.waveTeam || this.get((Team)team).cores.size > 0;
    }

    public EnumSet<Team> enemiesOf(Team team) {
        return this.get((Team)team).enemies;
    }

    public boolean areEnemies(Team team, Team other) {
        return this.enemiesOf(team).contains(other);
    }

    public Array<TeamData> getActive() {
        return Array.select(this.map, t -> t != null);
    }

    public class BrokenBlockStruct {
        public short x;
        public short y;
        public short rotation;
        public short block;
    }

    public static class TeamData {
        public final ObjectSet<Tile> cores = new ObjectSet();
        public final EnumSet<Team> enemies;
        public final Team team;
        public LongQueue brokenBlocks = new LongQueue();

        public TeamData(Team team, EnumSet<Team> enemies) {
            this.team = team;
            this.enemies = enemies;
        }
    }
}

