/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.gen;

import io.anuke.arc.graphics.Color;
import io.anuke.mindustry.core.Logic;
import io.anuke.mindustry.core.NetClient;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.effect.Fire;
import io.anuke.mindustry.entities.effect.ItemTransfer;
import io.anuke.mindustry.entities.effect.Lightning;
import io.anuke.mindustry.entities.effect.Puddle;
import io.anuke.mindustry.entities.traits.ShooterTrait;
import io.anuke.mindustry.entities.type.BaseUnit;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.entities.units.UnitCommand;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.io.TypeIO;
import io.anuke.mindustry.net.Administration;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.type.Weapon;
import io.anuke.mindustry.ui.fragments.BlockInventoryFragment;
import io.anuke.mindustry.ui.fragments.HudFragment;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Build;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BuildBlock;
import io.anuke.mindustry.world.blocks.defense.Door;
import io.anuke.mindustry.world.blocks.distribution.ItemBridge;
import io.anuke.mindustry.world.blocks.distribution.MassDriver;
import io.anuke.mindustry.world.blocks.distribution.Sorter;
import io.anuke.mindustry.world.blocks.logic.MessageBlock;
import io.anuke.mindustry.world.blocks.power.PowerNode;
import io.anuke.mindustry.world.blocks.sandbox.ItemSource;
import io.anuke.mindustry.world.blocks.sandbox.LiquidSource;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;
import io.anuke.mindustry.world.blocks.storage.Unloader;
import io.anuke.mindustry.world.blocks.units.CommandCenter;
import io.anuke.mindustry.world.blocks.units.MechPad;
import io.anuke.mindustry.world.blocks.units.UnitFactory;
import java.nio.ByteBuffer;

public class RemoteReadClient {
    public static void readPacket(ByteBuffer buffer, int id) {
        if (id == 0) {
            try {
                Team team = TypeIO.readTeam(buffer);
                int x = buffer.getInt();
                int y = buffer.getInt();
                Build.beginBreak(team, x, y);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'beginBreak'!", e);
            }
        } else if (id == 1) {
            try {
                Team team = TypeIO.readTeam(buffer);
                int x = buffer.getInt();
                int y = buffer.getInt();
                Block result = TypeIO.readBlock(buffer);
                int rotation = buffer.getInt();
                Build.beginPlace(team, x, y, result, rotation);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'beginPlace'!", e);
            }
        } else if (id == 3) {
            try {
                BulletType type = TypeIO.readBulletType(buffer);
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                float angle = buffer.getFloat();
                Bullet.createBullet(type, x, y, angle);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'createBullet'!", e);
            }
        } else if (id == 4) {
            try {
                BulletType type = TypeIO.readBulletType(buffer);
                Team team = TypeIO.readTeam(buffer);
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                float angle = buffer.getFloat();
                Bullet.createBullet(type, team, x, y, angle);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'createBullet'!", e);
            }
        } else if (id == 5) {
            try {
                int seed = buffer.getInt();
                Team team = TypeIO.readTeam(buffer);
                Color color = TypeIO.readColor(buffer);
                float damage = buffer.getFloat();
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                float rotation = buffer.getFloat();
                int length = buffer.getInt();
                Lightning.createLighting(seed, team, color, damage, x, y, rotation, length);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'createLighting'!", e);
            }
        } else if (id == 7) {
            try {
                Logic.launchZone();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'launchZone'!", e);
            }
        } else if (id == 8) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Tile other = TypeIO.readTile(buffer);
                ItemBridge.linkItemBridge(player, tile, other);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'linkItemBridge'!", e);
            }
        } else if (id == 9) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                int position = buffer.getInt();
                MassDriver.linkMassDriver(player, tile, position);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'linkMassDriver'!", e);
            }
        } else if (id == 10) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Tile other = TypeIO.readTile(buffer);
                PowerNode.linkPowerNodes(player, tile, other);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'linkPowerNodes'!", e);
            }
        } else if (id == 13) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                UnitCommand command = TypeIO.readUnitCommand(buffer);
                CommandCenter.onCommandCenterSet(player, tile, command);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onCommandCenterSet'!", e);
            }
        } else if (id == 14) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                Block block = TypeIO.readBlock(buffer);
                int builderID = buffer.getInt();
                byte rotation = buffer.get();
                Team team = TypeIO.readTeam(buffer);
                BuildBlock.onConstructFinish(tile, block, builderID, rotation, team);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onConstructFinish'!", e);
            }
        } else if (id == 15) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                Block block = TypeIO.readBlock(buffer);
                int builderID = buffer.getInt();
                BuildBlock.onDeconstructFinish(tile, block, builderID);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onDeconstructFinish'!", e);
            }
        } else if (id == 16) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                boolean open = buffer.get() == 1;
                Door.onDoorToggle(player, tile, open);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onDoorToggle'!", e);
            }
        } else if (id == 17) {
            try {
                byte groupID = buffer.get();
                short amount = buffer.getShort();
                short dataLen = buffer.getShort();
                byte[] data = TypeIO.readBytes(buffer);
                NetClient.onEntitySnapshot(groupID, amount, dataLen, data);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onEntitySnapshot'!", e);
            }
        } else if (id == 18) {
            try {
                Team winner = TypeIO.readTeam(buffer);
                Logic.onGameOver(winner);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onGameOver'!", e);
            }
        } else if (id == 19) {
            try {
                ShooterTrait shooter = TypeIO.readShooter(buffer);
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                float rotation = buffer.getFloat();
                boolean left = buffer.get() == 1;
                Weapon.onGenericShootWeapon(shooter, x, y, rotation, left);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onGenericShootWeapon'!", e);
            }
        } else if (id == 20) {
            try {
                String message = TypeIO.readString(buffer);
                NetClient.onInfoMessage(message);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onInfoMessage'!", e);
            }
        } else if (id == 21) {
            try {
                Packets.KickReason reason = TypeIO.readKick(buffer);
                NetClient.onKick(reason);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onKick'!", e);
            }
        } else if (id == 22) {
            try {
                String reason = TypeIO.readString(buffer);
                NetClient.onKick(reason);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onKick'!", e);
            }
        } else if (id == 23) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                MechPad.onMechFactoryDone(tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onMechFactoryDone'!", e);
            }
        } else if (id == 24) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                MechPad.onMechFactoryTap(player, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onMechFactoryTap'!", e);
            }
        } else if (id == 26) {
            try {
                long time = buffer.getLong();
                NetClient.onPingResponse(time);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPingResponse'!", e);
            }
        } else if (id == 27) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Player.onPlayerDeath(player);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPlayerDeath'!", e);
            }
        } else if (id == 28) {
            try {
                int playerid = buffer.getInt();
                NetClient.onPlayerDisconnect(playerid);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPlayerDisconnect'!", e);
            }
        } else if (id == 29) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                float rotation = buffer.getFloat();
                boolean left = buffer.get() == 1;
                Weapon.onPlayerShootWeapon(player, x, y, rotation, left);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPlayerShootWeapon'!", e);
            }
        } else if (id == 30) {
            try {
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                NetClient.onPositionSet(x, y);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPositionSet'!", e);
            }
        } else if (id == 31) {
            try {
                int puddleid = buffer.getInt();
                Puddle.onPuddleRemoved(puddleid);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onPuddleRemoved'!", e);
            }
        } else if (id == 32) {
            try {
                int fid = buffer.getInt();
                Fire.onRemoveFire(fid);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onRemoveFire'!", e);
            }
        } else if (id == 33) {
            try {
                float waveTime = buffer.getFloat();
                int wave = buffer.getInt();
                int enemies = buffer.getInt();
                short coreDataLen = buffer.getShort();
                byte[] coreData = TypeIO.readBytes(buffer);
                NetClient.onStateSnapshot(waveTime, wave, enemies, coreDataLen, coreData);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onStateSnapshot'!", e);
            }
        } else if (id == 34) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                float health = buffer.getFloat();
                TileEntity.onTileDamage(tile, health);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onTileDamage'!", e);
            }
        } else if (id == 35) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                TileEntity.onTileDestroyed(tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onTileDestroyed'!", e);
            }
        } else if (id == 36) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                InputHandler.onTileTapped(player, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onTileTapped'!", e);
            }
        } else if (id == 37) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Administration.TraceInfo info = TypeIO.readTraceInfo(buffer);
                NetClient.onTraceInfo(player, info);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onTraceInfo'!", e);
            }
        } else if (id == 38) {
            try {
                BaseUnit unit = TypeIO.readBaseUnit(buffer);
                BaseUnit.onUnitDeath(unit);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onUnitDeath'!", e);
            }
        } else if (id == 39) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                int spawns = buffer.getInt();
                UnitFactory.onUnitFactorySpawn(tile, spawns);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onUnitFactorySpawn'!", e);
            }
        } else if (id == 40) {
            try {
                Tile tile = TypeIO.readTile(buffer);
                Player player = TypeIO.readPlayer(buffer);
                CoreBlock.onUnitRespawn(tile, player);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onUnitRespawn'!", e);
            }
        } else if (id == 41) {
            try {
                NetClient.onWorldDataBegin();
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'onWorldDataBegin'!", e);
            }
        } else if (id == 42) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                BaseUnit unit = TypeIO.readBaseUnit(buffer);
                HudFragment.removeUnitEditor(player, unit);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'removeUnitEditor'!", e);
            }
        } else if (id == 43) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Item item = TypeIO.readItem(buffer);
                int amount = buffer.getInt();
                BlockInventoryFragment.requestItem(player, tile, item, amount);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'requestItem'!", e);
            }
        } else if (id == 45) {
            try {
                String message = TypeIO.readString(buffer);
                NetClient.sendMessage(message);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'sendMessage'!", e);
            }
        } else if (id == 46) {
            try {
                String message = TypeIO.readString(buffer);
                String sender = TypeIO.readString(buffer);
                Player playersender = TypeIO.readPlayer(buffer);
                NetClient.sendMessage(message, sender, playersender);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'sendMessage'!", e);
            }
        } else if (id == 47) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Item item = TypeIO.readItem(buffer);
                ItemSource.setItemSourceItem(player, tile, item);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setItemSourceItem'!", e);
            }
        } else if (id == 48) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Liquid liquid = TypeIO.readLiquid(buffer);
                LiquidSource.setLiquidSourceLiquid(player, tile, liquid);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setLiquidSourceLiquid'!", e);
            }
        } else if (id == 49) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                String text = TypeIO.readString(buffer);
                MessageBlock.setMessageBlockText(player, tile, text);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setMessageBlockText'!", e);
            }
        } else if (id == 50) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Team team = TypeIO.readTeam(buffer);
                HudFragment.setPlayerTeamEditor(player, team);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setPlayerTeamEditor'!", e);
            }
        } else if (id == 51) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Item item = TypeIO.readItem(buffer);
                Unloader.setSortedUnloaderItem(player, tile, item);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setSortedUnloaderItem'!", e);
            }
        } else if (id == 52) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Item item = TypeIO.readItem(buffer);
                Sorter.setSorterItem(player, tile, item);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'setSorterItem'!", e);
            }
        } else if (id == 53) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                UnitType type = TypeIO.readUnitType(buffer);
                HudFragment.spawnUnitEditor(player, type);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'spawnUnitEditor'!", e);
            }
        } else if (id == 54) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                InputHandler.transferInventory(player, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'transferInventory'!", e);
            }
        } else if (id == 55) {
            try {
                Item item = TypeIO.readItem(buffer);
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                Unit to = TypeIO.readUnit(buffer);
                ItemTransfer.transferItemEffect(item, x, y, to);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'transferItemEffect'!", e);
            }
        } else if (id == 56) {
            try {
                Item item = TypeIO.readItem(buffer);
                int amount = buffer.getInt();
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                Tile tile = TypeIO.readTile(buffer);
                ItemTransfer.transferItemTo(item, amount, x, y, tile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'transferItemTo'!", e);
            }
        } else if (id == 57) {
            try {
                Item item = TypeIO.readItem(buffer);
                float x = buffer.getFloat();
                float y = buffer.getFloat();
                Unit to = TypeIO.readUnit(buffer);
                ItemTransfer.transferItemToUnit(item, x, y, to);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'transferItemToUnit'!", e);
            }
        } else if (id == 58) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Tile other = TypeIO.readTile(buffer);
                ItemBridge.unlinkItemBridge(player, tile, other);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'unlinkItemBridge'!", e);
            }
        } else if (id == 59) {
            try {
                Player player = TypeIO.readPlayer(buffer);
                Tile tile = TypeIO.readTile(buffer);
                Tile other = TypeIO.readTile(buffer);
                PowerNode.unlinkPowerNodes(player, tile, other);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to to read remote method 'unlinkPowerNodes'!", e);
            }
        } else {
            throw new RuntimeException("Invalid read method ID: " + id + "");
        }
    }
}

