/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.CapStyle;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.graphics.Pal;

public class Drawf {
    public static void dashCircle(float x, float y, float rad, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.dashCircle(x, y, rad);
        Lines.stroke(1.0f, color);
        Lines.dashCircle(x, y, rad);
        Draw.reset();
    }

    public static void circles(float x, float y, float rad) {
        Drawf.circles(x, y, rad, Pal.accent);
    }

    public static void circles(float x, float y, float rad, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.circle(x, y, rad);
        Lines.stroke(1.0f, color);
        Lines.circle(x, y, rad);
        Draw.reset();
    }

    public static void square(float x, float y, float radius, Color color) {
        Lines.stroke(3.0f, Pal.gray);
        Lines.square(x, y, radius + 1.0f, 45.0f);
        Lines.stroke(1.0f, color);
        Lines.square(x, y, radius + 1.0f, 45.0f);
        Draw.reset();
    }

    public static void square(float x, float y, float radius) {
        Drawf.square(x, y, radius, Pal.accent);
    }

    public static void arrow(float x, float y, float x2, float y2, float length, float radius) {
        float angle = Angles.angle(x, y, x2, y2);
        float space = 2.0f;
        Tmp.v1.set(x2, y2).sub(x, y).limit(length);
        float vx = Tmp.v1.x + x;
        float vy = Tmp.v1.y + y;
        Draw.color(Pal.gray);
        Fill.poly(vx, vy, 3, radius + space, angle);
        Draw.color(Pal.accent);
        Fill.poly(vx, vy, 3, radius, angle);
        Draw.color();
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2, float scale) {
        Drawf.laser(line, edge, x, y, x2, y2, Mathf.angle(x2 - x, y2 - y), scale);
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2) {
        Drawf.laser(line, edge, x, y, x2, y2, Mathf.angle(x2 - x, y2 - y), 1.0f);
    }

    public static void laser(TextureRegion line, TextureRegion edge, float x, float y, float x2, float y2, float rotation, float scale) {
        Tmp.v1.trns(rotation, 8.0f * scale * Draw.scl);
        Draw.rect(edge, x, y, (float)edge.getWidth() * scale * Draw.scl, (float)edge.getHeight() * scale * Draw.scl, rotation + 180.0f);
        Draw.rect(edge, x2, y2, (float)edge.getWidth() * scale * Draw.scl, (float)edge.getHeight() * scale * Draw.scl, rotation);
        Lines.stroke(12.0f * scale);
        Lines.precise(true);
        Lines.line(line, x + Tmp.v1.x, y + Tmp.v1.y, x2 - Tmp.v1.x, y2 - Tmp.v1.y, CapStyle.none, 0.0f);
        Lines.precise(false);
        Lines.stroke(1.0f);
    }

    public static void tri(float x, float y, float width, float length, float rotation) {
        float oy = 0.26984128f * length;
        Draw.rect(Core.atlas.find("shape-3"), x, y - oy + length / 2.0f, width, length, width / 2.0f, oy, rotation - 90.0f);
    }
}

