/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.IntArray;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.graphics.Camera;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.MultiCacheBatch;
import io.anuke.arc.graphics.g2d.SpriteBatch;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import java.util.Arrays;

public class FloorRenderer
implements Disposable {
    private static final int chunksize = 64;
    private Chunk[][] cache;
    private MultiCacheBatch cbatch;
    private IntSet drawnLayerSet = new IntSet();
    private IntArray drawnLayers = new IntArray();
    private ObjectSet<CacheLayer> used = new ObjectSet();

    public FloorRenderer() {
        Events.on(EventType.WorldLoadEvent.class, event -> this.clearTiles());
    }

    public void drawFloor() {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        int crangex = (int)(camera.width / 512.0f) + 1;
        int crangey = (int)(camera.height / 512.0f) + 1;
        int camx = (int)(camera.position.x / 512.0f);
        int camy = (int)(camera.position.y / 512.0f);
        int layers = CacheLayer.values().length;
        this.drawnLayers.clear();
        this.drawnLayerSet.clear();
        for (int x = -crangex; x <= crangex; ++x) {
            for (int y = -crangey; y <= crangey; ++y) {
                int worldx = camx + x;
                int worldy = camy + y;
                if (!Structs.inBounds(worldx, worldy, this.cache)) continue;
                Chunk chunk = this.cache[worldx][worldy];
                for (int i = 0; i < layers; ++i) {
                    if (chunk.caches[i] == -1 || i == CacheLayer.walls.ordinal()) continue;
                    this.drawnLayerSet.add(i);
                }
            }
        }
        IntSet.IntSetIterator it = this.drawnLayerSet.iterator();
        while (it.hasNext) {
            this.drawnLayers.add(it.next());
        }
        this.drawnLayers.sort();
        Draw.flush();
        this.beginDraw();
        for (int i = 0; i < this.drawnLayers.size; ++i) {
            CacheLayer layer = CacheLayer.values()[this.drawnLayers.get(i)];
            this.drawLayer(layer);
        }
        this.endDraw();
    }

    public void beginc() {
        this.cbatch.beginDraw();
    }

    public void endc() {
        this.cbatch.endDraw();
    }

    public void beginDraw() {
        if (this.cache == null) {
            return;
        }
        this.cbatch.setProjection(Core.camera.projection());
        this.cbatch.beginDraw();
        Core.gl.glEnable(3042);
    }

    public void endDraw() {
        if (this.cache == null) {
            return;
        }
        this.cbatch.endDraw();
    }

    public void drawLayer(CacheLayer layer) {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        int crangex = (int)(camera.width / 512.0f) + 1;
        int crangey = (int)(camera.height / 512.0f) + 1;
        layer.begin();
        for (int x = -crangex; x <= crangex; ++x) {
            for (int y = -crangey; y <= crangey; ++y) {
                int worldx = (int)(camera.position.x / 512.0f) + x;
                int worldy = (int)(camera.position.y / 512.0f) + y;
                if (!Structs.inBounds(worldx, worldy, this.cache)) continue;
                Chunk chunk = this.cache[worldx][worldy];
                if (chunk.caches[layer.ordinal()] == -1) continue;
                this.cbatch.drawCache(chunk.caches[layer.ordinal()]);
            }
        }
        layer.end();
    }

    private void cacheChunk(int cx, int cy) {
        this.used.clear();
        Chunk chunk = this.cache[cx][cy];
        for (int tilex = cx * 64; tilex < (cx + 1) * 64; ++tilex) {
            for (int tiley = cy * 64; tiley < (cy + 1) * 64; ++tiley) {
                Tile tile = Vars.world.tile(tilex, tiley);
                if (tile == null) continue;
                if (tile.block().cacheLayer != CacheLayer.normal) {
                    this.used.add(tile.block().cacheLayer);
                    continue;
                }
                this.used.add(tile.floor().cacheLayer);
            }
        }
        for (CacheLayer layer : this.used) {
            this.cacheChunkLayer(cx, cy, chunk, layer);
        }
    }

    private void cacheChunkLayer(int cx, int cy, Chunk chunk, CacheLayer layer) {
        SpriteBatch current = Core.batch;
        Core.batch = this.cbatch;
        this.cbatch.beginCache();
        for (int tilex = cx * 64; tilex < (cx + 1) * 64; ++tilex) {
            for (int tiley = cy * 64; tiley < (cy + 1) * 64; ++tiley) {
                Tile tile = Vars.world.tile(tilex, tiley);
                if (tile == null) continue;
                Floor floor = tile.floor();
                if (!(tile.block().cacheLayer != layer || layer != CacheLayer.walls || tile.isDarkened() && tile.rotation() >= 5)) {
                    tile.block().draw(tile);
                    continue;
                }
                if (floor.cacheLayer == layer && (Vars.world.isAccessible(tile.x, tile.y) || tile.block().cacheLayer != CacheLayer.walls || !tile.block().fillsTile)) {
                    floor.draw(tile);
                    continue;
                }
                if (floor.cacheLayer.ordinal() >= layer.ordinal() || layer == CacheLayer.walls) continue;
                floor.drawNonLayer(tile);
            }
        }
        Core.batch = current;
        chunk.caches[layer.ordinal()] = this.cbatch.endCache();
    }

    public void clearTiles() {
        if (this.cbatch != null) {
            this.cbatch.dispose();
        }
        int chunksx = Mathf.ceil((float)Vars.world.width() / 64.0f);
        int chunksy = Mathf.ceil((float)Vars.world.height() / 64.0f);
        this.cache = new Chunk[chunksx][chunksy];
        this.cbatch = new MultiCacheBatch(16384);
        Time.mark();
        for (int x = 0; x < chunksx; ++x) {
            for (int y = 0; y < chunksy; ++y) {
                this.cache[x][y] = new Chunk();
                Arrays.fill(this.cache[x][y].caches, -1);
                this.cacheChunk(x, y);
            }
        }
        Log.info("Time to cache: {0}", Float.valueOf(Time.elapsed()));
    }

    @Override
    public void dispose() {
        if (this.cbatch != null) {
            this.cbatch.dispose();
            this.cbatch = null;
        }
    }

    private class Chunk {
        int[] caches = new int[CacheLayer.values().length];

        private Chunk() {
        }
    }
}

