/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Mesh;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.VertexAttribute;
import io.anuke.arc.graphics.g2d.BatchShader;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.graphics.glutils.Shader;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.Strings;

public class IndexedRenderer
implements Disposable {
    private static final int vsize = 5;
    private Shader program = new Shader(Strings.join("\n", "attribute vec4 a_position;", "attribute vec4 a_color;", "attribute vec2 a_texCoord0;", "uniform mat4 u_projTrans;", "varying vec4 v_color;", "varying vec2 v_texCoords;", "", "void main(){", "   v_color = a_color;", "   v_color.a = v_color.a * (255.0/254.0);", "   v_texCoords = a_texCoord0;", "   gl_Position = u_projTrans * a_position;", "}"), Strings.join("\n", "#ifdef GL_ES", "#define LOWP lowp", "precision mediump float;", "#else", "#define LOWP ", "#endif", "", "varying LOWP vec4 v_color;", "varying vec2 v_texCoords;", "uniform sampler2D u_texture;", "", "void main(){", "  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);", "}"));
    private Mesh mesh;
    private float[] tmpVerts = new float[30];
    private float[] vertices;
    private Matrix3 projMatrix = new Matrix3();
    private Matrix3 transMatrix = new Matrix3();
    private Matrix3 combined = new Matrix3();
    private float color = Color.white.toFloatBits();

    public IndexedRenderer(int sprites) {
        this.resize(sprites);
    }

    public void render(Texture texture) {
        Core.gl.glEnable(3042);
        this.updateMatrix();
        this.program.begin();
        texture.bind();
        this.program.setUniformMatrix4("u_projTrans", BatchShader.copyTransform(this.combined));
        this.program.setUniformi("u_texture", 0);
        this.mesh.render(this.program, 4, 0, this.vertices.length / 5);
        this.program.end();
    }

    public void setColor(Color color) {
        this.color = color.toFloatBits();
    }

    public void draw(int index, TextureRegion region, float x, float y, float w, float h) {
        float fx2 = x + w;
        float fy2 = y + h;
        float u = region.getU();
        float v = region.getV2();
        float u2 = region.getU2();
        float v2 = region.getV();
        float[] vertices = this.tmpVerts;
        int idx = 0;
        vertices[idx++] = x;
        vertices[idx++] = y;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v;
        vertices[idx++] = x;
        vertices[idx++] = fy2;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v2;
        vertices[idx++] = fx2;
        vertices[idx++] = fy2;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v2;
        vertices[idx++] = x;
        vertices[idx++] = y;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v;
        vertices[idx++] = fx2;
        vertices[idx++] = y;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v;
        vertices[idx++] = fx2;
        vertices[idx++] = fy2;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v2;
        this.mesh.updateVertices(index * 5 * 6, vertices);
    }

    public void draw(int index, TextureRegion region, float x, float y, float w, float h, float rotation) {
        float u = region.getU();
        float v = region.getV2();
        float u2 = region.getU2();
        float v2 = region.getV();
        float originX = w / 2.0f;
        float originY = h / 2.0f;
        float cos = Mathf.cosDeg(rotation);
        float sin = Mathf.sinDeg(rotation);
        float fx = -originX;
        float fy = -originY;
        float fx2 = w - originX;
        float fy2 = h - originY;
        float worldOriginX = x + originX;
        float worldOriginY = y + originY;
        float x1 = cos * fx - sin * fy;
        float y1 = sin * fx + cos * fy;
        float x2 = cos * fx - sin * fy2;
        float y2 = sin * fx + cos * fy2;
        float x3 = cos * fx2 - sin * fy2;
        float y3 = sin * fx2 + cos * fy2;
        float x4 = x1 + (x3 - x2);
        float y4 = y3 - (y2 - y1);
        x1 += worldOriginX;
        y1 += worldOriginY;
        x2 += worldOriginX;
        y2 += worldOriginY;
        x3 += worldOriginX;
        y3 += worldOriginY;
        x4 += worldOriginX;
        y4 += worldOriginY;
        float[] vertices = this.tmpVerts;
        int idx = 0;
        vertices[idx++] = x1;
        vertices[idx++] = y1;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v;
        vertices[idx++] = x3;
        vertices[idx++] = y3;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v2;
        vertices[idx++] = x4;
        vertices[idx++] = y4;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v2;
        vertices[idx++] = x1;
        vertices[idx++] = y1;
        vertices[idx++] = this.color;
        vertices[idx++] = u;
        vertices[idx++] = v;
        vertices[idx++] = x2;
        vertices[idx++] = y2;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v;
        vertices[idx++] = x3;
        vertices[idx++] = y3;
        vertices[idx++] = this.color;
        vertices[idx++] = u2;
        vertices[idx++] = v2;
        this.mesh.updateVertices(index * 5 * 6, vertices);
    }

    public Matrix3 getTransformMatrix() {
        return this.transMatrix;
    }

    public void setProjectionMatrix(Matrix3 matrix) {
        this.projMatrix = matrix;
    }

    public void resize(int sprites) {
        if (this.mesh != null) {
            this.mesh.dispose();
        }
        this.mesh = new Mesh(true, 6 * sprites, 0, new VertexAttribute(1, 2, "a_position"), new VertexAttribute(4, 4, "a_color"), new VertexAttribute(16, 2, "a_texCoord0"));
        this.vertices = new float[6 * sprites * 5];
        this.mesh.setVertices(this.vertices);
    }

    private void updateMatrix() {
        this.combined.set(this.projMatrix).mul(this.transMatrix);
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        this.program.dispose();
    }
}

