/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.PositionConsumer;
import io.anuke.arc.graphics.Camera;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.CacheBatch;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.SpriteBatch;
import io.anuke.arc.graphics.g2d.SpriteCache;
import io.anuke.arc.graphics.glutils.FrameBuffer;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.Matrix3;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.arc.util.noise.RidgedPerlin;
import io.anuke.arc.util.noise.Simplex;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.UnitTypes;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.CachedTile;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.OreBlock;

public class MenuRenderer
implements Disposable {
    private static final float darkness = 0.3f;
    private final int width = !Vars.mobile ? 100 : 60;
    private final int height = !Vars.mobile ? 50 : 40;
    private int cacheFloor;
    private int cacheWall;
    private Camera camera = new Camera();
    private Matrix3 mat = new Matrix3();
    private FrameBuffer shadows;
    private CacheBatch batch;
    private float time = 0.0f;
    private float flyerRot = 45.0f;
    private int flyers = Mathf.chance(0.2) ? Mathf.random(35) : Mathf.random(15);
    private UnitType flyerType = Structs.select(UnitTypes.wraith, UnitTypes.wraith, UnitTypes.ghoul, UnitTypes.phantom, UnitTypes.phantom, UnitTypes.revenant);

    public MenuRenderer() {
        Time.mark();
        this.generate();
        this.cache();
        Log.info("Time to generate menu: {0}", Float.valueOf(Time.elapsed()));
    }

    private void generate() {
        Tile[][] tiles = Vars.world.createTiles(this.width, this.height);
        Array<Block> ores = Vars.content.blocks().select(b -> b instanceof OreBlock);
        this.shadows = new FrameBuffer(this.width, this.height);
        int offset = Mathf.random(100000);
        Simplex s1 = new Simplex(offset);
        Simplex s2 = new Simplex(offset + 1);
        Simplex s3 = new Simplex(offset + 2);
        RidgedPerlin rid = new RidgedPerlin(1 + offset, 1);
        Block[] selected = (Block[])Structs.select({Blocks.sand, Blocks.sandRocks}, {Blocks.shale, Blocks.shaleRocks}, {Blocks.ice, Blocks.icerocks}, {Blocks.sand, Blocks.sandRocks}, {Blocks.shale, Blocks.shaleRocks}, {Blocks.ice, Blocks.icerocks}, {Blocks.moss, Blocks.sporePine});
        Block[] selected2 = (Block[])Structs.select({Blocks.ignarock, Blocks.duneRocks}, {Blocks.ignarock, Blocks.duneRocks}, {Blocks.stone, Blocks.rocks}, {Blocks.stone, Blocks.rocks}, {Blocks.moss, Blocks.sporerocks}, {Blocks.salt, Blocks.saltRocks});
        Block ore1 = ores.random();
        ores.remove(ore1);
        Block ore2 = ores.random();
        double tr1 = Mathf.random(0.65f, 0.85f);
        double tr2 = Mathf.random(0.65f, 0.85f);
        boolean doheat = Mathf.chance(0.25);
        boolean tendrils = Mathf.chance(0.25);
        boolean tech = Mathf.chance(0.25);
        int secSize = 10;
        Block floord = selected[0];
        Block walld = selected[1];
        Block floord2 = selected2[0];
        Block walld2 = selected2[1];
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                double base;
                double heat;
                Block floor = floord;
                Block ore = Blocks.air;
                Block wall = Blocks.air;
                if (s1.octaveNoise2D(3.0, 0.5, 0.05, x, y) > 0.5) {
                    wall = walld;
                }
                if (s3.octaveNoise2D(3.0, 0.5, 0.05, x, y) > 0.5) {
                    floor = floord2;
                    if (wall != Blocks.air) {
                        wall = walld2;
                    }
                }
                if (s2.octaveNoise2D(3.0, 0.3, 0.03333333333333333, x, y) > tr1) {
                    ore = ore1;
                }
                if (s2.octaveNoise2D(2.0, 0.2, 0.06666666666666667, x, y + 99999) > tr2) {
                    ore = ore2;
                }
                if (doheat && (heat = s3.octaveNoise2D(4.0, 0.6, 0.02, x, y + 9999)) > (base = 0.65)) {
                    ore = Blocks.air;
                    wall = Blocks.air;
                    floor = Blocks.ignarock;
                    if (heat > base + 0.1) {
                        floor = Blocks.hotrock;
                        if (heat > base + 0.15) {
                            floor = Blocks.magmarock;
                        }
                    }
                }
                if (tech) {
                    int mx = x % secSize;
                    int my = y % secSize;
                    int sclx = x / secSize;
                    int scly = y / secSize;
                    if (s1.octaveNoise2D(2.0, 0.1f, 0.5, sclx, scly) > (double)0.4f && (mx == 0 || my == 0 || mx == secSize - 1 || my == secSize - 1)) {
                        floor = Blocks.darkPanel3;
                        if (Mathf.dst(mx, my, secSize / 2, secSize / 2) > (float)secSize / 2.0f + 1.0f) {
                            floor = Blocks.darkPanel4;
                        }
                        if (wall != Blocks.air && Mathf.chance(0.7)) {
                            wall = Blocks.darkMetal;
                        }
                    }
                }
                if (tendrils && rid.getValue(x, y, 0.05882353f) > 0.0f) {
                    Block block = floor = Mathf.chance(0.2) ? Blocks.sporeMoss : Blocks.moss;
                    if (wall != Blocks.air) {
                        wall = Blocks.sporerocks;
                    }
                }
                CachedTile tile = new CachedTile();
                tiles[x][y] = tile;
                tile.x = (short)x;
                tile.y = (short)y;
                tile.setFloor((Floor)floor);
                tile.setBlock(wall);
                tile.setOverlay(ore);
            }
        }
    }

    private void cache() {
        Tile tile;
        int y;
        int x;
        Draw.proj().setOrtho(0.0f, 0.0f, this.shadows.getWidth(), this.shadows.getHeight());
        this.shadows.beginDraw(Color.clear);
        Draw.color(Color.black);
        for (int x2 = 0; x2 < this.width; ++x2) {
            for (int y2 = 0; y2 < this.height; ++y2) {
                if (Vars.world.rawTile(x2, y2).block() == Blocks.air) continue;
                Fill.rect((float)x2 + 0.5f, (float)y2 + 0.5f, 1.0f, 1.0f);
            }
        }
        Draw.color();
        this.shadows.endDraw();
        SpriteBatch prev = Core.batch;
        this.batch = new CacheBatch(new SpriteCache(this.width * this.height * 6, false));
        Core.batch = this.batch;
        this.batch.beginCache();
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                tile = Vars.world.rawTile(x, y);
                tile.floor().draw(tile);
            }
        }
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                tile = Vars.world.rawTile(x, y);
                if (tile.overlay() == Blocks.air) continue;
                tile.overlay().draw(tile);
            }
        }
        this.cacheFloor = this.batch.endCache();
        this.batch.beginCache();
        for (x = 0; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                tile = Vars.world.rawTile(x, y);
                if (tile.block() == Blocks.air) continue;
                tile.block().draw(tile);
            }
        }
        this.cacheWall = this.batch.endCache();
        Core.batch = prev;
    }

    public void render() {
        this.time += Time.delta();
        float scaling = Math.max(Scl.scl(4.0f), Math.max((float)Core.graphics.getWidth() / (((float)this.width - 1.0f) * 8.0f), (float)Core.graphics.getHeight() / (((float)this.height - 1.0f) * 8.0f)));
        this.camera.position.set((float)(this.width * 8) / 2.0f, (float)(this.height * 8) / 2.0f);
        this.camera.resize((float)Core.graphics.getWidth() / scaling, (float)Core.graphics.getHeight() / scaling);
        this.mat.set(Draw.proj());
        Draw.flush();
        Draw.proj(this.camera.projection());
        this.batch.setProjection(this.camera.projection());
        this.batch.beginDraw();
        this.batch.drawCache(this.cacheFloor);
        this.batch.endDraw();
        Draw.color();
        Draw.rect(Draw.wrap((Texture)this.shadows.getTexture()), (float)(this.width * 8) / 2.0f - 4.0f, (float)(this.height * 8) / 2.0f - 4.0f, (float)(this.width * 8), (float)(-this.height * 8));
        Draw.flush();
        this.batch.beginDraw();
        this.batch.drawCache(this.cacheWall);
        this.batch.endDraw();
        this.drawFlyers();
        Draw.proj(this.mat);
        Draw.color(0.0f, 0.0f, 0.0f, 0.3f);
        Fill.crect(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        Draw.color();
    }

    private void drawFlyers() {
        Draw.color(0.0f, 0.0f, 0.0f, 0.4f);
        float size = (float)Math.max(this.flyerType.iconRegion.getWidth(), this.flyerType.iconRegion.getHeight()) * Draw.scl * 1.6f;
        this.flyers((x, y) -> Draw.rect(this.flyerType.region, x - 12.0f, y - 13.0f, this.flyerRot - 90.0f));
        this.flyers((x, y) -> Draw.rect("circle-shadow", x, y, size, size));
        Draw.color();
        this.flyers((x, y) -> {
            float engineOffset = this.flyerType.engineOffset;
            float engineSize = this.flyerType.engineSize;
            float rotation = this.flyerRot;
            Draw.color(Pal.engine);
            Fill.circle(x + Angles.trnsx(rotation + 180.0f, engineOffset), y + Angles.trnsy(rotation + 180.0f, engineOffset), engineSize + Mathf.absin(Time.time(), 2.0f, engineSize / 4.0f));
            Draw.color(Color.white);
            Fill.circle(x + Angles.trnsx(rotation + 180.0f, engineOffset - 1.0f), y + Angles.trnsy(rotation + 180.0f, engineOffset - 1.0f), (engineSize + Mathf.absin(Time.time(), 2.0f, engineSize / 4.0f)) / 2.0f);
            Draw.color();
            Draw.rect(this.flyerType.region, x, y, this.flyerRot - 90.0f);
        });
    }

    private void flyers(PositionConsumer cons) {
        float tw = (float)(this.width * 8) * 1.0f + 8.0f;
        float th = (float)(this.height * 8) * 1.0f + 8.0f;
        float range = 500.0f;
        float offset = -100.0f;
        for (int i = 0; i < this.flyers; ++i) {
            Tmp.v1.trns(this.flyerRot, this.time * (2.0f + this.flyerType.speed));
            cons.accept((Mathf.randomSeedRange(i, range) + Tmp.v1.x + Mathf.absin(this.time + Mathf.randomSeedRange(i + 2, 500.0f), 10.0f, 3.4f) + offset) % (tw + (float)Mathf.randomSeed(i + 5, 0, 500)), (Mathf.randomSeedRange(i + 1, range) + Tmp.v1.y + Mathf.absin(this.time + Mathf.randomSeedRange(i + 3, 500.0f), 10.0f, 3.4f) + offset) % th);
        }
    }

    @Override
    public void dispose() {
        this.batch.dispose();
        this.shadows.dispose();
    }
}

