/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Pixmaps;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Fill;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Disposable;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.graphics.CacheLayer;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.world.Tile;

public class MinimapRenderer
implements Disposable {
    private static final float baseSize = 16.0f;
    private final Array<Unit> units = new Array();
    private Pixmap pixmap;
    private Texture texture;
    private TextureRegion region;
    private Rectangle rect = new Rectangle();
    private float zoom = 4.0f;

    public MinimapRenderer() {
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.reset();
            this.updateAll();
        });
        Events.on(EventType.TileChangeEvent.class, event -> Core.app.post(() -> this.update(event.tile)));
    }

    public Pixmap getPixmap() {
        return this.pixmap;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void zoomBy(float amount) {
        this.zoom += amount;
        this.setZoom(this.zoom);
    }

    public void setZoom(float amount) {
        this.zoom = Mathf.clamp(amount, 1.0f, (float)Math.min(Vars.world.width(), Vars.world.height()) / 16.0f / 2.0f);
    }

    public float getZoom() {
        return this.zoom;
    }

    public void reset() {
        if (this.pixmap != null) {
            this.pixmap.dispose();
            this.texture.dispose();
        }
        this.setZoom(4.0f);
        this.pixmap = new Pixmap(Vars.world.width(), Vars.world.height(), Pixmap.Format.RGBA8888);
        this.texture = new Texture(this.pixmap);
        this.region = new TextureRegion(this.texture);
    }

    public void drawEntities(float x, float y, float w, float h) {
        this.updateUnitArray();
        float sz = 16.0f * this.zoom;
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        this.rect.set((dx - sz) * 8.0f, (dy - sz) * 8.0f, sz * 2.0f * 8.0f, sz * 2.0f * 8.0f);
        for (Unit unit : this.units) {
            float rx = (unit.x - this.rect.x) / this.rect.width * w;
            float ry = (unit.y - this.rect.y) / this.rect.width * h;
            Draw.color(unit.getTeam().color);
            Fill.rect(x + rx, y + ry, Scl.scl(8.0f), Scl.scl(8.0f));
        }
        Draw.color();
    }

    public TextureRegion getRegion() {
        if (this.texture == null) {
            return null;
        }
        float sz = Mathf.clamp(16.0f * this.zoom, 16.0f, (float)Math.min(Vars.world.width(), Vars.world.height()));
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        float invTexWidth = 1.0f / (float)this.texture.getWidth();
        float invTexHeight = 1.0f / (float)this.texture.getHeight();
        float x = dx - sz;
        float y = (float)Vars.world.height() - dy - sz;
        float width = sz * 2.0f;
        float height = sz * 2.0f;
        this.region.set(x * invTexWidth, y * invTexHeight, (x + width) * invTexWidth, (y + height) * invTexHeight);
        return this.region;
    }

    public void updateAll() {
        for (int x = 0; x < Vars.world.width(); ++x) {
            for (int y = 0; y < Vars.world.height(); ++y) {
                this.pixmap.drawPixel(x, this.pixmap.getHeight() - 1 - y, this.colorFor(Vars.world.tile(x, y)));
            }
        }
        this.texture.draw(this.pixmap, 0, 0);
    }

    public void update(Tile tile) {
        int color = this.colorFor(Vars.world.tile(tile.x, tile.y));
        this.pixmap.drawPixel(tile.x, this.pixmap.getHeight() - 1 - tile.y, color);
        Pixmaps.drawPixel(this.texture, tile.x, this.pixmap.getHeight() - 1 - tile.y, color);
    }

    public void updateUnitArray() {
        float sz = 16.0f * this.zoom;
        float dx = Core.camera.position.x / 8.0f;
        float dy = Core.camera.position.y / 8.0f;
        dx = Mathf.clamp(dx, sz, (float)Vars.world.width() - sz);
        dy = Mathf.clamp(dy, sz, (float)Vars.world.height() - sz);
        this.units.clear();
        Units.nearby((dx - sz) * 8.0f, (dy - sz) * 8.0f, sz * 2.0f * 8.0f, sz * 2.0f * 8.0f, this.units::add);
    }

    private int colorFor(Tile tile) {
        if (tile == null) {
            return 0;
        }
        tile = tile.link();
        return Tmp.c1.set(MapIO.colorFor(tile.floor(), tile.block(), tile.overlay(), tile.getTeam())).mul(tile.block().cacheLayer == CacheLayer.walls ? 1.0f - (float)tile.rotation() / 4.0f : 1.0f).rgba();
    }

    @Override
    public void dispose() {
        if (this.pixmap != null && this.texture != null) {
            this.pixmap.dispose();
            this.texture.dispose();
            this.texture = null;
            this.pixmap = null;
        }
    }
}

