/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.graphics;

import io.anuke.arc.Core;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.world.Tile;
import java.util.Iterator;

public class OverlayRenderer {
    private static final float indicatorLength = 14.0f;
    private static final float spawnerMargin = 88.0f;
    private static final Rectangle rect = new Rectangle();
    private float buildFadeTime;

    public void drawBottom() {
        InputHandler input = Vars.control.input;
        if (!input.isDrawing() || Vars.player.isDead()) {
            return;
        }
        input.drawOutlined();
    }

    public void drawTop() {
        if (Core.settings.getBool("indicators")) {
            for (Player player : Vars.playerGroup.all()) {
                if (Vars.player == player || Vars.player.getTeam() != player.getTeam() || rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(player.x, player.y)) continue;
                Tmp.v1.set(player.x, player.y).sub(Core.camera.position.x, Core.camera.position.y).setLength(14.0f);
                Lines.stroke(2.0f, player.getTeam().color);
                Lines.lineAngle(Core.camera.position.x + Tmp.v1.x, Core.camera.position.y + Tmp.v1.y, Tmp.v1.angle(), 4.0f);
                Draw.reset();
            }
            Units.all(unit -> {
                if (unit != Vars.player && unit.getTeam() != Vars.player.getTeam() && !rect.setSize(Core.camera.width * 0.9f, Core.camera.height * 0.9f).setCenter(Core.camera.position.x, Core.camera.position.y).contains(unit.x, unit.y)) {
                    Tmp.v1.set(unit.x, unit.y).sub(Core.camera.position.x, Core.camera.position.y).setLength(14.0f);
                    Lines.stroke(1.0f, unit.getTeam().color);
                    Lines.lineAngle(Core.camera.position.x + Tmp.v1.x, Core.camera.position.y + Tmp.v1.y, Tmp.v1.angle(), 3.0f);
                    Draw.reset();
                }
            });
        }
        if (Vars.player.isDead()) {
            return;
        }
        InputHandler input = Vars.control.input;
        if (input.frag.config.isShown()) {
            Iterator<Tile> tile = input.frag.config.getSelectedTile();
            ((Tile)((Object)tile)).block().drawConfigure((Tile)((Object)tile));
        }
        input.drawTop();
        this.buildFadeTime = Mathf.lerpDelta(this.buildFadeTime, input.isPlacing() ? 1.0f : 0.0f, 0.06f);
        Draw.reset();
        Lines.stroke(this.buildFadeTime * 2.0f);
        if (this.buildFadeTime > 0.005f) {
            for (Team enemy : Vars.state.teams.enemiesOf(Vars.player.getTeam())) {
                for (Tile core : Vars.state.teams.get((Team)enemy).cores) {
                    float dst = Mathf.dst(Vars.player.x, Vars.player.y, core.drawx(), core.drawy());
                    if (!(dst < Vars.state.rules.enemyCoreBuildRadius * 1.5f)) continue;
                    Draw.color(Color.darkGray);
                    Lines.circle(core.drawx(), core.drawy() - 2.0f, Vars.state.rules.enemyCoreBuildRadius);
                    Draw.color(Pal.accent, enemy.color, 0.5f + Mathf.absin(Time.time(), 10.0f, 0.5f));
                    Lines.circle(core.drawx(), core.drawy(), Vars.state.rules.enemyCoreBuildRadius);
                }
            }
        }
        Lines.stroke(2.0f);
        Draw.color(Color.gray, Color.lightGray, Mathf.absin(Time.time(), 8.0f, 1.0f));
        for (Tile tile : Vars.spawner.getGroundSpawns()) {
            if (!tile.withinDst(Vars.player.x, Vars.player.y, Vars.state.rules.dropZoneRadius + 88.0f)) continue;
            Draw.alpha(Mathf.clamp(1.0f - (Vars.player.dst(tile) - Vars.state.rules.dropZoneRadius) / 88.0f));
            Lines.dashCircle(tile.worldx(), tile.worldy(), Vars.state.rules.dropZoneRadius);
        }
        Draw.reset();
        if (input.block == null && !Core.scene.hasMouse()) {
            Tile tile;
            Vector2 vec = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            tile = Vars.world.ltileWorld(vec.x, vec.y);
            if (tile != null && tile.block() != Blocks.air && tile.getTeam() == Vars.player.getTeam()) {
                tile.block().drawSelect(tile);
            }
        }
        if (input.isDroppingItem()) {
            Vector2 v = Core.input.mouseWorld(input.getMouseX(), input.getMouseY());
            float size = 8.0f;
            Draw.rect(Vars.player.item().item.icon(Item.Icon.large), v.x, v.y, size, size);
            Draw.color(Pal.accent);
            Lines.circle(v.x, v.y, 6.0f + Mathf.absin(Time.time(), 5.0f, 1.0f));
            Draw.reset();
            Tile tile = Vars.world.ltileWorld(v.x, v.y);
            if (tile != null && tile.interactable(Vars.player.getTeam()) && tile.block().acceptStack(Vars.player.item().item, Vars.player.item().amount, tile, Vars.player) > 0) {
                Lines.stroke(3.0f, Pal.gray);
                Lines.square(tile.drawx(), tile.drawy(), (float)(tile.block().size * 8) / 2.0f + 3.0f + Mathf.absin(Time.time(), 5.0f, 1.0f));
                Lines.stroke(1.0f, Pal.place);
                Lines.square(tile.drawx(), tile.drawy(), (float)(tile.block().size * 8) / 2.0f + 2.0f + Mathf.absin(Time.time(), 5.0f, 1.0f));
                Draw.reset();
            }
        }
    }
}

