/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.Graphics;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.scene.ui.TextField;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.input.PlaceMode;
import io.anuke.mindustry.input.PlaceUtils;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class DesktopInput
extends InputHandler {
    private Graphics.Cursor cursorType = Graphics.Cursor.SystemCursor.arrow;
    private int selectX;
    private int selectY;
    private PlaceMode mode;
    private float selectScale;
    private int prevX;
    private int prevY;
    private int prevRotation;

    void drawPlace(int x, int y, Block block, int rotation, int prevX, int prevY, int prevRotation) {
        if (this.validPlace(x, y, block, rotation)) {
            block.getPlaceDraw(this.placeDraw, rotation, prevX, prevY, prevRotation);
            Draw.color();
            Draw.mixcol(Pal.accent, 0.12f + Mathf.absin(Time.time(), 8.0f, 0.35f));
            Draw.rect(this.placeDraw.region, (float)(x * 8) + block.offset(), (float)(y * 8) + block.offset(), (float)this.placeDraw.region.getWidth() * this.selectScale * Draw.scl * (float)this.placeDraw.scalex, (float)this.placeDraw.region.getHeight() * this.selectScale * Draw.scl * (float)this.placeDraw.scaley, block.rotate ? (float)(this.placeDraw.rotation * 90) : 0.0f);
            Draw.color(Pal.accent);
            for (int i = 0; i < 4; ++i) {
                Point2 p = Geometry.d8edge[i];
                float offset = (float)(-Math.max(block.size - 1, 0)) / 2.0f * 8.0f;
                if (i % 2 != 0) continue;
                Draw.rect("block-select", (float)(x * 8) + block.offset() + offset * (float)p.x, (float)(y * 8) + block.offset() + offset * (float)p.y, (float)(i * 90));
            }
            Draw.color();
            Draw.mixcol();
        } else {
            Draw.color(Pal.removeBack);
            Lines.square((float)(x * 8) + block.offset(), (float)(y * 8) + block.offset() - 1.0f, (float)(block.size * 8) / 2.0f - 1.0f);
            Draw.color(Pal.remove);
            Lines.square((float)(x * 8) + block.offset(), (float)(y * 8) + block.offset(), (float)(block.size * 8) / 2.0f - 1.0f);
        }
    }

    @Override
    public boolean isDrawing() {
        return this.mode != PlaceMode.none || this.block != null;
    }

    @Override
    public void drawOutlined() {
        Lines.stroke(1.0f);
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (this.mode == PlaceMode.placing && this.block != null) {
            this.prevX = this.selectX;
            this.prevY = this.selectY;
            this.prevRotation = this.rotation;
            this.iterateLine(this.selectX, this.selectY, cursorX, cursorY, l -> {
                if (l.last && this.block.rotate) {
                    this.drawArrow(this.block, l.x, l.y, l.rotation);
                }
                this.drawPlace(l.x, l.y, this.block, l.rotation, this.prevX - l.x, this.prevY - l.y, this.prevRotation);
                this.prevX = l.x;
                this.prevY = l.y;
                this.prevRotation = l.rotation;
            });
        } else if (this.mode == PlaceMode.breaking) {
            PlaceUtils.NormalizeDrawResult result = PlaceUtils.normalizeDrawArea(Blocks.air, this.selectX, this.selectY, cursorX, cursorY, false, 100, 1.0f);
            PlaceUtils.NormalizeResult dresult = PlaceUtils.normalizeArea(this.selectX, this.selectY, cursorX, cursorY, this.rotation, false, 100);
            for (int x = dresult.x; x <= dresult.x2; ++x) {
                for (int y = dresult.y; y <= dresult.y2; ++y) {
                    Tile tile = Vars.world.ltile(x, y);
                    if (tile == null || !this.validBreak(tile.x, tile.y)) continue;
                    Draw.color(Pal.removeBack);
                    Lines.square(tile.drawx(), tile.drawy() - 1.0f, (float)(tile.block().size * 8) / 2.0f - 1.0f);
                    Draw.color(Pal.remove);
                    Lines.square(tile.drawx(), tile.drawy(), (float)(tile.block().size * 8) / 2.0f - 1.0f);
                }
            }
            Draw.color(Pal.removeBack);
            Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
            Draw.color(Pal.remove);
            Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
        } else if (this.isPlacing()) {
            if (this.block.rotate) {
                this.drawArrow(this.block, cursorX, cursorY, this.rotation);
            }
            this.drawPlace(cursorX, cursorY, this.block, this.rotation, cursorX, cursorY, this.rotation);
            this.block.drawPlace(cursorX, cursorY, this.rotation, this.validPlace(cursorX, cursorY, this.block, this.rotation));
        }
        Draw.reset();
    }

    @Override
    public void update() {
        if (Vars.net.active() && Core.input.keyTap(Binding.player_list)) {
            Vars.ui.listfrag.toggle();
        }
        if (Core.input.keyRelease(Binding.select)) {
            Vars.player.isShooting = false;
        }
        if (!(Vars.state.is(GameState.State.menu) || !Core.input.keyTap(Binding.minimap) || Core.scene.getKeyboardFocus() != Vars.ui.minimap && Core.scene.hasDialog() || Vars.ui.chatfrag.chatOpen() || Core.scene.getKeyboardFocus() instanceof TextField)) {
            if (!Vars.ui.minimap.isShown()) {
                Vars.ui.minimap.show();
            } else {
                Vars.ui.minimap.hide();
            }
        }
        if (Vars.state.is(GameState.State.menu) || Core.scene.hasDialog()) {
            return;
        }
        if (Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f && Core.input.keyDown(Binding.zoom_hold)) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (Vars.player.isDead()) {
            this.cursorType = Graphics.Cursor.SystemCursor.arrow;
            return;
        }
        this.pollInput();
        if (!this.isPlacing() && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (Vars.player.isShooting && !this.canShoot()) {
            Vars.player.isShooting = false;
        }
        if (this.isPlacing()) {
            this.cursorType = Graphics.Cursor.SystemCursor.hand;
            this.selectScale = Mathf.lerpDelta(this.selectScale, 1.0f, 0.2f);
        } else {
            this.selectScale = 0.0f;
        }
        this.rotation = Mathf.mod(this.rotation + (int)Core.input.axisTap(Binding.rotate), 4);
        Tile cursor = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        if (cursor != null) {
            cursor = cursor.link();
            this.cursorType = cursor.block().getCursor(cursor);
            if (this.isPlacing()) {
                this.cursorType = Graphics.Cursor.SystemCursor.hand;
            }
            if (!this.isPlacing() && this.canMine(cursor)) {
                this.cursorType = Vars.ui.drillCursor;
            }
            if (this.canTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y)) {
                this.cursorType = Vars.ui.unloadCursor;
            }
        }
        if (!Core.scene.hasMouse()) {
            Core.graphics.cursor(this.cursorType);
        }
        this.cursorType = Graphics.Cursor.SystemCursor.arrow;
    }

    void pollInput() {
        Tile selected = this.tileAt(Core.input.mouseX(), Core.input.mouseY());
        int cursorX = this.tileX(Core.input.mouseX());
        int cursorY = this.tileY(Core.input.mouseY());
        if (Core.input.keyTap(Binding.deselect)) {
            Vars.player.setMineTile(null);
        }
        if (Core.input.keyTap(Binding.select) && !Core.scene.hasMouse()) {
            if (this.isPlacing()) {
                this.selectX = cursorX;
                this.selectY = cursorY;
                this.mode = PlaceMode.placing;
            } else if (selected != null) {
                if (!(this.tileTapped(selected) || this.tryTapPlayer(Core.input.mouseWorld().x, Core.input.mouseWorld().y) || Vars.player.buildQueue().size != 0 || this.droppingItem || this.tryBeginMine(selected) || Vars.player.getMineTile() != null || Vars.ui.chatfrag.chatOpen())) {
                    Vars.player.isShooting = true;
                }
            } else if (!Vars.ui.chatfrag.chatOpen()) {
                Vars.player.isShooting = true;
            }
        } else if (!(!Core.input.keyTap(Binding.deselect) || this.block == null && this.mode == PlaceMode.none && !Vars.player.isBuilding() || Vars.player.buildRequest() != null && Vars.player.buildRequest().breaking && Core.keybinds.get(Binding.deselect) == Core.keybinds.get(Binding.break_block))) {
            if (this.block == null) {
                Vars.player.clearBuilding();
            }
            this.block = null;
            this.mode = PlaceMode.none;
        } else if (Core.input.keyTap(Binding.break_block) && !Core.scene.hasMouse()) {
            this.mode = PlaceMode.breaking;
            this.selectX = this.tileX(Core.input.mouseX());
            this.selectY = this.tileY(Core.input.mouseY());
        }
        if (this.mode == PlaceMode.placing && this.block != null) {
            if (!(this.overrideLineRotation || Core.input.keyDown(Binding.diagonal_placement) || this.selectX == cursorX && this.selectY == cursorY || (int)Core.input.axisTap(Binding.rotate) == 0)) {
                this.rotation = (int)((Angles.angle(this.selectX, this.selectY, cursorX, cursorY) + 45.0f) / 90.0f) % 4;
                this.overrideLineRotation = true;
            }
        } else {
            this.overrideLineRotation = false;
        }
        if (Core.input.keyRelease(Binding.break_block) || Core.input.keyRelease(Binding.select)) {
            if (this.mode == PlaceMode.placing && this.block != null) {
                this.iterateLine(this.selectX, this.selectY, cursorX, cursorY, l -> {
                    this.rotation = l.rotation;
                    this.tryPlaceBlock(l.x, l.y);
                });
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                PlaceUtils.NormalizeResult result = PlaceUtils.normalizeArea(this.selectX, this.selectY, cursorX, cursorY, this.rotation, false, 100);
                for (int x = 0; x <= Math.abs(result.x2 - result.x); ++x) {
                    for (int y = 0; y <= Math.abs(result.y2 - result.y); ++y) {
                        int wx = this.selectX + x * Mathf.sign(cursorX - this.selectX);
                        int wy = this.selectY + y * Mathf.sign(cursorY - this.selectY);
                        this.tryBreakBlock(wx, wy);
                    }
                }
            }
            if (selected != null) {
                this.tryDropItems(selected.link(), Core.input.mouseWorld().x, Core.input.mouseWorld().y);
            }
            this.mode = PlaceMode.none;
        }
    }

    @Override
    public boolean selectedBlock() {
        return this.isPlacing() && this.mode != PlaceMode.breaking;
    }

    @Override
    public float getMouseX() {
        return Core.input.mouseX();
    }

    @Override
    public float getMouseY() {
        return Core.input.mouseY();
    }

    @Override
    public void updateState() {
        if (Vars.state.is(GameState.State.menu)) {
            this.droppingItem = false;
            this.mode = PlaceMode.none;
            this.block = null;
        }
    }
}

