/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.input.InputProcessor;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.effect.ItemTransfer;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.PlaceUtils;
import io.anuke.mindustry.net.ValidateException;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.ui.fragments.OverlayFragment;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Build;
import io.anuke.mindustry.world.Tile;

public abstract class InputHandler
implements InputProcessor {
    static final float playerSelectRange = Vars.mobile ? 17.0f : 11.0f;
    static final int maxLength = 100;
    static final Vector2 stackTrns = new Vector2();
    static final float backTrns = 3.0f;
    public final OverlayFragment frag = new OverlayFragment();
    public Block block;
    public boolean overrideLineRotation;
    public int rotation;
    public boolean droppingItem;
    protected PlaceDraw placeDraw = new PlaceDraw();
    private PlaceLine line = new PlaceLine();

    public static void dropItem(Player player, float angle) {
        if (Vars.net.server() && player.item().amount <= 0) {
            throw new ValidateException(player, "Player cannot drop an item.");
        }
        Effects.effect(Fx.dropItem, Color.white, player.x, player.y, angle, player.item().item);
        player.clearItem();
    }

    public static void transferInventory(Player player, Tile tile) {
        if (player == null || player.timer == null || !player.timer.get(4, 40.0f)) {
            return;
        }
        if (Vars.net.server() && (player.item().amount <= 0 || player.isTransferring || !Units.canInteract(player, tile))) {
            throw new ValidateException(player, "Player cannot transfer an item.");
        }
        if (tile.entity == null) {
            return;
        }
        player.isTransferring = true;
        Item item = player.item().item;
        int amount = player.item().amount;
        int accepted = tile.block().acceptStack(item, amount, tile, player);
        player.item().amount -= accepted;
        int sent = Mathf.clamp(accepted / 4, 1, 8);
        int removed = accepted / sent;
        int[] remaining = new int[]{accepted, accepted};
        Block block = tile.block();
        Events.fire(new EventType.DepositEvent());
        for (int i = 0; i < sent; ++i) {
            boolean end = i == sent - 1;
            Time.run(i * 3, () -> {
                tile.block().getStackOffset(item, tile, stackTrns);
                ItemTransfer.create(item, player.x + Angles.trnsx(player.rotation + 180.0f, 3.0f), player.y + Angles.trnsy(player.rotation + 180.0f, 3.0f), new Vector2(tile.drawx() + InputHandler.stackTrns.x, tile.drawy() + InputHandler.stackTrns.y), () -> {
                    if (tile.block() != block || tile.entity == null || tile.entity.items == null) {
                        return;
                    }
                    tile.block().handleStack(item, removed, tile, player);
                    remaining[1] = remaining[1] - removed;
                    if (end && remaining[1] > 0) {
                        tile.block().handleStack(item, remaining[1], tile, player);
                    }
                });
                remaining[0] = remaining[0] - removed;
                if (end) {
                    player.isTransferring = false;
                }
            });
        }
    }

    public static void onTileTapped(Player player, Tile tile) {
        if (tile == null || player == null) {
            return;
        }
        if (!Units.canInteract(player, tile)) {
            return;
        }
        tile.block().tapped(tile, player);
    }

    public OverlayFragment getFrag() {
        return this.frag;
    }

    public void update() {
    }

    public float getMouseX() {
        return Core.input.mouseX();
    }

    public float getMouseY() {
        return Core.input.mouseY();
    }

    public void buildUI(Table table) {
    }

    public void updateState() {
    }

    public void drawOutlined() {
    }

    public void drawTop() {
    }

    public boolean isDrawing() {
        return false;
    }

    boolean tileTapped(Tile tile) {
        tile = tile.link();
        boolean consumed = false;
        boolean showedInventory = false;
        if (tile.block().configurable && tile.interactable(Vars.player.getTeam())) {
            consumed = true;
            if (!this.frag.config.isShown() && tile.block().shouldShowConfigure(tile, Vars.player) || this.frag.config.isShown() && this.frag.config.getSelectedTile().block().onConfigureTileTapped(this.frag.config.getSelectedTile(), tile)) {
                Sounds.click.at(tile);
                this.frag.config.showConfig(tile);
            }
        } else if (!this.frag.config.hasConfigMouse()) {
            if (this.frag.config.isShown() && this.frag.config.getSelectedTile().block().onConfigureTileTapped(this.frag.config.getSelectedTile(), tile)) {
                consumed = true;
                this.frag.config.hideConfig();
            }
            if (this.frag.config.isShown()) {
                consumed = true;
            }
        }
        if (!consumed && tile.interactable(Vars.player.getTeam())) {
            Call.onTileTapped(Vars.player, tile);
        }
        if (tile.interactable(Vars.player.getTeam()) && tile.block().consumesTap) {
            consumed = true;
        } else if (tile.interactable(Vars.player.getTeam()) && tile.block().synthetic() && !consumed && tile.block().hasItems && tile.entity.items.total() > 0) {
            this.frag.inv.showFor(tile);
            consumed = true;
            showedInventory = true;
        }
        if (!consumed && !Vars.mobile && Vars.player.isBuilding() && this.block == null) {
            Vars.player.clearBuilding();
            this.block = null;
            return true;
        }
        if (!showedInventory) {
            this.frag.inv.hide();
        }
        return consumed;
    }

    boolean tryTapPlayer(float x, float y) {
        if (this.canTapPlayer(x, y)) {
            this.droppingItem = true;
            return true;
        }
        return false;
    }

    boolean canTapPlayer(float x, float y) {
        return Mathf.dst(x, y, Vars.player.x, Vars.player.y) <= playerSelectRange && Vars.player.item().amount > 0;
    }

    boolean tryBeginMine(Tile tile) {
        if (this.canMine(tile)) {
            Vars.player.setMineTile(Vars.player.getMineTile() == tile ? null : tile);
            return true;
        }
        return false;
    }

    boolean canMine(Tile tile) {
        return !Core.scene.hasMouse() && tile.drop() != null && tile.drop().hardness <= Vars.player.mech.drillPower && (!tile.floor().playerUnmineable || tile.overlay().itemDrop != null) && Vars.player.acceptsItem(tile.drop()) && tile.block() == Blocks.air && Vars.player.dst(tile.worldx(), tile.worldy()) <= 70.0f;
    }

    Tile tileAt(float x, float y) {
        return Vars.world.tile(this.tileX(x), this.tileY(y));
    }

    int tileX(float cursorX) {
        Vector2 vec = Core.input.mouseWorld(cursorX, 0.0f);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset(), this.block.offset());
        }
        return Vars.world.toTile(vec.x);
    }

    int tileY(float cursorY) {
        Vector2 vec = Core.input.mouseWorld(0.0f, cursorY);
        if (this.selectedBlock()) {
            vec.sub(this.block.offset(), this.block.offset());
        }
        return Vars.world.toTile(vec.y);
    }

    public boolean selectedBlock() {
        return this.isPlacing();
    }

    public boolean isPlacing() {
        return this.block != null;
    }

    public float mouseAngle(float x, float y) {
        return Core.input.mouseWorld(this.getMouseX(), this.getMouseY()).sub(x, y).angle();
    }

    public void remove() {
        Table table;
        Core.input.removeProcessor(this);
        this.frag.remove();
        if (Core.scene != null && (table = (Table)Core.scene.find("inputTable")) != null) {
            table.clear();
        }
    }

    public void add() {
        Table table;
        Core.input.addProcessor(this);
        if (Core.scene != null && (table = (Table)Core.scene.find("inputTable")) != null) {
            table.clear();
            this.buildUI(table);
        }
    }

    public boolean canShoot() {
        return this.block == null && !Core.scene.hasMouse() && !this.onConfigurable() && !this.isDroppingItem();
    }

    public boolean onConfigurable() {
        return false;
    }

    public boolean isDroppingItem() {
        return this.droppingItem;
    }

    public void tryDropItems(Tile tile, float x, float y) {
        if (!this.droppingItem || Vars.player.item().amount <= 0 || this.canTapPlayer(x, y) || Vars.state.isPaused() || !Vars.player.timer.check(4, 40.0f)) {
            this.droppingItem = false;
            return;
        }
        this.droppingItem = false;
        ItemStack stack = Vars.player.item();
        if (tile.block().acceptStack(stack.item, stack.amount, tile, Vars.player) > 0 && tile.interactable(Vars.player.getTeam()) && tile.block().hasItems && Vars.player.item().amount > 0 && !Vars.player.isTransferring && tile.interactable(Vars.player.getTeam())) {
            Call.transferInventory(Vars.player, tile);
        } else {
            Call.dropItem(Vars.player.angleTo(x, y));
        }
    }

    public void tryPlaceBlock(int x, int y) {
        if (this.block != null && this.validPlace(x, y, this.block, this.rotation)) {
            this.placeBlock(x, y, this.block, this.rotation);
        }
    }

    public void tryBreakBlock(int x, int y) {
        if (this.validBreak(x, y)) {
            this.breakBlock(x, y);
        }
    }

    public boolean validPlace(int x, int y, Block type, int rotation) {
        return Build.validPlace(Vars.player.getTeam(), x, y, type, rotation);
    }

    public boolean validBreak(int x, int y) {
        return Build.validBreak(Vars.player.getTeam(), x, y);
    }

    public void placeBlock(int x, int y, Block block, int rotation) {
        Vars.player.addBuildRequest(new BuilderTrait.BuildRequest(x, y, rotation, block));
    }

    public void breakBlock(int x, int y) {
        Tile tile = Vars.world.ltile(x, y);
        Vars.player.addBuildRequest(new BuilderTrait.BuildRequest(tile.x, tile.y));
    }

    void drawArrow(Block block, int x, int y, int rotation) {
        Draw.color(!this.validPlace(x, y, block, rotation) ? Pal.removeBack : Pal.accentBack);
        Draw.rect(Core.atlas.find("place-arrow"), (float)(x * 8) + block.offset(), (float)(y * 8) + block.offset() - 1.0f, (float)Core.atlas.find("place-arrow").getWidth() * Draw.scl, (float)Core.atlas.find("place-arrow").getHeight() * Draw.scl, (float)(rotation * 90 - 90));
        Draw.color(!this.validPlace(x, y, block, rotation) ? Pal.remove : Pal.accent);
        Draw.rect(Core.atlas.find("place-arrow"), (float)(x * 8) + block.offset(), (float)(y * 8) + block.offset(), (float)Core.atlas.find("place-arrow").getWidth() * Draw.scl, (float)Core.atlas.find("place-arrow").getHeight() * Draw.scl, (float)(rotation * 90 - 90));
    }

    void iterateLine(int startX, int startY, int endX, int endY, Consumer<PlaceLine> cons) {
        boolean diagonal = Core.input.keyDown(Binding.diagonal_placement);
        if (Core.settings.getBool("swapdiagonal")) {
            diagonal = !diagonal;
        }
        Array<Point2> points = diagonal ? PlaceUtils.normalizeDiagonal(startX, startY, endX, endY) : PlaceUtils.normalizeLine(startX, startY, endX, endY);
        float angle = Angles.angle(startX, startY, endX, endY);
        int baseRotation = this.rotation;
        if (!this.overrideLineRotation || diagonal) {
            baseRotation = startX == endX && startY == endY ? this.rotation : (int)((angle + 45.0f) / 90.0f) % 4;
        }
        Tmp.r3.set(-1.0f, -1.0f, 0.0f, 0.0f);
        for (int i = 0; i < points.size; ++i) {
            Point2 point = points.get(i);
            if (this.block != null && Tmp.r2.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset(), (float)(point.y * 8) + this.block.offset()).overlaps(Tmp.r3)) continue;
            Point2 next = i == points.size - 1 ? null : points.get(i + 1);
            this.line.x = point.x;
            this.line.y = point.y;
            this.line.rotation = !this.overrideLineRotation || diagonal ? (next != null ? (int)Tile.relativeTo(point.x, point.y, next.x, next.y) : baseRotation) : this.rotation;
            this.line.last = next == null;
            cons.accept(this.line);
            Tmp.r3.setSize(this.block.size * 8).setCenter((float)(point.x * 8) + this.block.offset(), (float)(point.y * 8) + this.block.offset());
        }
    }

    class PlaceLine {
        public int x;
        public int y;
        public int rotation;
        public boolean last;

        PlaceLine() {
        }
    }

    public static class PlaceDraw {
        public int rotation;
        public int scalex;
        public int scaley;
        public TextureRegion region;
        public static final PlaceDraw instance = new PlaceDraw();
    }
}

