/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureAtlas;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.input.GestureDetector;
import io.anuke.arc.input.KeyCode;
import io.anuke.arc.math.Interpolation;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.math.geom.Rectangle;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.style.Drawable;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.core.GameState;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.Units;
import io.anuke.mindustry.entities.traits.BuilderTrait;
import io.anuke.mindustry.entities.traits.TargetTrait;
import io.anuke.mindustry.entities.type.TileEntity;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.gen.Icon;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.input.Binding;
import io.anuke.mindustry.input.InputHandler;
import io.anuke.mindustry.input.PlaceMode;
import io.anuke.mindustry.input.PlaceUtils;
import io.anuke.mindustry.ui.Styles;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;

public class MobileInput
extends InputHandler
implements GestureDetector.GestureListener {
    private static final float maxPanSpeed = 1.3f;
    private static Rectangle r1 = new Rectangle();
    private static Rectangle r2 = new Rectangle();
    private final float edgePan = Scl.scl(60.0f);
    private Vector2 vector = new Vector2();
    private float lastZoom = -1.0f;
    private GestureDetector detector;
    private int lineStartX;
    private int lineStartY;
    private float lineScale;
    private float crosshairScale;
    private TargetTrait lastTarget;
    private float shiftDeltaX;
    private float shiftDeltaY;
    private Array<PlaceRequest> selection = new Array();
    private Array<PlaceRequest> removals = new Array();
    private boolean selecting;
    private boolean lineMode;
    private PlaceMode mode = PlaceMode.none;
    private Block lastBlock;
    private PlaceRequest lastPlaced;
    private int prevX;
    private int prevY;
    private int prevRotation;

    void checkTargets(float x, float y) {
        Unit unit = Units.closestEnemy(Vars.player.getTeam(), x, y, 20.0f, u -> !u.isDead());
        if (unit != null) {
            Vars.player.setMineTile(null);
            Vars.player.target = unit;
        } else {
            Tile tile = Vars.world.ltileWorld(x, y);
            if (tile != null && tile.synthetic() && Vars.state.teams.areEnemies(Vars.player.getTeam(), tile.getTeam())) {
                TileEntity entity = tile.entity;
                Vars.player.setMineTile(null);
                Vars.player.target = entity;
            } else if (tile != null && Vars.player.mech.canHeal && tile.entity != null && tile.getTeam() == Vars.player.getTeam() && tile.entity.damaged()) {
                Vars.player.setMineTile(null);
                Vars.player.target = tile.entity;
            }
        }
    }

    boolean hasRequest(Tile tile) {
        return this.getRequest(tile) != null;
    }

    boolean checkOverlapPlacement(int x, int y, Block block) {
        Tile other;
        r2.setSize(block.size * 8);
        r2.setCenter((float)(x * 8) + block.offset(), (float)(y * 8) + block.offset());
        for (PlaceRequest placeRequest : this.selection) {
            other = placeRequest.tile();
            if (other == null || placeRequest.remove) continue;
            r1.setSize(placeRequest.block.size * 8);
            r1.setCenter(other.worldx() + placeRequest.block.offset(), other.worldy() + placeRequest.block.offset());
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        for (BuilderTrait.BuildRequest buildRequest : Vars.player.buildQueue()) {
            other = Vars.world.tile(buildRequest.x, buildRequest.y);
            if (other == null || buildRequest.breaking) continue;
            r1.setSize(buildRequest.block.size * 8);
            r1.setCenter(other.worldx() + buildRequest.block.offset(), other.worldy() + buildRequest.block.offset());
            if (!r2.overlaps(r1)) continue;
            return true;
        }
        return false;
    }

    PlaceRequest getRequest(Tile tile) {
        r2.setSize(8.0f);
        r2.setCenter(tile.worldx(), tile.worldy());
        for (PlaceRequest req : this.selection) {
            Tile other = req.tile();
            if (other == null) continue;
            if (!req.remove) {
                r1.setSize(req.block.size * 8);
                r1.setCenter(other.worldx() + req.block.offset(), other.worldy() + req.block.offset());
                if (!r2.overlaps(r1)) continue;
                return req;
            }
            r1.setSize(other.block().size * 8);
            r1.setCenter(other.worldx() + other.block().offset(), other.worldy() + other.block().offset());
            if (!r2.overlaps(r1)) continue;
            return req;
        }
        return null;
    }

    void removeRequest(PlaceRequest request) {
        this.selection.removeValue(request, true);
        this.removals.add(request);
    }

    boolean isLinePlacing() {
        return this.mode == PlaceMode.placing && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 24.0f;
    }

    boolean isAreaBreaking() {
        return this.mode == PlaceMode.breaking && this.lineMode && Mathf.dst(this.lineStartX * 8, this.lineStartY * 8, Core.input.mouseWorld().x, Core.input.mouseWorld().y) >= 16.0f;
    }

    void drawRequest(PlaceRequest request, PlaceRequest prev) {
        Tile tile = request.tile();
        if (!request.remove) {
            if (prev != null) {
                request.block.getPlaceDraw(this.placeDraw, request.rotation, prev.x - request.x, prev.y - request.y, prev.rotation);
            } else {
                request.block.getPlaceDraw(this.placeDraw, request.rotation, 0, 0, request.rotation);
            }
            float offset = request.block.offset();
            TextureRegion region = this.placeDraw.region;
            Draw.mixcol(Pal.accent, Mathf.clamp((1.0f - request.scale) / 0.5f + 0.12f + Mathf.absin(Time.time(), 8.0f, 0.35f)));
            Draw.tint(Color.white, Pal.breakInvalid, request.redness);
            Draw.rect(region, tile.worldx() + offset, tile.worldy() + offset, (float)region.getWidth() * request.scale * Draw.scl * (float)this.placeDraw.scalex, (float)region.getHeight() * request.scale * Draw.scl * (float)this.placeDraw.scaley, request.block.rotate ? (float)(this.placeDraw.rotation * 90) : 0.0f);
            Draw.mixcol(Pal.accent, 1.0f);
            for (int i = 0; i < 4; ++i) {
                Point2 p = Geometry.d8edge[i];
                float poffset = (float)(-Math.max(request.block.size - 1, 0)) / 2.0f * 8.0f;
                TextureAtlas.AtlasRegion find = Core.atlas.find("block-select");
                if (i % 2 != 0) continue;
                Draw.rect("block-select", (float)(request.tile().x * 8) + request.block.offset() + poffset * (float)p.x, (float)(request.tile().y * 8) + request.block.offset() + poffset * (float)p.y, (float)find.getWidth() * Draw.scl * request.scale, (float)find.getHeight() * Draw.scl * request.scale, (float)(i * 90));
            }
            Draw.color();
        } else {
            float rad = Math.max(((float)(tile.block().size * 8) / 2.0f - 1.0f) * request.scale, 1.0f);
            if (rad <= 1.01f) {
                return;
            }
            Draw.mixcol();
            Draw.tint(Pal.removeBack);
            Lines.square(tile.drawx(), tile.drawy() - 1.0f, rad);
            Draw.tint(Pal.remove);
            Lines.square(tile.drawx(), tile.drawy(), rad);
        }
    }

    void drawPlace(int x, int y, Block block, int rotation, int prevX, int prevY, int prevRotation) {
        if (this.validPlace(x, y, block, rotation) && !this.checkOverlapPlacement(x, y, block)) {
            block.getPlaceDraw(this.placeDraw, rotation, prevX, prevY, prevRotation);
            Draw.color();
            Draw.rect(this.placeDraw.region, (float)(x * 8) + block.offset(), (float)(y * 8) + block.offset(), (float)this.placeDraw.region.getWidth() * Draw.scl * (float)this.placeDraw.scalex, (float)this.placeDraw.region.getHeight() * Draw.scl * (float)this.placeDraw.scaley, block.rotate ? (float)(this.placeDraw.rotation * 90) : 0.0f);
            Draw.color(Pal.accent);
            for (int i = 0; i < 4; ++i) {
                Point2 p = Geometry.d8edge[i];
                float offset = (float)(-Math.max(block.size - 1, 0)) / 2.0f * 8.0f;
                if (i % 2 != 0) continue;
                Draw.rect("block-select", (float)(x * 8) + block.offset() + offset * (float)p.x, (float)(y * 8) + block.offset() + offset * (float)p.y, (float)(i * 90));
            }
            Draw.color();
        } else {
            Draw.color(Pal.removeBack);
            Lines.square((float)(x * 8) + block.offset(), (float)(y * 8) + block.offset() - 1.0f, (float)(block.size * 8) / 2.0f - 1.0f);
            Draw.color(Pal.remove);
            Lines.square((float)(x * 8) + block.offset(), (float)(y * 8) + block.offset(), (float)(block.size * 8) / 2.0f - 1.0f);
        }
    }

    @Override
    public void buildUI(Table table) {
        table.addImage().color(Pal.gray).height(4.0f).colspan(4).growX();
        table.row();
        table.left().margin(0.0f).defaults().size(48.0f);
        table.addImageButton((Drawable)Icon.breakSmall, Styles.clearTogglePartiali, () -> {
            this.mode = this.mode == PlaceMode.breaking ? (this.block == null ? PlaceMode.none : PlaceMode.placing) : PlaceMode.breaking;
            this.lastBlock = this.block;
        }).update(l -> l.setChecked(this.mode == PlaceMode.breaking)).name("breakmode");
        table.addImageButton((Drawable)Icon.diagonalSmall, Styles.clearTogglePartiali, () -> {
            Core.settings.put("swapdiagonal", !Core.settings.getBool("swapdiagonal"));
            Core.settings.save();
        }).update(l -> l.setChecked(Core.settings.getBool("swapdiagonal")));
        table.addImageButton((Drawable)Icon.arrowSmall, Styles.clearPartiali, () -> {
            this.rotation = Mathf.mod(this.rotation + 1, 4);
        }).update(i -> i.getImage().setRotationOrigin(this.rotation * 90, 1)).visible(() -> this.block != null && this.block.rotate);
        table.addImageButton((Drawable)Icon.checkSmall, Styles.clearPartiali, () -> {
            for (PlaceRequest request : this.selection) {
                Tile tile = request.tile();
                if (tile == null) continue;
                if (!request.remove) {
                    this.rotation = request.rotation;
                    Block before = this.block;
                    this.block = request.block;
                    this.tryPlaceBlock(tile.x, tile.y);
                    this.block = before;
                    continue;
                }
                this.tryBreakBlock(tile.x, tile.y);
            }
            this.removals.addAll(this.selection);
            this.selection.clear();
            this.selecting = false;
        }).visible(() -> !this.selection.isEmpty()).name("confirmplace");
        Core.scene.table(t -> {
            t.setName("cancelMobile");
            t.bottom().left().visible(() -> (Vars.player.isBuilding() || this.block != null || this.mode == PlaceMode.breaking) && !Vars.state.is(GameState.State.menu));
            t.addImageTextButton("$cancel", Icon.cancelSmall, () -> {
                Vars.player.clearBuilding();
                this.mode = PlaceMode.none;
                this.block = null;
            }).width(155.0f);
        });
    }

    @Override
    public boolean isDrawing() {
        return this.selection.size > 0 || this.removals.size > 0 || this.lineMode || Vars.player.target != null || this.mode != PlaceMode.none;
    }

    @Override
    public boolean isPlacing() {
        return super.isPlacing() && this.mode == PlaceMode.placing;
    }

    @Override
    public void drawOutlined() {
        TargetTrait targetTrait;
        Lines.stroke(1.0f);
        for (PlaceRequest placeRequest : this.removals) {
            Tile tile = placeRequest.tile();
            if (tile == null) continue;
            placeRequest.scale = Mathf.lerpDelta(placeRequest.scale, 0.0f, 0.2f);
            placeRequest.redness = Mathf.lerpDelta(placeRequest.redness, 0.0f, 0.2f);
            this.drawRequest(placeRequest, null);
        }
        PlaceRequest last = null;
        for (PlaceRequest request : this.selection) {
            Tile tile = request.tile();
            if (tile == null) continue;
            if (!request.remove && this.validPlace(tile.x, tile.y, request.block, request.rotation) || request.remove && this.validBreak(tile.x, tile.y)) {
                request.scale = Mathf.lerpDelta(request.scale, 1.0f, 0.2f);
                request.redness = Mathf.lerpDelta(request.redness, 0.0f, 0.2f);
            } else {
                request.scale = Mathf.lerpDelta(request.scale, 0.6f, 0.1f);
                request.redness = Mathf.lerpDelta(request.redness, 0.9f, 0.2f);
            }
            Tmp.c1.set(Draw.getMixColor());
            if (!request.remove && request == this.lastPlaced && request.block != null) {
                Draw.mixcol();
                if (request.block.rotate) {
                    this.drawArrow(request.block, tile.x, tile.y, request.rotation);
                }
            }
            Draw.mixcol(Tmp.c1, 1.0f);
            this.drawRequest(request, last);
            if (!request.remove && request == this.lastPlaced && request.block != null) {
                Draw.mixcol();
                request.block.drawPlace(tile.x, tile.y, this.rotation, this.validPlace(tile.x, tile.y, request.block, this.rotation));
            }
            last = request;
        }
        Draw.mixcol();
        Draw.color(Pal.accent);
        if (this.lineMode) {
            int n = this.tileX(Core.input.mouseX());
            int tileY = this.tileY(Core.input.mouseY());
            if (this.mode == PlaceMode.placing && this.block != null) {
                this.prevX = this.lineStartX;
                this.prevY = this.lineStartY;
                this.prevRotation = this.rotation;
                this.iterateLine(this.lineStartX, this.lineStartY, n, tileY, l -> {
                    if (l.last && this.block.rotate) {
                        this.drawArrow(this.block, l.x, l.y, l.rotation);
                    }
                    this.drawPlace(l.x, l.y, this.block, l.rotation, this.prevX - l.x, this.prevY - l.y, this.prevRotation);
                    this.rotation = l.rotation;
                    this.prevX = l.x;
                    this.prevY = l.y;
                    this.prevRotation = l.rotation;
                });
            } else if (this.mode == PlaceMode.breaking) {
                PlaceUtils.NormalizeDrawResult result = PlaceUtils.normalizeDrawArea(Blocks.air, this.lineStartX, this.lineStartY, n, tileY, false, 100, 1.0f);
                PlaceUtils.NormalizeResult dresult = PlaceUtils.normalizeArea(this.lineStartX, this.lineStartY, n, tileY, this.rotation, false, 100);
                for (int x = dresult.x; x <= dresult.x2; ++x) {
                    for (int y = dresult.y; y <= dresult.y2; ++y) {
                        Tile other = Vars.world.ltile(x, y);
                        if (other == null || !this.validBreak(other.x, other.y)) continue;
                        Draw.color(Pal.removeBack);
                        Lines.square(other.drawx(), other.drawy() - 1.0f, (float)(other.block().size * 8) / 2.0f - 1.0f);
                        Draw.color(Pal.remove);
                        Lines.square(other.drawx(), other.drawy(), (float)(other.block().size * 8) / 2.0f - 1.0f);
                    }
                }
                Draw.color(Pal.removeBack);
                Lines.rect(result.x, result.y - 1.0f, result.x2 - result.x, result.y2 - result.y);
                Draw.color(Pal.remove);
                Lines.rect(result.x, result.y, result.x2 - result.x, result.y2 - result.y);
            }
        }
        if ((targetTrait = Vars.player.target) != null && !Vars.state.isEditor()) {
            if (targetTrait != this.lastTarget) {
                this.crosshairScale = 0.0f;
                this.lastTarget = targetTrait;
            }
            this.crosshairScale = Mathf.lerpDelta(this.crosshairScale, 1.0f, 0.2f);
            Draw.color(Pal.remove);
            Lines.stroke(1.0f);
            float radius = Interpolation.swingIn.apply(this.crosshairScale);
            Lines.poly(targetTrait.getX(), targetTrait.getY(), 4, 7.0f * radius, Time.time() * 1.5f);
            Lines.spikes(targetTrait.getX(), targetTrait.getY(), 3.0f * radius, 6.0f * radius, 4, Time.time() * 1.5f);
        }
        Draw.reset();
    }

    @Override
    public void add() {
        this.detector = new GestureDetector(20.0f, 0.5f, 0.4f, 0.15f, this);
        Core.input.addProcessor(this.detector);
        super.add();
    }

    @Override
    public void remove() {
        super.remove();
        if (this.detector != null) {
            Core.input.removeProcessor(this.detector);
        }
        if (Core.scene != null && Core.scene.find("cancelMobile") != null) {
            Core.scene.find("cancelMobile").remove();
        }
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, KeyCode button) {
        if (Vars.state.is(GameState.State.menu) || Vars.player.isDead()) {
            return false;
        }
        Tile cursor = this.tileAt(screenX, screenY);
        float worldx = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x;
        float worldy = Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y;
        if (cursor == null || Core.scene.hasMouse(screenX, screenY)) {
            return false;
        }
        boolean bl = this.selecting = this.hasRequest(cursor) && this.isPlacing() && this.mode == PlaceMode.placing;
        if (pointer == 0 && !this.selecting && !this.tryTapPlayer(worldx, worldy) && Core.settings.getBool("keyboard")) {
            Vars.player.isShooting = true;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, KeyCode button) {
        this.lastZoom = Vars.renderer.getScale();
        if (this.lineMode) {
            int tileX = this.tileX(screenX);
            int tileY = this.tileY(screenY);
            if (this.mode == PlaceMode.placing && this.isPlacing()) {
                this.iterateLine(this.lineStartX, this.lineStartY, tileX, tileY, l -> {
                    Tile tile = Vars.world.tile(l.x, l.y);
                    if (tile != null && this.checkOverlapPlacement(tile.x, tile.y, this.block)) {
                        return;
                    }
                    PlaceRequest request = new PlaceRequest(l.x, l.y, this.block, l.rotation);
                    request.scale = 1.0f;
                    this.selection.add(request);
                });
                Events.fire(new EventType.LineConfirmEvent());
            } else if (this.mode == PlaceMode.breaking) {
                PlaceUtils.NormalizeResult result = PlaceUtils.normalizeArea(this.lineStartX, this.lineStartY, tileX, tileY, this.rotation, false, 100);
                for (int x = 0; x <= Math.abs(result.x2 - result.x); ++x) {
                    for (int y = 0; y <= Math.abs(result.y2 - result.y); ++y) {
                        int wy;
                        int wx = this.lineStartX + x * Mathf.sign(tileX - this.lineStartX);
                        Tile tar = Vars.world.ltile(wx, wy = this.lineStartY + y * Mathf.sign(tileY - this.lineStartY));
                        if (tar == null || this.hasRequest(Vars.world.tile(tar.x, tar.y)) || !this.validBreak(tar.x, tar.y)) continue;
                        PlaceRequest request = new PlaceRequest(tar.x, tar.y);
                        request.scale = 1.0f;
                        this.selection.add(request);
                    }
                }
            }
            this.lineMode = false;
        } else {
            Tile tile = this.tileAt(screenX, screenY);
            if (tile == null) {
                return false;
            }
            this.tryDropItems(tile.link(), Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).x, Core.input.mouseWorld((float)((float)screenX), (float)((float)screenY)).y);
        }
        return false;
    }

    @Override
    public boolean longPress(float x, float y) {
        if (Vars.state.is(GameState.State.menu) || this.mode == PlaceMode.none || Vars.player.isDead()) {
            return false;
        }
        Tile cursor = this.tileAt(x, y);
        if (cursor == null || Core.scene.hasMouse(x, y)) {
            return false;
        }
        this.lineStartX = cursor.x;
        this.lineStartY = cursor.y;
        this.lineMode = true;
        if (this.mode == PlaceMode.breaking) {
            Effects.effect(Fx.tapBlock, cursor.worldx(), cursor.worldy(), 1.0f);
        } else if (this.block != null) {
            Effects.effect(Fx.tapBlock, cursor.worldx() + this.block.offset(), cursor.worldy() + this.block.offset(), (float)this.block.size);
        }
        return false;
    }

    @Override
    public boolean tap(float x, float y, int count, KeyCode button) {
        if (Vars.state.is(GameState.State.menu) || this.lineMode) {
            return false;
        }
        float worldx = Core.input.mouseWorld((float)x, (float)y).x;
        float worldy = Core.input.mouseWorld((float)x, (float)y).y;
        Tile cursor = this.tileAt(x, y);
        if (cursor == null || Core.scene.hasMouse(x, y)) {
            return false;
        }
        this.checkTargets(worldx, worldy);
        if (this.hasRequest(cursor)) {
            this.removeRequest(this.getRequest(cursor));
        } else if (this.mode == PlaceMode.placing && this.isPlacing() && this.validPlace(cursor.x, cursor.y, this.block, this.rotation) && !this.checkOverlapPlacement(cursor.x, cursor.y, this.block)) {
            this.lastPlaced = new PlaceRequest(cursor.x, cursor.y, this.block, this.rotation);
            this.selection.add(this.lastPlaced);
        } else if (this.mode == PlaceMode.breaking && this.validBreak(cursor.link().x, cursor.link().y) && !this.hasRequest(cursor.link())) {
            cursor = cursor.link();
            this.selection.add(new PlaceRequest(cursor.x, cursor.y));
        } else if (!this.canTapPlayer(worldx, worldy) && !this.tileTapped(cursor.link())) {
            this.tryBeginMine(cursor);
        }
        return false;
    }

    @Override
    public void update() {
        if (Vars.state.is(GameState.State.menu) || Vars.player.isDead()) {
            this.selection.clear();
            this.removals.clear();
            this.mode = PlaceMode.none;
        }
        if (Math.abs(Core.input.axisTap(Binding.zoom)) > 0.0f && Core.input.keyDown(Binding.zoom_hold)) {
            Vars.renderer.scaleCamera(Core.input.axisTap(Binding.zoom));
        }
        if (!Core.settings.getBool("keyboard")) {
            float camSpeed = 6.0f;
            Core.camera.position.add(Tmp.v1.setZero().add(Core.input.axis(Binding.move_x), Core.input.axis(Binding.move_y)).nor().scl(Time.delta() * camSpeed));
        }
        if (Core.settings.getBool("keyboard")) {
            if (Core.input.keyRelease(Binding.select)) {
                Vars.player.isShooting = false;
            }
            if (Vars.player.isShooting && !this.canShoot()) {
                Vars.player.isShooting = false;
            }
        }
        if (this.mode == PlaceMode.none) {
            this.selecting = false;
            this.lineMode = false;
            this.removals.addAll(this.selection);
            this.selection.clear();
        }
        if (this.lineMode && this.mode == PlaceMode.placing && this.block == null) {
            this.lineMode = false;
        }
        if (this.block != null && this.mode == PlaceMode.none) {
            this.mode = PlaceMode.placing;
        }
        if (this.block == null && this.mode == PlaceMode.placing) {
            this.mode = PlaceMode.none;
        }
        if (this.lastBlock != this.block && this.mode == PlaceMode.breaking && this.block != null) {
            this.mode = PlaceMode.placing;
            this.lastBlock = this.block;
        }
        if (this.lineMode) {
            this.lineScale = Mathf.lerpDelta(this.lineScale, 1.0f, 0.1f);
            if (Core.input.isTouched(0) && this.lineMode) {
                float screenX = Core.input.mouseX();
                float screenY = Core.input.mouseY();
                float panX = 0.0f;
                float panY = 0.0f;
                if (screenX <= this.edgePan) {
                    panX = -(this.edgePan - screenX);
                }
                if (screenX >= (float)Core.graphics.getWidth() - this.edgePan) {
                    panX = screenX - (float)Core.graphics.getWidth() + this.edgePan;
                }
                if (screenY <= this.edgePan) {
                    panY = -(this.edgePan - screenY);
                }
                if (screenY >= (float)Core.graphics.getHeight() - this.edgePan) {
                    panY = screenY - (float)Core.graphics.getHeight() + this.edgePan;
                }
                this.vector.set(panX, panY).scl(Core.camera.width / (float)Core.graphics.getWidth());
                this.vector.limit(1.3f);
                Core.camera.position.x += this.vector.x;
                Core.camera.position.y += this.vector.y;
            }
        } else {
            this.lineScale = 0.0f;
        }
        for (int i = this.removals.size - 1; i >= 0; --i) {
            PlaceRequest request = this.removals.get(i);
            if (!(request.scale <= 1.0E-4f)) continue;
            this.removals.remove(i);
            --i;
        }
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY) {
        if (Core.scene.hasDialog() || Core.settings.getBool("keyboard")) {
            return false;
        }
        float scale = Core.camera.width / (float)Core.graphics.getWidth();
        deltaX *= scale;
        deltaY *= scale;
        if (this.lineMode && !Core.input.isTouched(1) || this.droppingItem) {
            return false;
        }
        if (this.selecting) {
            this.shiftDeltaX += deltaX;
            this.shiftDeltaY += deltaY;
            int shiftedX = (int)(this.shiftDeltaX / 8.0f);
            int shiftedY = (int)(this.shiftDeltaY / 8.0f);
            if (Math.abs(shiftedX) > 0 || Math.abs(shiftedY) > 0) {
                for (PlaceRequest req : this.selection) {
                    if (req.remove) continue;
                    req.x += shiftedX;
                    req.y += shiftedY;
                }
                this.shiftDeltaX %= 8.0f;
                this.shiftDeltaY %= 8.0f;
            }
        } else {
            Core.camera.position.x -= deltaX;
            Core.camera.position.y -= deltaY;
        }
        return false;
    }

    @Override
    public boolean panStop(float x, float y, int pointer, KeyCode button) {
        this.shiftDeltaY = 0.0f;
        this.shiftDeltaX = 0.0f;
        return false;
    }

    @Override
    public boolean zoom(float initialDistance, float distance) {
        if (Core.settings.getBool("keyboard")) {
            return false;
        }
        if (this.lastZoom < 0.0f) {
            this.lastZoom = Vars.renderer.getScale();
        }
        Vars.renderer.setScale(distance / initialDistance * this.lastZoom);
        return true;
    }

    private class PlaceRequest {
        int x;
        int y;
        Block block;
        int rotation;
        boolean remove;
        float scale;
        float redness;

        PlaceRequest(int x, int y, Block block, int rotation) {
            this.x = x;
            this.y = y;
            this.block = block;
            this.rotation = rotation;
            this.remove = false;
        }

        PlaceRequest(int x, int y) {
            this.x = x;
            this.y = y;
            this.remove = true;
        }

        Tile tile() {
            return Vars.world.tile(this.x, this.y);
        }
    }
}

