/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.input;

import io.anuke.arc.collection.Array;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Bresenham2;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.world.Block;

public class PlaceUtils {
    private static final NormalizeResult result = new NormalizeResult();
    private static final NormalizeDrawResult drawResult = new NormalizeDrawResult();
    private static Bresenham2 bres = new Bresenham2();
    private static Array<Point2> points = new Array();

    public static Array<Point2> normalizeDiagonal(int startX, int startY, int endX, int endY) {
        Pools.freeAll(points);
        points.clear();
        return bres.lineNoDiagonal(startX, startY, endX, endY, Pools.get(Point2.class, Point2::new), points);
    }

    public static Array<Point2> normalizeLine(int startX, int startY, int endX, int endY) {
        Pools.freeAll(points);
        points.clear();
        if (Math.abs(startX - endX) > Math.abs(startY - endY)) {
            for (int i = 0; i <= Math.abs(startX - endX); ++i) {
                points.add(Pools.obtain(Point2.class, Point2::new).set(startX + i * Mathf.sign(endX - startX), startY));
            }
        } else {
            for (int i = 0; i <= Math.abs(startY - endY); ++i) {
                points.add(Pools.obtain(Point2.class, Point2::new).set(startX, startY + i * Mathf.sign(endY - startY)));
            }
        }
        return points;
    }

    public static NormalizeDrawResult normalizeDrawArea(Block block, int startx, int starty, int endx, int endy, boolean snap, int maxLength, float scaling) {
        PlaceUtils.normalizeArea(startx, starty, endx, endy, 0, snap, maxLength);
        float offset = block.offset();
        PlaceUtils.drawResult.x = PlaceUtils.result.x * 8;
        PlaceUtils.drawResult.y = PlaceUtils.result.y * 8;
        PlaceUtils.drawResult.x2 = PlaceUtils.result.x2 * 8;
        PlaceUtils.drawResult.y2 = PlaceUtils.result.y2 * 8;
        PlaceUtils.drawResult.x -= (float)block.size * scaling * 8.0f / 2.0f;
        PlaceUtils.drawResult.x2 += (float)block.size * scaling * 8.0f / 2.0f;
        PlaceUtils.drawResult.y -= (float)block.size * scaling * 8.0f / 2.0f;
        PlaceUtils.drawResult.y2 += (float)block.size * scaling * 8.0f / 2.0f;
        PlaceUtils.drawResult.x += offset;
        PlaceUtils.drawResult.y += offset;
        PlaceUtils.drawResult.x2 += offset;
        PlaceUtils.drawResult.y2 += offset;
        return drawResult;
    }

    public static NormalizeResult normalizeArea(int tilex, int tiley, int endx, int endy, int rotation, boolean snap, int maxLength) {
        int t;
        if (snap) {
            if (Math.abs(tilex - endx) > Math.abs(tiley - endy)) {
                endy = tiley;
            } else {
                endx = tilex;
            }
            if (Math.abs(endx - tilex) > maxLength) {
                endx = Mathf.sign(endx - tilex) * maxLength + tilex;
            }
            if (Math.abs(endy - tiley) > maxLength) {
                endy = Mathf.sign(endy - tiley) * maxLength + tiley;
            }
        }
        int dx = endx - tilex;
        int dy = endy - tiley;
        if (Math.abs(dx) > Math.abs(dy)) {
            rotation = dx >= 0 ? 0 : 2;
        } else if (Math.abs(dx) < Math.abs(dy)) {
            rotation = dy >= 0 ? 1 : 3;
        }
        if (endx < tilex) {
            t = endx;
            endx = tilex;
            tilex = t;
        }
        if (endy < tiley) {
            t = endy;
            endy = tiley;
            tiley = t;
        }
        PlaceUtils.result.x2 = endx;
        PlaceUtils.result.y2 = endy;
        PlaceUtils.result.x = tilex;
        PlaceUtils.result.y = tiley;
        PlaceUtils.result.rotation = rotation;
        return result;
    }

    static class NormalizeResult {
        int x;
        int y;
        int x2;
        int y2;
        int rotation;

        NormalizeResult() {
        }

        boolean isX() {
            return Math.abs(this.x2 - this.x) > Math.abs(this.y2 - this.y);
        }

        int getLength() {
            return Math.max(this.x2 - this.x, this.y2 - this.y);
        }

        int getScaledX(int i) {
            return this.x + (this.x2 - this.x > this.y2 - this.y ? i : 0);
        }

        int getScaledY(int i) {
            return this.y + (this.x2 - this.x > this.y2 - this.y ? 0 : i);
        }
    }

    static class NormalizeDrawResult {
        float x;
        float y;
        float x2;
        float y2;

        NormalizeDrawResult() {
        }
    }
}

