/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.io;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntMap;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.util.Pack;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.serialization.Json;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.game.SpawnGroup;
import io.anuke.mindustry.game.Team;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.CachedTile;
import io.anuke.mindustry.world.LegacyColorMapper;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.BlockPart;
import io.anuke.mindustry.world.blocks.Floor;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class LegacyMapIO {
    private static final ObjectMap<String, String> fallback = ObjectMap.of("alpha-dart-mech-pad", "dart-mech-pad");
    private static final Json json = new Json();

    public static void convertMap(FileHandle in, FileHandle out) throws IOException {
        Map map = LegacyMapIO.readMap(in, true);
        String waves = map.tags.get("waves", "[]");
        Array<Object> groups = new Array<Object>((Object[])json.fromJson(SpawnGroup[].class, waves));
        Tile[][] tiles = Vars.world.createTiles(map.width, map.height);
        for (int x = 0; x < map.width; ++x) {
            for (int y = 0; y < map.height; ++y) {
                tiles[x][y] = new CachedTile();
                tiles[x][y].x = (short)x;
                tiles[x][y].y = (short)y;
            }
        }
        Vars.state.rules.spawns = groups;
        LegacyMapIO.readTiles(map, tiles);
        MapIO.writeMap(out, map);
    }

    public static Map readMap(FileHandle file, boolean custom) throws IOException {
        try (DataInputStream stream = new DataInputStream(file.read(1024));){
            StringMap tags = new StringMap();
            int version = stream.readInt();
            if (version != 1) {
                throw new IOException("Outdated legacy map format");
            }
            int build = stream.readInt();
            short width = stream.readShort();
            short height = stream.readShort();
            int tagAmount = stream.readByte();
            for (int i = 0; i < tagAmount; ++i) {
                String name = stream.readUTF();
                String value = stream.readUTF();
                tags.put(name, value);
            }
            Map map = new Map(file, width, height, tags, custom, version, build);
            return map;
        }
    }

    public static void readTiles(Map map, Tile[][] tiles) throws IOException {
        LegacyMapIO.readTiles(map, (x, y) -> tiles[x][y]);
    }

    public static void readTiles(Map map, MapIO.TileProvider tiles) throws IOException {
        LegacyMapIO.readTiles(map.file, map.width, map.height, tiles);
    }

    private static void readTiles(FileHandle file, int width, int height, Tile[][] tiles) throws IOException {
        LegacyMapIO.readTiles(file, width, height, (x, y) -> tiles[x][y]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readTiles(FileHandle file, int width, int height, MapIO.TileProvider tiles) throws IOException {
        try (BufferedInputStream input = file.read(8192);){
            DataInputStream stream = new DataInputStream(input);
            stream.readInt();
            stream.readInt();
            stream.readInt();
            int tagAmount = stream.readByte();
            for (int i = 0; i < tagAmount; ++i) {
                stream.readUTF();
                stream.readUTF();
            }
            stream = new DataInputStream(new InflaterInputStream(input));
            Throwable throwable = null;
            try {
                try {
                    int newy;
                    int newx;
                    int j;
                    int y;
                    int x;
                    int i;
                    int mapped = stream.readByte();
                    IntMap<Block> idmap = new IntMap<Block>();
                    IntMap<String> namemap = new IntMap<String>();
                    for (i = 0; i < mapped; ++i) {
                        byte type = stream.readByte();
                        int total = stream.readShort();
                        for (int j2 = 0; j2 < total; ++j2) {
                            String name = stream.readUTF();
                            if (type != 1) continue;
                            Block res = (Block)Vars.content.getByName(ContentType.block, fallback.get(name, name));
                            idmap.put(j2, res == null ? Blocks.air : res);
                            namemap.put(j2, fallback.get(name, name));
                        }
                    }
                    for (i = 0; i < width * height; ++i) {
                        x = i % width;
                        y = i / width;
                        int floorid = stream.readUnsignedByte();
                        int oreid = stream.readUnsignedByte();
                        int consecutives = stream.readUnsignedByte();
                        Tile tile = tiles.get(x, y);
                        tile.setFloor((Floor)idmap.get(floorid));
                        tile.setOverlay((Block)idmap.get(oreid));
                        for (j = i + 1; j < i + 1 + consecutives; ++j) {
                            newx = j % width;
                            newy = j / width;
                            Tile newTile = tiles.get(newx, newy);
                            newTile.setFloor((Floor)idmap.get(floorid));
                            newTile.setOverlay((Block)idmap.get(oreid));
                        }
                        i += consecutives;
                    }
                    for (i = 0; i < width * height; ++i) {
                        x = i % width;
                        y = i / width;
                        int id = stream.readUnsignedByte();
                        Block block = (Block)idmap.get(id);
                        if (block == null) {
                            block = Blocks.air;
                        }
                        Tile tile = tiles.get(x, y);
                        if (block != Blocks.spawn) {
                            tile.setBlock(block);
                        } else {
                            tile.setOverlay(block);
                        }
                        if (namemap.get(id, "").equals("part")) {
                            stream.readByte();
                            continue;
                        }
                        if (tile.entity != null) {
                            byte tr = stream.readByte();
                            stream.readShort();
                            byte team = Pack.leftByte(tr);
                            byte rotation = Pack.rightByte(tr);
                            tile.setTeam(Team.all[team]);
                            tile.entity.health = tile.block().health;
                            tile.rotation(rotation);
                            if (tile.block() != Blocks.liquidSource && tile.block() != Blocks.unloader && tile.block() != Blocks.sorter) continue;
                            stream.readByte();
                            continue;
                        }
                        int consecutives = stream.readUnsignedByte();
                        for (j = i + 1; j < i + 1 + consecutives; ++j) {
                            newx = j % width;
                            newy = j / width;
                            tiles.get(newx, newy).setBlock(block);
                        }
                        i += consecutives;
                    }
                }
                finally {
                    Vars.content.setTemporaryMapper(null);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
    }

    public static void readPixmap(Pixmap pixmap, Tile[][] tiles) {
        for (int x = 0; x < pixmap.getWidth(); ++x) {
            for (int y = 0; y < pixmap.getHeight(); ++y) {
                int color = pixmap.getPixel(x, pixmap.getHeight() - 1 - y);
                LegacyColorMapper.LegacyBlock block = LegacyColorMapper.get(color);
                Tile tile = tiles[x][y];
                tile.setFloor(block.floor);
                tile.setBlock(block.wall);
                if (block.ore != null) {
                    tile.setOverlay(block.ore);
                }
                if (color != Color.rgba8888(Color.green)) continue;
                for (int dx = 0; dx < 3; ++dx) {
                    for (int dy = 0; dy < 3; ++dy) {
                        int worldx = dx - 1 + x;
                        int worldy = dy - 1 + y;
                        if (!Structs.inBounds(worldx, worldy, pixmap.getWidth(), pixmap.getHeight())) continue;
                        Tile write = tiles[worldx][worldy];
                        write.setBlock(BlockPart.get(dx - 1, dy - 1));
                        write.setTeam(Team.sharded);
                    }
                }
                tile.setBlock(Blocks.coreShard);
                tile.setTeam(Team.sharded);
            }
        }
    }
}

