/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps;

import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.AssetManager;
import io.anuke.arc.assets.loaders.TextureLoader;
import io.anuke.arc.assets.loaders.resolvers.AbsoluteFileHandleResolver;
import io.anuke.arc.collection.Array;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.util.Log;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Content;
import io.anuke.mindustry.maps.Map;

public class MapPreviewLoader
extends TextureLoader {
    public MapPreviewLoader() {
        super(new AbsoluteFileHandleResolver());
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        try {
            super.loadAsync(manager, fileName, file.sibling(file.nameWithoutExtension()), parameter);
        }
        catch (Exception e) {
            Log.err(e);
            MapPreviewParameter param = (MapPreviewParameter)parameter;
            Vars.maps.queueNewPreview(param.map);
        }
    }

    @Override
    public Texture loadSync(AssetManager manager, String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        try {
            return super.loadSync(manager, fileName, file, parameter);
        }
        catch (Throwable e) {
            Log.err(e);
            try {
                return new Texture(file);
            }
            catch (Throwable e2) {
                Log.err(e2);
                return new Texture("sprites/error.png");
            }
        }
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, TextureLoader.TextureParameter parameter) {
        return Array.with(new AssetDescriptor<Content>("contentcreate", Content.class));
    }

    public static class MapPreviewParameter
    extends TextureLoader.TextureParameter {
        public Map map;

        public MapPreviewParameter(Map map) {
            this.map = map;
        }
    }
}

