/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.assets.AssetDescriptor;
import io.anuke.arc.assets.loaders.CustomLoader;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.IntSet;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.collection.ObjectSet;
import io.anuke.arc.collection.StringMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.ExceptionRunnable;
import io.anuke.arc.graphics.Pixmap;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.async.AsyncExecutor;
import io.anuke.arc.util.serialization.Json;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.game.Content;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.SpawnGroup;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.io.MapIO;
import io.anuke.mindustry.maps.Map;
import io.anuke.mindustry.maps.MapPreviewLoader;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.maps.filters.OreFilter;
import io.anuke.mindustry.maps.filters.ScatterFilter;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.storage.CoreBlock;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.StringWriter;

public class Maps {
    private static String[] defaultMapNames = new String[]{"maze", "fortress", "labyrinth", "islands", "tendrils", "caldera", "wasteland", "shattered", "fork", "triad", "veins", "glacier"};
    private Array<Map> maps = new Array();
    private Json json = new Json();
    private AsyncExecutor executor = new AsyncExecutor(2);
    private ObjectSet<Map> previewList = new ObjectSet();

    public Array<Map> all() {
        return this.maps;
    }

    public Array<Map> customMaps() {
        return this.maps.select(m -> m.custom);
    }

    public Array<Map> defaultMaps() {
        return this.maps.select(m -> !m.custom);
    }

    public Map byName(String name) {
        return this.maps.find(m -> m.name().equals(name));
    }

    public Maps() {
        Events.on(EventType.ClientLoadEvent.class, event -> this.maps.sort());
        if (Core.assets != null) {
            ((CustomLoader)Core.assets.getLoader(Content.class)).loaded = this::createAllPreviews;
        }
    }

    public Map loadInternalMap(String name) {
        FileHandle file = Core.files.internal("maps/" + name + "." + "msav");
        try {
            return MapIO.createMap(file, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void load() {
        try {
            for (String name : defaultMapNames) {
                FileHandle file = Core.files.internal("maps/" + name + "." + "msav");
                this.loadMap(file, false);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (FileHandle file : Vars.customMapDirectory.list()) {
            try {
                if (!file.extension().equalsIgnoreCase("msav")) continue;
                this.loadMap(file, true);
            }
            catch (Exception e) {
                Log.err("Failed to load custom map file '{0}'!", file);
                Log.err(e);
            }
        }
        for (FileHandle file : Vars.platform.getExternalMaps()) {
            try {
                Map map = this.loadMap(file, false);
                map.workshop = true;
                map.tags.put("steamid", file.parent().name());
            }
            catch (Exception e) {
                Log.err("Failed to load workshop map file '{0}'!", file);
                Log.err(e);
            }
        }
    }

    public void reload() {
        for (Map map : this.maps) {
            if (map.texture == null) continue;
            map.texture.dispose();
            map.texture = null;
        }
        this.maps.clear();
        this.load();
    }

    public Map saveMap(ObjectMap<String, String> baseTags) {
        try {
            FileHandle file;
            StringMap tags = new StringMap((ObjectMap<? extends String, ? extends String>)baseTags);
            String name = (String)tags.get("name");
            if (name == null) {
                throw new IllegalArgumentException("Can't save a map with no name. How did this happen?");
            }
            Map other = this.maps.find(m -> m.name().equals(name));
            if (other != null) {
                if (other.texture != null) {
                    other.texture.dispose();
                    other.texture = null;
                }
                this.maps.remove(other);
                file = other.file;
            } else {
                file = this.findFile();
            }
            Map map = new Map(file, Vars.world.width(), Vars.world.height(), tags, true);
            MapIO.writeMap(file, map);
            if (!Vars.headless) {
                map.teams.clear();
                map.spawns = 0;
                for (int x = 0; x < map.width; ++x) {
                    for (int y = 0; y < map.height; ++y) {
                        Tile tile = Vars.world.getTiles()[x][y];
                        if (tile.block() instanceof CoreBlock) {
                            map.teams.add(tile.getTeamID());
                        }
                        if (tile.overlay() != Blocks.spawn) continue;
                        ++map.spawns;
                    }
                }
                if (Core.assets.isLoaded(map.previewFile().path() + "." + "msav")) {
                    Core.assets.unload(map.previewFile().path() + "." + "msav");
                }
                Pixmap pix = MapIO.generatePreview(Vars.world.getTiles());
                this.executor.submit(() -> map.previewFile().writePNG(pix));
                this.writeCache(map);
                map.texture = new Texture(pix);
            }
            this.maps.add(map);
            this.maps.sort();
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void importMap(FileHandle file) throws IOException {
        FileHandle dest = this.findFile();
        file.copyTo(dest);
        Map map = this.loadMap(dest, true);
        Exception[] error = new Exception[]{null};
        this.createNewPreview(map, e -> {
            this.maps.remove(map);
            try {
                map.file.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            error[0] = e;
        });
        if (error[0] != null) {
            throw new IOException(error[0]);
        }
    }

    public void tryCatchMapError(ExceptionRunnable run) {
        try {
            run.run();
        }
        catch (Exception e) {
            Log.err(e);
            if ("Outdated legacy map format".equals(e.getMessage())) {
                Vars.ui.showErrorMessage("$editor.errornot");
            }
            if (e.getMessage() != null && e.getMessage().contains("Incorrect header!")) {
                Vars.ui.showErrorMessage("$editor.errorheader");
            }
            Vars.ui.showException("$editor.errorload", e);
        }
    }

    public void removeMap(Map map) {
        if (map.texture != null) {
            map.texture.dispose();
            map.texture = null;
        }
        this.maps.remove(map);
        map.file.delete();
    }

    public Array<GenerateFilter> readFilters(String str) {
        if (str == null || str.isEmpty()) {
            Array<GenerateFilter> filters = Array.with(new ScatterFilter(){
                {
                    this.flooronto = Blocks.stone;
                    this.block = Blocks.rock;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.shale;
                    this.block = Blocks.shaleBoulder;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.snow;
                    this.block = Blocks.snowrock;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.ice;
                    this.block = Blocks.snowrock;
                }
            }, new ScatterFilter(){
                {
                    this.flooronto = Blocks.sand;
                    this.block = Blocks.sandBoulder;
                }
            });
            this.addDefaultOres(filters);
            return filters;
        }
        try {
            return JsonIO.read(Array.class, str.replace("mindustrz", "mindustry"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.readFilters("");
        }
    }

    public void addDefaultOres(Array<GenerateFilter> filters) {
        int index = 0;
        for (Block block : new Block[]{Blocks.oreCopper, Blocks.oreLead, Blocks.oreCoal, Blocks.oreTitanium, Blocks.oreThorium}) {
            OreFilter filter = new OreFilter();
            filter.threshold += (float)index++ * 0.018f;
            filter.scl += (float)index / 2.1f;
            filter.ore = block;
            filters.add(filter);
        }
    }

    public String writeWaves(Array<SpawnGroup> groups) {
        if (groups == null) {
            return "[]";
        }
        StringWriter buffer = new StringWriter();
        this.json.setWriter(buffer);
        this.json.writeArrayStart();
        for (int i = 0; i < groups.size; ++i) {
            this.json.writeObjectStart(SpawnGroup.class, SpawnGroup.class);
            groups.get(i).write(this.json);
            this.json.writeObjectEnd();
        }
        this.json.writeArrayEnd();
        return buffer.toString();
    }

    public Array<SpawnGroup> readWaves(String str) {
        return str == null ? null : (str.equals("[]") ? new Array() : Array.with((Object[])this.json.fromJson(SpawnGroup[].class, str)));
    }

    public void loadPreviews() {
        for (Map map : this.maps) {
            if (map.previewFile().exists()) {
                Core.assets.load(new AssetDescriptor<Texture>((String)new StringBuilder().append((String)map.previewFile().path()).append((String)".").append((String)"msav").toString(), Texture.class, new MapPreviewLoader.MapPreviewParameter((Map)map))).loaded = t -> {
                    map.texture = (Texture)t;
                };
                try {
                    this.readCache(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.queueNewPreview(map);
                }
                continue;
            }
            this.queueNewPreview(map);
        }
    }

    private void createAllPreviews() {
        Core.app.post(() -> {
            for (Map map : this.previewList) {
                this.createNewPreview(map, e -> Core.app.post(() -> {
                    map.texture = (Texture)Core.assets.get("sprites/error.png");
                }));
            }
            this.previewList.clear();
        });
    }

    public void queueNewPreview(Map map) {
        Core.app.post(() -> this.previewList.add(map));
    }

    private void createNewPreview(Map map, Consumer<Exception> failed) {
        try {
            Pixmap pix = MapIO.generatePreview(map);
            map.texture = new Texture(pix);
            this.executor.submit(() -> {
                try {
                    map.previewFile().writePNG(pix);
                    this.writeCache(map);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            failed.accept(e);
            Log.err("Failed to generate preview!", e);
        }
    }

    private void writeCache(Map map) throws IOException {
        try (DataOutputStream stream = new DataOutputStream(map.cacheFile().write(false, 4096));){
            stream.write(0);
            stream.writeInt(map.spawns);
            stream.write(map.teams.size);
            IntSet.IntSetIterator iter = map.teams.iterator();
            while (iter.hasNext) {
                stream.write(iter.next());
            }
        }
    }

    private void readCache(Map map) throws IOException {
        try (DataInputStream stream = new DataInputStream(map.cacheFile().read(4096));){
            stream.read();
            map.spawns = stream.readInt();
            int teamsize = stream.readByte();
            for (int i = 0; i < teamsize; ++i) {
                map.teams.add(stream.read());
            }
        }
    }

    private FileHandle findFile() {
        int i = this.maps.size;
        while (Vars.customMapDirectory.child("map_" + i + "." + "msav").exists()) {
            ++i;
        }
        return Vars.customMapDirectory.child("map_" + i + "." + "msav");
    }

    private Map loadMap(FileHandle file, boolean custom) throws IOException {
        Map map = MapIO.createMap(file, custom);
        if (map.name() == null) {
            throw new IOException("Map name cannot be empty! File: " + file);
        }
        this.maps.add(map);
        this.maps.sort();
        return map;
    }
}

