/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.arc.Core;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.FloatConsumer;
import io.anuke.arc.function.FloatProvider;
import io.anuke.arc.function.Predicate;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.scene.style.TextureRegionDrawable;
import io.anuke.arc.scene.ui.Slider;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.ui.dialogs.FloatingDialog;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.blocks.Floor;
import io.anuke.mindustry.world.blocks.OverlayFloor;

public abstract class FilterOption {
    public static final Predicate<Block> floorsOnly = b -> b instanceof Floor && !(b instanceof OverlayFloor) && Core.atlas.isFound(b.icon(Block.Icon.full));
    public static final Predicate<Block> wallsOnly = b -> !b.synthetic() && !(b instanceof Floor) && Core.atlas.isFound(b.icon(Block.Icon.full));
    public static final Predicate<Block> floorsOptional = b -> b == Blocks.air || b instanceof Floor && !(b instanceof OverlayFloor) && Core.atlas.isFound(b.icon(Block.Icon.full));
    public static final Predicate<Block> wallsOptional = b -> b == Blocks.air || !b.synthetic() && !(b instanceof Floor) && Core.atlas.isFound(b.icon(Block.Icon.full));
    public static final Predicate<Block> wallsOresOptional = b -> b == Blocks.air || (!b.synthetic() && !(b instanceof Floor) || b instanceof OverlayFloor) && Core.atlas.isFound(b.icon(Block.Icon.full));
    public static final Predicate<Block> oresOnly = b -> b instanceof OverlayFloor && Core.atlas.isFound(b.icon(Block.Icon.full));
    public static final Predicate<Block> anyOptional = b -> floorsOnly.test((Block)b) || wallsOnly.test((Block)b) || oresOnly.test((Block)b) || b == Blocks.air;
    public Runnable changed = () -> {};

    public abstract void build(Table var1);

    static class BlockOption
    extends FilterOption {
        final String name;
        final Supplier<Block> supplier;
        final Consumer<Block> consumer;
        final Predicate<Block> filter;

        BlockOption(String name, Supplier<Block> supplier, Consumer<Block> consumer, Predicate<Block> filter) {
            this.name = name;
            this.supplier = supplier;
            this.consumer = consumer;
            this.filter = filter;
        }

        @Override
        public void build(Table table) {
            table.addButton(b -> b.addImage(this.supplier.get().icon(Block.Icon.small)).update(i -> ((TextureRegionDrawable)i.getDrawable()).setRegion(this.supplier.get() == Blocks.air ? Core.atlas.find("icon-none") : this.supplier.get().icon(Block.Icon.small))).size(24.0f), () -> {
                FloatingDialog dialog = new FloatingDialog("");
                dialog.setFillParent(false);
                int i = 0;
                for (Block block : Vars.content.blocks()) {
                    if (!this.filter.test(block)) continue;
                    dialog.cont.addImage(block == Blocks.air ? Core.atlas.find("icon-none-small") : block.icon(Block.Icon.medium)).size(32.0f).pad(3.0f).get().clicked(() -> {
                        this.consumer.accept(block);
                        dialog.hide();
                        this.changed.run();
                    });
                    if (++i % 10 != 0) continue;
                    dialog.cont.row();
                }
                dialog.show();
            }).pad(4.0f).margin(12.0f);
            table.add("$filter.option." + this.name);
        }
    }

    static class SliderOption
    extends FilterOption {
        final String name;
        final FloatProvider getter;
        final FloatConsumer setter;
        final float min;
        final float max;
        final float step;

        SliderOption(String name, FloatProvider getter, FloatConsumer setter, float min, float max) {
            this(name, getter, setter, min, max, (max - min) / 200.0f);
        }

        SliderOption(String name, FloatProvider getter, FloatConsumer setter, float min, float max, float step) {
            this.name = name;
            this.getter = getter;
            this.setter = setter;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        @Override
        public void build(Table table) {
            table.add("$filter.option." + this.name);
            table.row();
            Slider slider = table.addSlider(this.min, this.max, this.step, this.setter).growX().get();
            slider.setValue(this.getter.get());
            if (Vars.updateEditorOnChange) {
                slider.changed(this.changed);
            } else {
                slider.released(this.changed);
            }
        }
    }
}

