/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.math.geom.Vector2;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.arc.util.Scaling;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.world.Tile;

public class MirrorFilter
extends GenerateFilter {
    private final Vector2 v1 = new Vector2();
    private final Vector2 v2 = new Vector2();
    private final Vector2 v3 = new Vector2();
    int angle = 45;

    public MirrorFilter() {
        this.options(new FilterOption.SliderOption("angle", () -> this.angle, f -> {
            this.angle = (int)f;
        }, 0.0f, 360.0f, 45.0f));
    }

    @Override
    protected void apply() {
        this.v1.trnsExact(this.angle - 90, 1.0f);
        this.v2.set(this.v1).scl(-1.0f);
        this.v1.add((float)this.in.width / 2.0f - 0.5f, (float)this.in.height / 2.0f - 0.5f);
        this.v2.add((float)this.in.width / 2.0f - 0.5f, (float)this.in.height / 2.0f - 0.5f);
        this.v3.set(this.in.x, this.in.y);
        if (!this.left(this.v1, this.v2, this.v3)) {
            this.mirror(this.v3, this.v1.x, this.v1.y, this.v2.x, this.v2.y);
            Tile tile = this.in.tile(this.v3.x, this.v3.y);
            this.in.floor = tile.floor();
            if (!tile.block().synthetic()) {
                this.in.block = tile.block();
            }
            this.in.ore = tile.overlay();
        }
    }

    @Override
    public void draw(Image image) {
        super.draw(image);
        Vector2 vsize = Scaling.fit.apply(image.getDrawable().getMinWidth(), image.getDrawable().getMinHeight(), image.getWidth(), image.getHeight());
        float imageWidth = Math.max(vsize.x, vsize.y);
        float imageHeight = Math.max(vsize.y, vsize.x);
        float size = Math.max(image.getWidth() * 2.0f, image.getHeight() * 2.0f);
        Consumer<Vector2> clamper = v -> v.clamp(image.getX() + image.getWidth() / 2.0f - imageWidth / 2.0f, image.getX() + image.getWidth() / 2.0f + imageWidth / 2.0f, image.getY() + image.getHeight() / 2.0f - imageHeight / 2.0f, image.getY() + image.getHeight() / 2.0f + imageHeight / 2.0f);
        clamper.accept(Tmp.v1.trns(this.angle - 90, size).add(image.getWidth() / 2.0f + image.getX(), image.getHeight() / 2.0f + image.getY()));
        clamper.accept(Tmp.v2.set(Tmp.v1).sub(image.getWidth() / 2.0f + image.getX(), image.getHeight() / 2.0f + image.getY()).rotate(180.0f).add(image.getWidth() / 2.0f + image.getX(), image.getHeight() / 2.0f + image.getY()));
        Lines.stroke(Scl.scl(3.0f), Pal.accent);
        Lines.line(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y);
        Draw.reset();
    }

    void mirror(Vector2 p, float x0, float y0, float x1, float y1) {
        if (this.in.width != this.in.height && this.angle % 90 != 0) {
            p.x = (p.x - (float)this.in.width / 2.0f) * -1.0f + (float)this.in.width / 2.0f;
            p.y = (p.y - (float)this.in.height / 2.0f) * -1.0f + (float)this.in.height / 2.0f;
        } else {
            float dx = x1 - x0;
            float dy = y1 - y0;
            float a = (dx * dx - dy * dy) / (dx * dx + dy * dy);
            float b = 2.0f * dx * dy / (dx * dx + dy * dy);
            p.set(a * (p.x - x0) + b * (p.y - y0) + x0, b * (p.x - x0) - a * (p.y - y0) + y0);
        }
    }

    boolean left(Vector2 a, Vector2 b, Vector2 c) {
        return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x) > 0.0f;
    }
}

