/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.filters;

import io.anuke.arc.collection.IntArray;
import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.filters.FilterOption;
import io.anuke.mindustry.maps.filters.GenerateFilter;
import io.anuke.mindustry.world.Tile;

public class OreMedianFilter
extends GenerateFilter {
    public float radius = 2.0f;
    public float percentile = 0.5f;
    private IntArray blocks = new IntArray();

    public OreMedianFilter() {
        this.buffered = true;
        this.options(new FilterOption.SliderOption("radius", () -> this.radius, f -> {
            this.radius = f;
        }, 1.0f, 12.0f), new FilterOption.SliderOption("percentile", () -> this.percentile, f -> {
            this.percentile = f;
        }, 0.0f, 1.0f));
    }

    @Override
    public void apply() {
        if (this.in.ore == Blocks.spawn) {
            return;
        }
        int cx = this.in.x / 2 * 2;
        int cy = this.in.y / 2 * 2;
        if (this.in.ore != Blocks.air && (this.in.tile(cx + 1, cy).overlay() != this.in.ore || this.in.tile(cx, cy).overlay() != this.in.ore || this.in.tile(cx + 1, cy + 1).overlay() != this.in.ore || this.in.tile(cx, cy + 1).overlay() != this.in.ore || this.in.tile(cx + 1, cy).block().isStatic() || this.in.tile(cx, cy).block().isStatic() || this.in.tile(cx + 1, cy + 1).block().isStatic() || this.in.tile(cx, cy + 1).block().isStatic())) {
            this.in.ore = Blocks.air;
        }
        int rad = (int)this.radius;
        this.blocks.clear();
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile tile;
                if (Mathf.dst2(x, y) > (float)(rad * rad) || (tile = this.in.tile(this.in.x + x, this.in.y + y)).overlay() == Blocks.spawn) continue;
                this.blocks.add(tile.overlay().id);
            }
        }
        this.blocks.sort();
        int index = Math.min((int)((float)this.blocks.size * this.percentile), this.blocks.size - 1);
        int overlay = this.blocks.get(index);
        this.in.ore = Vars.content.block(overlay);
    }
}

