/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.generators;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.GridBits;
import io.anuke.arc.collection.IntArray;
import io.anuke.arc.collection.IntFloatMap;
import io.anuke.arc.function.IntPositionConsumer;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.math.geom.Geometry;
import io.anuke.arc.math.geom.Point2;
import io.anuke.arc.util.Structs;
import io.anuke.arc.util.noise.Simplex;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.generators.RandomGenerator;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.Pos;
import io.anuke.mindustry.world.Tile;
import io.anuke.mindustry.world.blocks.Floor;
import java.util.PriorityQueue;

public abstract class BasicGenerator
extends RandomGenerator {
    protected static final DistanceHeuristic manhattan = (x1, y1, x2, y2) -> Math.abs(x1 - x2) + Math.abs(y1 - y2);
    protected Array<Block> ores;
    protected Simplex sim = new Simplex();
    protected Simplex sim2 = new Simplex();

    public BasicGenerator(int width, int height, Block ... ores) {
        super(width, height);
        this.ores = Array.with(ores);
    }

    @Override
    public void generate(Tile[][] tiles) {
        int seed = Mathf.random(99999999);
        this.sim.setSeed(seed);
        this.sim2.setSeed(seed + 1);
        super.generate(tiles);
    }

    public void ores(Tile[][] tiles) {
        this.pass(tiles, (x, y) -> {
            if (this.ores != null) {
                int offsetX = x - 4;
                int offsetY = y + 23;
                for (int i = this.ores.size - 1; i >= 0; --i) {
                    Block entry = this.ores.get(i);
                    if (!(Math.abs(0.5 - this.sim.octaveNoise2D(2.0, 0.7, 1.0f / (float)(40 + i * 2), offsetX, offsetY + i * 999)) > (double)0.26f) || !(Math.abs(0.5 - this.sim2.octaveNoise2D(1.0, 1.0, 1.0f / (float)(30 + i * 4), offsetX, offsetY - i * 999)) > (double)0.37f)) continue;
                    this.ore = entry;
                    break;
                }
            }
        });
    }

    public void terrain(Tile[][] tiles, Block dst, float scl, float mag, float cmag) {
        this.pass(tiles, (x, y) -> {
            double transition;
            double rocks = this.sim.octaveNoise2D(5.0, 0.5, 1.0f / scl, x, y) * (double)mag + (double)(Mathf.dst((float)x / (float)this.width, (float)y / (float)this.height, 0.5f, 0.5f) * cmag);
            double edgeDist = Math.min(x, Math.min(y, Math.min(Math.abs(x - (this.width - 1)), Math.abs(y - (this.height - 1)))));
            if (edgeDist < (transition = 5.0)) {
                rocks += (transition - edgeDist) / transition / 1.5;
            }
            if (rocks > 0.9) {
                this.block = dst;
            }
        });
    }

    public void noise(Tile[][] tiles, Block floor, Block block, int octaves, float falloff, float scl, float threshold) {
        this.sim.setSeed(Mathf.random(99999));
        this.pass(tiles, (x, y) -> {
            if (this.sim.octaveNoise2D(octaves, falloff, 1.0f / scl, x, y) > (double)threshold) {
                Tile tile = tiles[x][y];
                this.floor = floor;
                if (tile.block().solid) {
                    this.block = block;
                }
            }
        });
    }

    public void overlay(Tile[][] tiles, Block floor, Block block, float chance, int octaves, float falloff, float scl, float threshold) {
        this.sim.setSeed(Mathf.random(99999));
        this.pass(tiles, (x, y) -> {
            if (this.sim.octaveNoise2D(octaves, falloff, 1.0f / scl, x, y) > (double)threshold && Mathf.chance(chance) && tiles[x][y].floor() == floor) {
                this.ore = block;
            }
        });
    }

    public void tech(Tile[][] tiles) {
        Block[] blocks = new Block[]{Blocks.darkPanel3};
        int secSize = 20;
        this.pass(tiles, (x, y) -> {
            int mx = x % secSize;
            int my = y % secSize;
            int sclx = x / secSize;
            int scly = y / secSize;
            if (this.noise(sclx, scly, 10.0f, 1.0f) > 0.63f && (mx == 0 || my == 0 || mx == secSize - 1 || my == secSize - 1)) {
                if (Mathf.chance(this.noise(x + 2299171, y, 40.0f, 1.0f))) {
                    this.floor = Structs.random(blocks);
                    if (Mathf.dst(mx, my, secSize / 2, secSize / 2) > (float)secSize / 2.0f + 2.0f) {
                        this.floor = Blocks.darkPanel4;
                    }
                }
                if (this.block.solid && Mathf.chance(0.7)) {
                    this.block = Blocks.darkMetal;
                }
            }
        });
    }

    public void distort(Tile[][] tiles, float scl, float mag) {
        Block[][] blocks = new Block[this.width][this.height];
        Floor[][] floors = new Floor[this.width][this.height];
        this.each((x, y) -> {
            float cx = (float)x + this.noise(x, y, scl, mag) - mag / 2.0f;
            float cy = (float)y + this.noise(x, (float)y + 1525215.0f, scl, mag) - mag / 2.0f;
            Tile other = tiles[Mathf.clamp((int)cx, 0, this.width - 1)][Mathf.clamp((int)cy, 0, this.height - 1)];
            blocks[x][y] = other.block();
            floors[x][y] = other.floor();
        });
        this.pass(tiles, (x, y) -> {
            this.floor = floors[x][y];
            this.block = blocks[x][y];
        });
    }

    public void scatter(Tile[][] tiles, Block target, Block dst, float chance) {
        this.pass(tiles, (x, y) -> {
            if (!Mathf.chance(chance)) {
                return;
            }
            if (this.floor == target) {
                this.floor = dst;
            } else if (this.block == target) {
                this.block = dst;
            }
        });
    }

    public void each(IntPositionConsumer r) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                r.accept(x, y);
            }
        }
    }

    protected float noise(float x, float y, float scl, float mag) {
        return (float)this.sim2.octaveNoise2D(1.0, 0.0, 1.0f / scl, x + 5.669848E7f, y + 3.887248E7f) * mag;
    }

    public void pass(Tile[][] tiles, IntPositionConsumer r) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                this.floor = tiles[x][y].floor();
                this.block = tiles[x][y].block();
                this.ore = tiles[x][y].overlay();
                r.accept(x, y);
                tiles[x][y] = new Tile(x, y, this.floor.id, this.ore.id, this.block.id);
            }
        }
    }

    public void brush(Tile[][] tiles, Array<Tile> path, int rad) {
        path.each((? super T tile) -> this.erase(tiles, tile.x, tile.y, rad));
    }

    public void erase(Tile[][] tiles, int cx, int cy, int rad) {
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                int wx = cx + x;
                int wy = cy + y;
                if (!Structs.inBounds(wx, wy, this.width, this.height) || !(Mathf.dst(x, y, 0.0f, 0.0f) <= (float)rad)) continue;
                Tile other = tiles[wx][wy];
                other.setBlock(Blocks.air);
            }
        }
    }

    public Array<Tile> pathfind(Tile[][] tiles, int startX, int startY, int endX, int endY, TileHueristic th, DistanceHeuristic dh) {
        Tile start = tiles[startX][startY];
        Tile end = tiles[endX][endY];
        GridBits closed = new GridBits(this.width, this.height);
        IntFloatMap costs = new IntFloatMap();
        PriorityQueue<Tile> queue = new PriorityQueue<Tile>(tiles.length * tiles[0].length / 2, (a, b) -> Float.compare(costs.get(a.pos(), 0.0f) + dh.cost(a.x, a.y, end.x, end.y), costs.get(b.pos(), 0.0f) + dh.cost(b.x, b.y, end.x, end.y)));
        queue.add(start);
        boolean found = false;
        while (!queue.isEmpty()) {
            Tile next = (Tile)queue.poll();
            float baseCost = costs.get(next.pos(), 0.0f);
            if (next == end) {
                found = true;
                break;
            }
            closed.set(next.x, next.y);
            for (Point2 point : Geometry.d4) {
                int newx = next.x + point.x;
                int newy = next.y + point.y;
                if (!Structs.inBounds(newx, newy, this.width, this.height)) continue;
                Tile child = tiles[newx][newy];
                if (closed.get(child.x, child.y)) continue;
                closed.set(child.x, child.y);
                child.rotation(child.relativeTo(next.x, next.y));
                costs.put(child.pos(), th.cost(child) + baseCost);
                queue.add(child);
            }
        }
        Array<Tile> out = new Array<Tile>();
        if (!found) {
            return out;
        }
        Tile current = end;
        while (current != start) {
            out.add(current);
            Point2 p = Geometry.d4(current.rotation());
            current = tiles[current.x + p.x][current.y + p.y];
        }
        out.reverse();
        return out;
    }

    public void inverseFloodFill(Tile[][] tiles, Tile start, Block block) {
        IntArray arr = new IntArray();
        arr.add(start.pos());
        while (!arr.isEmpty()) {
            int i = arr.pop();
            short x = Pos.x(i);
            short y = Pos.y(i);
            tiles[x][y].cost = (byte)2;
            for (Point2 point : Geometry.d4) {
                Tile child;
                int newx = x + point.x;
                int newy = y + point.y;
                if (!Structs.inBounds(newx, newy, this.width, this.height) || (child = tiles[newx][newy]).block() != Blocks.air || child.cost == 2) continue;
                child.cost = (byte)2;
                arr.add(child.pos());
            }
        }
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                Tile tile = tiles[x][y];
                if (tile.cost == 2 || tile.block() != Blocks.air) continue;
                tile.setBlock(block);
            }
        }
    }

    public static interface TileHueristic {
        public float cost(Tile var1);
    }

    public static interface DistanceHeuristic {
        public float cost(int var1, int var2, int var3, int var4);
    }
}

