/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.zonegen;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.generators.BasicGenerator;
import io.anuke.mindustry.world.Tile;

public class DesertWastesGenerator
extends BasicGenerator {
    public DesertWastesGenerator(int width, int height) {
        super(width, height, Blocks.oreCopper, Blocks.oreLead, Blocks.oreCoal, Blocks.oreCopper);
    }

    @Override
    public void generate(int x, int y) {
        this.floor = Blocks.sand;
    }

    @Override
    public void decorate(Tile[][] tiles) {
        this.ores(tiles);
        this.terrain(tiles, Blocks.sandRocks, 60.0f, 1.5f, 0.9f);
        int rand = 40;
        int border = 25;
        int spawnX = Mathf.clamp(30 + Mathf.range(rand), border, this.width - border);
        int spawnY = Mathf.clamp(30 + Mathf.range(rand), border, this.height - border);
        int endX = Mathf.clamp(this.width - 30 + Mathf.range(rand), border, this.width - border);
        int endY = Mathf.clamp(this.height - 30 + Mathf.range(rand), border, this.height - border);
        this.brush(tiles, this.pathfind(tiles, spawnX, spawnY, endX, endY, tile -> tile.solid() ? 5.0f : 0.0f, manhattan), 6);
        this.brush(tiles, this.pathfind(tiles, spawnX, spawnY, endX, endY, tile -> tile.solid() ? 4.0f : 0.0f + (float)this.sim.octaveNoise2D(1.0, 1.0, 0.025f, tile.x, tile.y) * 20.0f, manhattan), 5);
        this.erase(tiles, endX, endY, 10);
        this.erase(tiles, spawnX, spawnY, 20);
        this.distort(tiles, 20.0f, 4.0f);
        this.inverseFloodFill(tiles, tiles[spawnX][spawnY], Blocks.sandRocks);
        this.noise(tiles, Blocks.salt, Blocks.saltRocks, 5, 0.6f, 200.0f, 0.55f);
        this.noise(tiles, Blocks.darksand, Blocks.duneRocks, 5, 0.7f, 120.0f, 0.5f);
        this.tech(tiles);
        this.overlay(tiles, Blocks.sand, Blocks.pebbles, 0.15f, 5, 0.8f, 30.0f, 0.62f);
        tiles[endX][endY].setOverlay(Blocks.spawn);
        this.loadout.setup(spawnX, spawnY);
    }
}

