/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.maps.zonegen;

import io.anuke.arc.math.Mathf;
import io.anuke.mindustry.content.Blocks;
import io.anuke.mindustry.maps.generators.BasicGenerator;
import io.anuke.mindustry.world.Tile;

public class OvergrowthGenerator
extends BasicGenerator {
    public OvergrowthGenerator(int width, int height) {
        super(width, height, Blocks.oreCopper, Blocks.oreLead, Blocks.oreCoal, Blocks.oreCopper);
    }

    @Override
    public void generate(int x, int y) {
        this.floor = Blocks.moss;
    }

    @Override
    public void decorate(Tile[][] tiles) {
        this.ores(tiles);
        this.terrain(tiles, Blocks.sporePine, 70.0f, 1.4f, 1.0f);
        int rand = 40;
        int border = 25;
        int spawnX = Mathf.clamp(30 + Mathf.range(rand), border, this.width - border);
        int spawnY = Mathf.clamp(30 + Mathf.range(rand), border, this.height - border);
        int endX = Mathf.clamp(this.width - 30 + Mathf.range(rand), border, this.width - border);
        int endY = Mathf.clamp(this.height - 30 + Mathf.range(rand), border, this.height - border);
        this.brush(tiles, this.pathfind(tiles, spawnX, spawnY, endX, endY, tile -> (tile.solid() ? 5.0f : 0.0f) + (float)this.sim.octaveNoise2D(1.0, 1.0, 0.02f, tile.x, tile.y) * 50.0f, manhattan), 6);
        this.brush(tiles, this.pathfind(tiles, spawnX, spawnY, endX, endY, tile -> (tile.solid() ? 4.0f : 0.0f) + (float)this.sim.octaveNoise2D(1.0, 1.0, 0.011111111380159855, tile.x + 999, tile.y) * 70.0f, manhattan), 5);
        this.erase(tiles, endX, endY, 10);
        this.erase(tiles, spawnX, spawnY, 20);
        this.distort(tiles, 20.0f, 4.0f);
        this.inverseFloodFill(tiles, tiles[spawnX][spawnY], Blocks.sporerocks);
        this.noise(tiles, Blocks.darksandTaintedWater, Blocks.duneRocks, 4, 0.7f, 120.0f, 0.64f);
        tiles[endX][endY].setOverlay(Blocks.spawn);
        this.loadout.setup(spawnX, spawnY);
    }
}

