/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.net.ArcNetException;
import io.anuke.arc.net.Client;
import io.anuke.arc.net.Connection;
import io.anuke.arc.net.DcReason;
import io.anuke.arc.net.FrameworkMessage;
import io.anuke.arc.net.InputStreamSender;
import io.anuke.arc.net.NetListener;
import io.anuke.arc.net.NetSerializer;
import io.anuke.arc.net.Server;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.async.Threads;
import io.anuke.arc.util.pooling.Pools;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.net.Host;
import io.anuke.mindustry.net.Net;
import io.anuke.mindustry.net.NetConnection;
import io.anuke.mindustry.net.NetworkIO;
import io.anuke.mindustry.net.Packet;
import io.anuke.mindustry.net.Packets;
import io.anuke.mindustry.net.Registrator;
import io.anuke.mindustry.net.Streamable;
import io.anuke.mindustry.net.ValidateException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.util.concurrent.CopyOnWriteArrayList;

public class ArcNetImpl
implements Net.NetProvider {
    final Client client;
    final Supplier<DatagramPacket> packetSupplier = () -> new DatagramPacket(new byte[256], 256);
    final Server server;
    final CopyOnWriteArrayList<ArcConnection> connections = new CopyOnWriteArrayList();
    Thread serverThread;

    public ArcNetImpl() {
        this.client = new Client(8192, 4096, new PacketSerializer());
        this.client.setDiscoveryPacket(this.packetSupplier);
        this.client.addListener(new NetListener(){

            @Override
            public void connected(Connection connection) {
                Packets.Connect c = new Packets.Connect();
                c.addressTCP = connection.getRemoteAddressTCP().getAddress().getHostAddress();
                if (connection.getRemoteAddressTCP() != null) {
                    c.addressTCP = connection.getRemoteAddressTCP().toString();
                }
                Core.app.post(() -> Vars.net.handleClientReceived(c));
            }

            @Override
            public void disconnected(Connection connection, DcReason reason) {
                if (connection.getLastProtocolError() != null) {
                    Vars.netClient.setQuiet();
                }
                Packets.Disconnect c = new Packets.Disconnect();
                c.reason = reason.toString();
                Core.app.post(() -> Vars.net.handleClientReceived(c));
            }

            @Override
            public void received(Connection connection, Object object) {
                if (object instanceof FrameworkMessage) {
                    return;
                }
                Core.app.post(() -> {
                    try {
                        Vars.net.handleClientReceived(object);
                    }
                    catch (Exception e) {
                        ArcNetImpl.this.handleException(e);
                    }
                });
            }
        });
        this.server = new Server(8192, 4096, new PacketSerializer());
        this.server.setMulticast("227.2.7.7", 20151);
        this.server.setDiscoveryHandler((address, handler) -> {
            ByteBuffer buffer = NetworkIO.writeServerData();
            buffer.position(0);
            handler.respond(buffer);
        });
        this.server.addListener(new NetListener(){

            @Override
            public void connected(Connection connection) {
                String ip = connection.getRemoteAddressTCP().getAddress().getHostAddress();
                ArcConnection kn = new ArcConnection(ip, connection);
                Packets.Connect c = new Packets.Connect();
                c.addressTCP = ip;
                Log.debug("&bRecieved connection: {0}", c.addressTCP);
                ArcNetImpl.this.connections.add(kn);
                Core.app.post(() -> Vars.net.handleServerReceived(kn, c));
            }

            @Override
            public void disconnected(Connection connection, DcReason reason) {
                ArcConnection k = ArcNetImpl.this.getByArcID(connection.getID());
                if (k == null) {
                    return;
                }
                Packets.Disconnect c = new Packets.Disconnect();
                c.reason = reason.toString();
                Core.app.post(() -> {
                    Vars.net.handleServerReceived(k, c);
                    ArcNetImpl.this.connections.remove(k);
                });
            }

            @Override
            public void received(Connection connection, Object object) {
                ArcConnection k = ArcNetImpl.this.getByArcID(connection.getID());
                if (object instanceof FrameworkMessage || k == null) {
                    return;
                }
                Core.app.post(() -> {
                    try {
                        Vars.net.handleServerReceived(k, object);
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof ValidateException) {
                            ValidateException v = (ValidateException)e.getCause();
                            Log.err("Validation failed: {0} ({1})", v.player.name, v.getMessage());
                        } else {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
        });
    }

    private static boolean isLocal(InetAddress addr) {
        if (addr.isAnyLocalAddress() || addr.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(addr) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void connectClient(String ip, int port, Runnable success) {
        Threads.daemon(() -> {
            try {
                this.client.stop();
                Threads.daemon("Net Client", () -> {
                    block2: {
                        try {
                            this.client.run();
                        }
                        catch (Exception e) {
                            if (e instanceof ClosedSelectorException) break block2;
                            this.handleException(e);
                        }
                    }
                });
                this.client.connect(5000, ip, port, port);
                success.run();
            }
            catch (Exception e) {
                this.handleException(e);
            }
        });
    }

    @Override
    public void disconnectClient() {
        this.client.close();
    }

    @Override
    public void sendClient(Object object, Net.SendMode mode) {
        try {
            if (mode == Net.SendMode.tcp) {
                this.client.sendTCP(object);
            } else {
                this.client.sendUDP(object);
            }
        }
        catch (BufferOverflowException | BufferUnderflowException e) {
            Vars.net.showError(e);
        }
        Pools.free(object);
    }

    @Override
    public void pingHost(String address, int port, Consumer<Host> valid, Consumer<Exception> invalid) {
        Threads.daemon(() -> {
            try {
                DatagramSocket socket = new DatagramSocket();
                socket.send(new DatagramPacket(new byte[]{-2, 1}, 2, InetAddress.getByName(address), port));
                socket.setSoTimeout(2000);
                DatagramPacket packet = this.packetSupplier.get();
                socket.receive(packet);
                ByteBuffer buffer = ByteBuffer.wrap(packet.getData());
                Host host = NetworkIO.readServerData(packet.getAddress().getHostAddress(), buffer);
                Core.app.post(() -> valid.accept(host));
            }
            catch (Exception e) {
                Core.app.post(() -> invalid.accept(e));
            }
        });
    }

    @Override
    public void discoverServers(Consumer<Host> callback, Runnable done) {
        Array foundAddresses = new Array();
        this.client.discoverHosts(6567, "227.2.7.7", 20151, 3000, packet -> Core.app.post(() -> {
            try {
                if (foundAddresses.contains(address -> address.equals(packet.getAddress()) || ArcNetImpl.isLocal(address) && ArcNetImpl.isLocal(packet.getAddress()))) {
                    return;
                }
                ByteBuffer buffer = ByteBuffer.wrap(packet.getData());
                Host host = NetworkIO.readServerData(packet.getAddress().getHostAddress(), buffer);
                callback.accept(host);
                foundAddresses.add(packet.getAddress());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }), () -> Core.app.post(done));
    }

    @Override
    public void dispose() {
        this.disconnectClient();
        this.closeServer();
        try {
            this.client.dispose();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Iterable<ArcConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void hostServer(int port) throws IOException {
        this.connections.clear();
        this.server.bind(port, port);
        this.serverThread = new Thread(() -> {
            block2: {
                try {
                    this.server.run();
                }
                catch (Throwable e) {
                    if (e instanceof ClosedSelectorException) break block2;
                    Threads.throwAppException(e);
                }
            }
        }, "Net Server");
        this.serverThread.setDaemon(true);
        this.serverThread.start();
    }

    @Override
    public void closeServer() {
        this.connections.clear();
        Threads.daemon(this.server::stop);
    }

    ArcConnection getByArcID(int id) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ArcConnection con = this.connections.get(i);
            if (con.connection == null || con.connection.getID() != id) continue;
            return con;
        }
        return null;
    }

    private void handleException(Exception e) {
        if (e instanceof ArcNetException) {
            Core.app.post(() -> Vars.net.showError(new IOException("mismatch")));
        } else if (e instanceof ClosedChannelException) {
            Core.app.post(() -> Vars.net.showError(new IOException("alreadyconnected")));
        } else {
            Core.app.post(() -> Vars.net.showError(e));
        }
    }

    public static class PacketSerializer
    implements NetSerializer {
        @Override
        public void write(ByteBuffer byteBuffer, Object o) {
            if (o instanceof FrameworkMessage) {
                byteBuffer.put((byte)-2);
                this.writeFramework(byteBuffer, (FrameworkMessage)o);
            } else {
                if (!(o instanceof Packet)) {
                    throw new RuntimeException("All sent objects must implement be Packets! Class: " + o.getClass());
                }
                byte id = Registrator.getID(o.getClass());
                if (id == -1) {
                    throw new RuntimeException("Unregistered class: " + o.getClass());
                }
                byteBuffer.put(id);
                ((Packet)o).write(byteBuffer);
            }
        }

        @Override
        public Object read(ByteBuffer byteBuffer) {
            byte id = byteBuffer.get();
            if (id == -2) {
                return this.readFramework(byteBuffer);
            }
            Packet packet = (Packet)Pools.obtain(Registrator.getByID((byte)id).type, Registrator.getByID((byte)id).constructor);
            packet.read(byteBuffer);
            return packet;
        }

        public void writeFramework(ByteBuffer buffer, FrameworkMessage message) {
            if (message instanceof FrameworkMessage.Ping) {
                FrameworkMessage.Ping p = (FrameworkMessage.Ping)message;
                buffer.put((byte)0);
                buffer.putInt(p.id);
                buffer.put(p.isReply ? (byte)1 : 0);
            } else if (message instanceof FrameworkMessage.DiscoverHost) {
                buffer.put((byte)1);
            } else if (message instanceof FrameworkMessage.KeepAlive) {
                buffer.put((byte)2);
            } else if (message instanceof FrameworkMessage.RegisterUDP) {
                FrameworkMessage.RegisterUDP p = (FrameworkMessage.RegisterUDP)message;
                buffer.put((byte)3);
                buffer.putInt(p.connectionID);
            } else if (message instanceof FrameworkMessage.RegisterTCP) {
                FrameworkMessage.RegisterTCP p = (FrameworkMessage.RegisterTCP)message;
                buffer.put((byte)4);
                buffer.putInt(p.connectionID);
            }
        }

        public FrameworkMessage readFramework(ByteBuffer buffer) {
            byte id = buffer.get();
            if (id == 0) {
                FrameworkMessage.Ping p = new FrameworkMessage.Ping();
                p.id = buffer.getInt();
                p.isReply = buffer.get() == 1;
                return p;
            }
            if (id == 1) {
                return new FrameworkMessage.DiscoverHost();
            }
            if (id == 2) {
                return new FrameworkMessage.KeepAlive();
            }
            if (id == 3) {
                FrameworkMessage.RegisterUDP p = new FrameworkMessage.RegisterUDP();
                p.connectionID = buffer.getInt();
                return p;
            }
            if (id == 4) {
                FrameworkMessage.RegisterTCP p = new FrameworkMessage.RegisterTCP();
                p.connectionID = buffer.getInt();
                return p;
            }
            throw new RuntimeException("Unknown framework message!");
        }
    }

    class ArcConnection
    extends NetConnection {
        public final Connection connection;

        public ArcConnection(String address, Connection connection) {
            super(address);
            this.connection = connection;
        }

        @Override
        public boolean isConnected() {
            return this.connection.isConnected();
        }

        @Override
        public void sendStream(final Streamable stream) {
            this.connection.addListener(new InputStreamSender(stream.stream, 512){
                int id;

                @Override
                protected void start() {
                    Packets.StreamBegin begin = new Packets.StreamBegin();
                    begin.total = stream.stream.available();
                    begin.type = Registrator.getID(stream.getClass());
                    ArcConnection.this.connection.sendTCP(begin);
                    this.id = begin.id;
                }

                @Override
                protected Object next(byte[] bytes) {
                    Packets.StreamChunk chunk = new Packets.StreamChunk();
                    chunk.id = this.id;
                    chunk.data = bytes;
                    return chunk;
                }
            });
        }

        @Override
        public void send(Object object, Net.SendMode mode) {
            block4: {
                try {
                    if (mode == Net.SendMode.tcp) {
                        this.connection.sendTCP(object);
                    } else {
                        this.connection.sendUDP(object);
                    }
                }
                catch (Exception e) {
                    Log.err(e);
                    Log.info("Error sending packet. Disconnecting invalid client!");
                    this.connection.close(DcReason.error);
                    ArcConnection k = ArcNetImpl.this.getByArcID(this.connection.getID());
                    if (k == null) break block4;
                    ArcNetImpl.this.connections.remove(k);
                }
            }
        }

        @Override
        public void close() {
            if (this.connection.isConnected()) {
                this.connection.close(DcReason.closed);
            }
        }
    }
}

