/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.net;

import io.anuke.arc.Core;
import io.anuke.arc.Net;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.util.Log;
import io.anuke.arc.util.NetJavaImpl;
import io.anuke.arc.util.OS;
import io.anuke.arc.util.Strings;
import io.anuke.arc.util.io.PropertiesUtils;
import io.anuke.arc.util.serialization.JsonValue;
import io.anuke.arc.util.serialization.JsonWriter;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.game.Version;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CrashSender {
    public static void send(Throwable exception, Consumer<File> writeListener) {
        try {
            exception.printStackTrace();
            if (Version.build == -1) {
                return;
            }
            if (Version.number == 0) {
                try {
                    ObjectMap<String, String> map = new ObjectMap<String, String>();
                    PropertiesUtils.load(map, new InputStreamReader(CrashSender.class.getResourceAsStream("/version.properties")));
                    Version.type = map.get("type");
                    Version.number = Integer.parseInt(map.get("number"));
                    Version.modifier = map.get("modifier");
                    if (map.get("build").contains(".")) {
                        String[] split = map.get("build").split("\\.");
                        Version.build = Integer.parseInt(split[0]);
                        Version.revision = Integer.parseInt(split[1]);
                    } else {
                        Version.build = Strings.canParseInt(map.get("build")) ? Integer.parseInt(map.get("build")) : -1;
                    }
                }
                catch (Throwable ignored) {
                    ignored.printStackTrace();
                    Log.err("Failed to parse version.", new Object[0]);
                }
            }
            try {
                File file = new File(OS.getAppDataDirectoryString("Mindustry"), "crashes/crash-report-" + new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss").format(new Date()) + ".txt");
                Files.createDirectories(Paths.get(OS.getAppDataDirectoryString("Mindustry"), "crashes"), new FileAttribute[0]);
                Files.write(file.toPath(), CrashSender.parseException(exception).getBytes(), new OpenOption[0]);
                writeListener.accept(file);
            }
            catch (Throwable e) {
                e.printStackTrace();
                Log.err("Failed to save local crash report.", new Object[0]);
            }
            try {
                if (!Core.settings.getBool("crashreport", true)) {
                    return;
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (Version.number == 0) {
                return;
            }
            boolean netActive = false;
            boolean netServer = false;
            try {
                netActive = Vars.net.active();
                netServer = Vars.net.server();
                Vars.net.dispose();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            JsonValue value = new JsonValue(JsonValue.ValueType.object);
            boolean fn = netActive;
            boolean fs = netServer;
            CrashSender.ex(() -> value.addChild("versionType", new JsonValue(Version.type)));
            CrashSender.ex(() -> value.addChild("versionNumber", new JsonValue(Version.number)));
            CrashSender.ex(() -> value.addChild("versionModifier", new JsonValue(Version.modifier)));
            CrashSender.ex(() -> value.addChild("build", new JsonValue(Version.build)));
            CrashSender.ex(() -> value.addChild("net", new JsonValue(fn)));
            CrashSender.ex(() -> value.addChild("server", new JsonValue(fs)));
            CrashSender.ex(() -> value.addChild("players", new JsonValue(Vars.playerGroup.size())));
            CrashSender.ex(() -> value.addChild("state", new JsonValue(Vars.state.getState().name())));
            CrashSender.ex(() -> value.addChild("os", new JsonValue(System.getProperty("os.name") + "x" + (OS.is64Bit ? "64" : "32"))));
            CrashSender.ex(() -> value.addChild("trace", new JsonValue(CrashSender.parseException(exception))));
            boolean[] sent = new boolean[]{false};
            Log.info("Sending crash report.");
            CrashSender.httpPost("http://mins.us.to/report", value.toJson(JsonWriter.OutputType.json), r -> {
                Log.info("Crash sent successfully.");
                sent[0] = true;
                System.exit(1);
            }, t -> {
                t.printStackTrace();
                sent[0] = true;
                System.exit(1);
            });
            try {
                while (!sent[0]) {
                    Thread.sleep(30L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (Throwable death) {
            death.printStackTrace();
            System.exit(1);
        }
    }

    private static void httpPost(String url, String content, Consumer<Net.HttpResponse> success, Consumer<Throwable> failure) {
        new NetJavaImpl().http(new Net.HttpRequest().method(Net.HttpMethod.POST).content(content).url(url), success, failure);
    }

    private static String parseException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static void ex(Runnable r) {
        try {
            r.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

