/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.plugin;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.files.FileHandle;
import io.anuke.arc.files.ZipFileHandle;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.util.Log;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.io.JsonIO;
import io.anuke.mindustry.plugin.Plugin;
import java.net.URL;
import java.net.URLClassLoader;

public class Plugins {
    private Array<LoadedPlugin> loaded = new Array();
    private ObjectMap<Class<?>, PluginMeta> metas = new ObjectMap();

    public FileHandle getConfig(Plugin plugin) {
        PluginMeta load = this.metas.get(plugin.getClass());
        if (load == null) {
            throw new IllegalArgumentException("Plugin is not loaded yet (or missing)!");
        }
        return Vars.pluginDirectory.child(load.name).child("config.json");
    }

    public LoadedPlugin getPlugin(Class<? extends Plugin> type) {
        return this.loaded.find(l -> l.plugin.getClass() == type);
    }

    public void load() {
        for (FileHandle file : Vars.pluginDirectory.list()) {
            if (!file.extension().equals("jar")) continue;
            try {
                this.loaded.add(this.loadPlugin(file));
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (Exception e) {
                Log.err("Failed to load plugin file {0}. Skipping.", file);
                e.printStackTrace();
            }
        }
    }

    public Array<LoadedPlugin> all() {
        return this.loaded;
    }

    public void each(Consumer<Plugin> cons) {
        this.loaded.each((? super T p) -> cons.accept(p.plugin));
    }

    private LoadedPlugin loadPlugin(FileHandle jar) throws Exception {
        ZipFileHandle zip = new ZipFileHandle(jar);
        FileHandle metaf = ((FileHandle)zip).child("plugin.json");
        if (!metaf.exists()) {
            Log.warn("Plugin {0} doesn't have a 'plugin.json' file, skipping.", jar);
            throw new IllegalArgumentException();
        }
        PluginMeta meta = JsonIO.read(PluginMeta.class, metaf.readString());
        URLClassLoader classLoader = new URLClassLoader(new URL[]{jar.file().toURI().toURL()}, ClassLoader.getSystemClassLoader());
        Class<?> main = classLoader.loadClass(meta.main);
        this.metas.put(main, meta);
        return new LoadedPlugin(jar, zip, (Plugin)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), meta);
    }

    public static class PluginMeta {
        public String name;
        public String author;
        public String main;
        public String description;
        public String version;
    }

    public static class LoadedPlugin {
        public final FileHandle jarFile;
        public final FileHandle zipRoot;
        public final Plugin plugin;
        public final PluginMeta meta;

        public LoadedPlugin(FileHandle jarFile, FileHandle zipRoot, Plugin plugin, PluginMeta meta) {
            this.zipRoot = zipRoot;
            this.jarFile = jarFile;
            this.plugin = plugin;
            this.meta = meta;
        }
    }
}

