/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.ObjectMap;
import io.anuke.arc.function.Supplier;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.type.Unit;
import io.anuke.mindustry.entities.units.Statuses;
import io.anuke.mindustry.game.Content;
import io.anuke.mindustry.type.ContentType;

public class StatusEffect
extends Content {
    public float damageMultiplier = 1.0f;
    public float armorMultiplier = 1.0f;
    public float speedMultiplier = 1.0f;
    public Color color = Color.white.cpy();
    private ObjectMap<StatusEffect, TransitionHandler> transitions = new ObjectMap();
    private Array<Object[]> transInit = new Array();
    protected float damage;
    protected Effects.Effect effect = Fx.none;

    @Override
    public void init() {
        for (Object[] pair : this.transInit) {
            Supplier sup = (Supplier)pair[0];
            TransitionHandler handler = (TransitionHandler)pair[1];
            this.transitions.put((StatusEffect)sup.get(), handler);
        }
        this.transInit.clear();
    }

    public void update(Unit unit, float time) {
        if (this.damage > 0.0f) {
            unit.damagePeriodic(this.damage);
        } else if (this.damage < 0.0f) {
            unit.healBy(this.damage * Time.delta());
        }
        if (this.effect != Fx.none && Mathf.chance(Time.delta() * 0.15f)) {
            Effects.effect(this.effect, unit.x + Mathf.range(unit.getSize() / 2.0f), unit.y + Mathf.range(unit.getSize() / 2.0f));
        }
    }

    protected void trans(Supplier<StatusEffect> effect, TransitionHandler handler) {
        this.transInit.add(new Object[]{effect, handler});
    }

    protected void opposite(Supplier ... effect) {
        for (Supplier sup : effect) {
            this.trans(sup, (unit, time, newTime, result) -> {
                if ((time -= newTime * 0.5f) > 0.0f) {
                    result.set(this, time);
                    return;
                }
                result.set((StatusEffect)sup.get(), newTime);
            });
        }
    }

    public boolean reactsWith(StatusEffect effect) {
        return this.transitions.containsKey(effect);
    }

    public Statuses.StatusEntry getTransition(Unit unit, StatusEffect to, float time, float newTime, Statuses.StatusEntry result) {
        if (this.transitions.containsKey(to)) {
            this.transitions.get(to).handle(unit, time, newTime, result);
            return result;
        }
        return result.set(to, newTime);
    }

    @Override
    public ContentType getContentType() {
        return ContentType.status;
    }

    public static interface TransitionHandler {
        public void handle(Unit var1, float var2, float var3, Statuses.StatusEntry var4);
    }
}

