/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.audio.Sound;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.math.Angles;
import io.anuke.arc.math.Mathf;
import io.anuke.arc.util.Time;
import io.anuke.arc.util.Tmp;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Fx;
import io.anuke.mindustry.entities.Effects;
import io.anuke.mindustry.entities.bullet.BulletType;
import io.anuke.mindustry.entities.traits.ShooterTrait;
import io.anuke.mindustry.entities.type.Bullet;
import io.anuke.mindustry.entities.type.Player;
import io.anuke.mindustry.gen.Call;
import io.anuke.mindustry.gen.Sounds;

public class Weapon {
    public final String name;
    protected static float minPlayerDist = 20.0f;
    protected static int sequenceNum = 0;
    public BulletType bullet;
    public Effects.Effect ejectEffect = Fx.none;
    public float reload;
    public int shots = 1;
    public float spacing = 12.0f;
    public float inaccuracy = 0.0f;
    public float shake = 0.0f;
    public float recoil = 1.5f;
    public float length = 3.0f;
    public float width = 4.0f;
    public float velocityRnd = 0.0f;
    public boolean roundrobin = false;
    public float lengthRand = 0.0f;
    public float shotDelay = 0.0f;
    public boolean ignoreRotation = false;
    public Sound shootSound = Sounds.pew;
    public TextureRegion region;

    protected Weapon(String name) {
        this.name = name;
    }

    protected Weapon() {
        this.name = "";
    }

    public static void onPlayerShootWeapon(Player player, float x, float y, float rotation, boolean left) {
        if (player == null) {
            return;
        }
        if (Vars.net.client() && player == Vars.player) {
            return;
        }
        Weapon.shootDirect(player, x, y, rotation, left);
    }

    public static void onGenericShootWeapon(ShooterTrait shooter, float x, float y, float rotation, boolean left) {
        if (shooter == null) {
            return;
        }
        Weapon.shootDirect(shooter, x, y, rotation, left);
    }

    public static void shootDirect(ShooterTrait shooter, float offsetX, float offsetY, float rotation, boolean left) {
        float x = shooter.getX() + offsetX;
        float y = shooter.getY() + offsetY;
        float baseX = shooter.getX();
        float baseY = shooter.getY();
        Weapon weapon = shooter.getWeapon();
        weapon.shootSound.at(x, y, Mathf.random(0.8f, 1.0f));
        sequenceNum = 0;
        if (weapon.shotDelay > 0.01f) {
            Angles.shotgun(weapon.shots, weapon.spacing, rotation, f -> {
                Time.run((float)sequenceNum * weapon.shotDelay, () -> weapon.bullet(shooter, x + shooter.getX() - baseX, y + shooter.getY() - baseY, f + Mathf.range(weapon.inaccuracy)));
                ++sequenceNum;
            });
        } else {
            Angles.shotgun(weapon.shots, weapon.spacing, rotation, f -> weapon.bullet(shooter, x, y, f + Mathf.range(weapon.inaccuracy)));
        }
        BulletType ammo = weapon.bullet;
        Tmp.v1.trns(rotation + 180.0f, ammo.recoil);
        shooter.velocity().add(Tmp.v1);
        Tmp.v1.trns(rotation, 3.0f);
        Effects.shake(weapon.shake, weapon.shake, x, y);
        Effects.effect(weapon.ejectEffect, x, y, rotation * (float)(-Mathf.sign(left)));
        Effects.effect(ammo.shootEffect, x + Tmp.v1.x, y + Tmp.v1.y, rotation, shooter);
        Effects.effect(ammo.smokeEffect, x + Tmp.v1.x, y + Tmp.v1.y, rotation, shooter);
        shooter.getTimer().get(shooter.getShootTimer(left), weapon.reload);
    }

    public void load() {
        this.region = Core.atlas.find(this.name + "-equip", Core.atlas.find("clear"));
    }

    public void update(ShooterTrait shooter, float pointerX, float pointerY) {
        for (boolean left : Mathf.booleans) {
            Tmp.v1.set(pointerX, pointerY).sub(shooter.getX(), shooter.getY());
            if (Tmp.v1.len() < minPlayerDist) {
                Tmp.v1.setLength(minPlayerDist);
            }
            float cx = Tmp.v1.x + shooter.getX();
            float cy = Tmp.v1.y + shooter.getY();
            float ang = Tmp.v1.angle();
            Tmp.v1.trns(ang - 90.0f, this.width * (float)Mathf.sign(left), this.length + Mathf.range(this.lengthRand));
            this.update(shooter, shooter.getX() + Tmp.v1.x, shooter.getY() + Tmp.v1.y, Angles.angle(shooter.getX() + Tmp.v1.x, shooter.getY() + Tmp.v1.y, cx, cy), left);
        }
    }

    public void update(ShooterTrait shooter, float mountX, float mountY, float angle, boolean left) {
        if (shooter.getTimer().get(shooter.getShootTimer(left), this.reload)) {
            if (this.roundrobin) {
                shooter.getTimer().reset(shooter.getShootTimer(!left), this.reload / 2.0f);
            }
            this.shoot(shooter, mountX - shooter.getX(), mountY - shooter.getY(), angle, left);
        }
    }

    public float getRecoil(ShooterTrait player, boolean left) {
        return (1.0f - Mathf.clamp(player.getTimer().getTime(player.getShootTimer(left)) / this.reload)) * this.recoil;
    }

    public void shoot(ShooterTrait p, float x, float y, float angle, boolean left) {
        if (Vars.net.client()) {
            Weapon.shootDirect(p, x, y, angle, left);
        } else if (p instanceof Player) {
            Call.onPlayerShootWeapon((Player)p, x, y, angle, left);
        } else {
            Call.onGenericShootWeapon(p, x, y, angle, left);
        }
    }

    void bullet(ShooterTrait owner, float x, float y, float angle) {
        if (owner == null) {
            return;
        }
        Tmp.v1.trns(angle, 3.0f);
        Bullet.create(this.bullet, owner, owner.getTeam(), x + Tmp.v1.x, y + Tmp.v1.y, angle, 1.0f - this.velocityRnd + Mathf.random(this.velocityRnd));
    }
}

