/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.type;

import io.anuke.arc.Core;
import io.anuke.arc.Events;
import io.anuke.arc.collection.Array;
import io.anuke.arc.function.Consumer;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Structs;
import io.anuke.mindustry.Vars;
import io.anuke.mindustry.content.Loadouts;
import io.anuke.mindustry.game.EventType;
import io.anuke.mindustry.game.Rules;
import io.anuke.mindustry.game.UnlockableContent;
import io.anuke.mindustry.maps.generators.Generator;
import io.anuke.mindustry.maps.generators.MapGenerator;
import io.anuke.mindustry.type.ContentType;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.ItemStack;
import io.anuke.mindustry.type.Loadout;
import io.anuke.mindustry.world.Block;
import java.util.Arrays;

public class Zone
extends UnlockableContent {
    public final Generator generator;
    public Block[] blockRequirements = new Block[0];
    public ZoneRequirement[] zoneRequirements = new ZoneRequirement[0];
    public Item[] resources = new Item[0];
    public Consumer<Rules> rules = rules -> {};
    public boolean alwaysUnlocked;
    public int conditionWave = Integer.MAX_VALUE;
    public int configureWave = 15;
    public int launchPeriod = 10;
    public Loadout loadout = Loadouts.basicShard;
    public TextureRegion preview;
    protected ItemStack[] baseLaunchCost = new ItemStack[0];
    protected Array<ItemStack> startingItems = new Array();
    protected ItemStack[] launchCost = null;
    private Array<ItemStack> defaultStartingItems = new Array();

    public Zone(String name, Generator generator) {
        super(name);
        this.generator = generator;
    }

    @Override
    public void load() {
        this.preview = Core.atlas.find("zone-" + this.name);
    }

    public Rules getRules() {
        if (this.generator instanceof MapGenerator) {
            return ((MapGenerator)this.generator).getMap().rules();
        }
        Rules rules = new Rules();
        this.rules.accept(rules);
        return rules;
    }

    public boolean isBossWave(int wave) {
        return wave % this.configureWave == 0 && wave > 0;
    }

    public boolean isLaunchWave(int wave) {
        return this.metCondition() && wave % this.launchPeriod == 0;
    }

    public boolean canUnlock() {
        if (Vars.data.isUnlocked(this)) {
            return true;
        }
        for (ZoneRequirement zoneRequirement : this.zoneRequirements) {
            if (zoneRequirement.zone.bestWave() >= zoneRequirement.wave) continue;
            return false;
        }
        for (Block block : this.blockRequirements) {
            if (Vars.data.isUnlocked(block)) continue;
            return false;
        }
        return true;
    }

    public ItemStack[] getLaunchCost() {
        if (this.launchCost == null) {
            this.updateLaunchCost();
        }
        return this.launchCost;
    }

    public Array<ItemStack> getStartingItems() {
        return this.startingItems;
    }

    public void resetStartingItems() {
        this.startingItems.clear();
        this.defaultStartingItems.each(stack -> this.startingItems.add(new ItemStack(stack.item, stack.amount)));
    }

    public void updateWave(int wave) {
        int value = Core.settings.getInt(this.name + "-wave", 0);
        if (value < wave) {
            Core.settings.put(this.name + "-wave", wave);
            Vars.data.modified();
            for (Zone zone : Vars.content.zones()) {
                ZoneRequirement req = Structs.find(zone.zoneRequirements, f -> f.zone == this);
                if (req == null || wave != req.wave + 1) continue;
                Events.fire(new EventType.ZoneRequireCompleteEvent(zone, this));
            }
            if (wave == this.configureWave + 1) {
                Events.fire(new EventType.ZoneConfigureCompleteEvent(this));
            }
        }
    }

    public int bestWave() {
        return Core.settings.getInt(this.name + "-wave", 0);
    }

    public boolean isCompleted() {
        return this.bestWave() >= this.conditionWave;
    }

    public void updateLaunchCost() {
        Array stacks = new Array();
        Consumer<ItemStack> adder = stack -> {
            for (ItemStack other : stacks) {
                if (other.item != stack.item) continue;
                other.amount += stack.amount;
                return;
            }
            stacks.add(new ItemStack(stack.item, stack.amount));
        };
        for (ItemStack stack2 : this.baseLaunchCost) {
            adder.accept(stack2);
        }
        for (ItemStack stack3 : this.startingItems) {
            adder.accept(stack3);
        }
        for (ItemStack stack4 : stacks) {
            if (stack4.amount >= 0) continue;
            stack4.amount = 0;
        }
        stacks.sort();
        this.launchCost = (ItemStack[])stacks.toArray(ItemStack.class);
        Core.settings.putObject(this.name + "-starting-items", this.startingItems);
        Vars.data.modified();
    }

    public boolean metCondition() {
        return Vars.state.wave >= this.conditionWave && !Vars.state.rules.attackMode;
    }

    public boolean canConfigure() {
        return this.bestWave() >= this.configureWave;
    }

    @Override
    public void init() {
        this.generator.init(this.loadout);
        Arrays.sort(this.resources);
        for (ItemStack stack : this.startingItems) {
            this.defaultStartingItems.add(new ItemStack(stack.item, stack.amount));
        }
        Array arr = Core.settings.getObject(this.name + "-starting-items", Array.class, () -> null);
        if (arr != null) {
            this.startingItems = arr;
        }
    }

    @Override
    public boolean alwaysUnlocked() {
        return this.alwaysUnlocked;
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public void displayInfo(Table table) {
    }

    @Override
    public TextureRegion getContentIcon() {
        return null;
    }

    @Override
    public String localizedName() {
        return Core.bundle.get("zone." + this.name + ".name");
    }

    @Override
    public ContentType getContentType() {
        return ContentType.zone;
    }

    public static class ZoneRequirement {
        public final Zone zone;
        public final int wave;

        public ZoneRequirement(Zone zone, int wave) {
            this.zone = zone;
            this.wave = wave;
        }

        public static ZoneRequirement[] with(Object ... objects) {
            ZoneRequirement[] out = new ZoneRequirement[objects.length / 2];
            for (int i = 0; i < objects.length; i += 2) {
                out[i / 2] = new ZoneRequirement((Zone)objects[i], (Integer)objects[i + 1]);
            }
            return out;
        }
    }
}

