/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.graphics.Color;
import io.anuke.arc.graphics.Texture;
import io.anuke.arc.graphics.g2d.Draw;
import io.anuke.arc.graphics.g2d.Lines;
import io.anuke.arc.graphics.g2d.TextureRegion;
import io.anuke.arc.scene.ui.Image;
import io.anuke.arc.scene.ui.layout.Scl;
import io.anuke.mindustry.graphics.Pal;

public class BorderImage
extends Image {
    public float thickness = 4.0f;
    public Color borderColor = Pal.gray;

    public BorderImage() {
    }

    public BorderImage(Texture texture) {
        super(texture);
    }

    public BorderImage(Texture texture, float thick) {
        super(texture);
        this.thickness = thick;
    }

    public BorderImage(TextureRegion region, float thick) {
        super(region);
        this.thickness = thick;
    }

    public BorderImage border(Color color) {
        this.borderColor = color;
        return this;
    }

    @Override
    public void draw() {
        super.draw();
        float scaleX = this.getScaleX();
        float scaleY = this.getScaleY();
        Draw.color(this.borderColor);
        Draw.alpha(this.parentAlpha);
        Lines.stroke(Scl.scl(this.thickness));
        Lines.rect(this.x + this.imageX, this.y + this.imageY, this.imageWidth * scaleX, this.imageHeight * scaleY);
        Draw.reset();
    }
}

