/*
 * Decompiled with CFR 0.152.
 */
package io.anuke.mindustry.ui;

import io.anuke.arc.Core;
import io.anuke.arc.collection.Array;
import io.anuke.arc.collection.OrderedMap;
import io.anuke.arc.graphics.Color;
import io.anuke.arc.scene.ui.layout.Table;
import io.anuke.arc.util.Strings;
import io.anuke.mindustry.graphics.Pal;
import io.anuke.mindustry.type.Item;
import io.anuke.mindustry.type.Liquid;
import io.anuke.mindustry.type.Mech;
import io.anuke.mindustry.type.UnitType;
import io.anuke.mindustry.world.Block;
import io.anuke.mindustry.world.meta.BlockStat;
import io.anuke.mindustry.world.meta.BlockStats;
import io.anuke.mindustry.world.meta.StatCategory;
import io.anuke.mindustry.world.meta.StatValue;

public class ContentDisplay {
    public static void displayBlock(Table table, Block block) {
        table.table(title -> {
            int size = 48;
            title.addImage(block.icon(Block.Icon.large)).size(size);
            title.add("[accent]" + block.localizedName).padLeft(5.0f);
        });
        table.row();
        table.addImage().height(3.0f).color(Color.lightGray).pad(8.0f).padLeft(0.0f).padRight(0.0f).fillX();
        table.row();
        if (block.description != null) {
            table.add(block.description).padLeft(5.0f).padRight(5.0f).width(400.0f).wrap().fillX();
            table.row();
            table.addImage().height(3.0f).color(Color.lightGray).pad(8.0f).padLeft(0.0f).padRight(0.0f).fillX();
            table.row();
        }
        BlockStats stats = block.stats;
        for (StatCategory cat : stats.toMap().keys()) {
            OrderedMap map = (OrderedMap)stats.toMap().get(cat);
            if (map.size == 0) continue;
            table.add("$category." + cat.name()).color(Pal.accent).fillX();
            table.row();
            for (BlockStat stat : map.keys()) {
                table.table(inset -> {
                    inset.left();
                    inset.add("[LIGHT_GRAY]" + stat.localized() + ":[] ");
                    Array arr = (Array)map.get(stat);
                    for (StatValue value : arr) {
                        value.display((Table)inset);
                        inset.add().size(10.0f);
                    }
                }).fillX().padLeft(10.0f);
                table.row();
            }
        }
    }

    public static void displayItem(Table table, Item item) {
        table.table(title -> {
            title.addImage(item.getContentIcon()).size(48.0f);
            title.add("[accent]" + item.localizedName()).padLeft(5.0f);
        });
        table.row();
        table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
        table.row();
        if (item.description != null) {
            table.add(item.description).padLeft(5.0f).padRight(5.0f).width(400.0f).wrap().fillX();
            table.row();
            table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
            table.row();
        }
        table.left().defaults().fillX();
        table.add(Core.bundle.format("item.explosiveness", (int)(item.explosiveness * 100.0f)));
        table.row();
        table.add(Core.bundle.format("item.flammability", (int)(item.flammability * 100.0f)));
        table.row();
        table.add(Core.bundle.format("item.radioactivity", (int)(item.radioactivity * 100.0f)));
        table.row();
    }

    public static void displayLiquid(Table table, Liquid liquid) {
        table.table(title -> {
            title.addImage(liquid.getContentIcon()).size(48.0f);
            title.add("[accent]" + liquid.localizedName()).padLeft(5.0f);
        });
        table.row();
        table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
        table.row();
        if (liquid.description != null) {
            table.add(liquid.description).padLeft(5.0f).padRight(5.0f).width(400.0f).wrap().fillX();
            table.row();
            table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
            table.row();
        }
        table.left().defaults().fillX();
        table.add(Core.bundle.format("item.explosiveness", (int)(liquid.explosiveness * 100.0f)));
        table.row();
        table.add(Core.bundle.format("item.flammability", (int)(liquid.flammability * 100.0f)));
        table.row();
        table.add(Core.bundle.format("liquid.heatcapacity", (int)(liquid.heatCapacity * 100.0f)));
        table.row();
        table.add(Core.bundle.format("liquid.temperature", (int)(liquid.temperature * 100.0f)));
        table.row();
        table.add(Core.bundle.format("liquid.viscosity", (int)(liquid.viscosity * 100.0f)));
        table.row();
    }

    public static void displayMech(Table table, Mech mech) {
        table.table(title -> {
            title.addImage(mech.getContentIcon()).size(48.0f);
            title.add("[accent]" + mech.localizedName()).padLeft(5.0f);
        });
        table.left().defaults().left();
        table.row();
        table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
        table.row();
        if (mech.description != null) {
            table.add(mech.description).padLeft(5.0f).padRight(5.0f).width(400.0f).wrap().fillX();
            table.row();
            table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
            table.row();
        }
        table.left().defaults().fillX();
        if (Core.bundle.has("mech." + mech.name + ".weapon")) {
            table.add(Core.bundle.format("mech.weapon", Core.bundle.get("mech." + mech.name + ".weapon")));
            table.row();
        }
        if (Core.bundle.has("mech." + mech.name + ".ability")) {
            table.add(Core.bundle.format("mech.ability", Core.bundle.get("mech." + mech.name + ".ability")));
            table.row();
        }
        table.add(Core.bundle.format("mech.buildspeed", (int)(mech.buildPower * 100.0f)));
        table.row();
        table.add(Core.bundle.format("mech.health", (int)mech.health));
        table.row();
        table.add(Core.bundle.format("mech.itemcapacity", mech.itemCapacity));
        table.row();
        if (mech.drillPower > 0) {
            table.add(Core.bundle.format("mech.minespeed", (int)(mech.mineSpeed * 100.0f)));
            table.row();
            table.add(Core.bundle.format("mech.minepower", mech.drillPower));
            table.row();
        }
    }

    public static void displayUnit(Table table, UnitType unit) {
        table.table(title -> {
            title.addImage(unit.getContentIcon()).size(48.0f);
            title.add("[accent]" + unit.localizedName()).padLeft(5.0f);
        });
        table.row();
        table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
        table.row();
        if (unit.description != null) {
            table.add(unit.description).padLeft(5.0f).padRight(5.0f).width(400.0f).wrap().fillX();
            table.row();
            table.addImage().height(3.0f).color(Color.lightGray).pad(15.0f).padLeft(0.0f).padRight(0.0f).fillX();
            table.row();
        }
        table.left().defaults().fillX();
        table.add(Core.bundle.format("unit.health", Float.valueOf(unit.health)));
        table.row();
        table.add(Core.bundle.format("unit.speed", Strings.fixed(unit.speed, 1)));
        table.row();
        table.row();
    }
}

